#include <stdio.h>
#include <stdarg.h>

#if defined(LOG_FILE) || defined(LOG_STDERR)

#define FILENAME "/tmp/1.log"
#ifdef LOG_FILE
static int first = 1;
static FILE *log_fd=NULL;
#else
static FILE *log_fd=stderr;
#endif

void log_f(const char *fmt, ...)
{
    	va_list args;
    	char *format;
    	char str[1024] ;

#ifdef LOG_FILE
	if (first==1) {
		log_fd = fopen(FILENAME,"w");
		first = 0;
	} else {
		log_fd=fopen(FILENAME,"a+");
	}
#endif

	va_start(args, fmt);
	if (log_fd!=NULL)
        	fprintf(log_fd, str, vsnprintf (str, sizeof(str), fmt, args));
    	va_end(args);
    	fclose(log_fd);

    	return;
}
#else /* !(LOG_FILE || LOG_STDERR) */

void log_f(const char *fmt, ...)
{
}

#endif /* !(LOG_FILE || LOG_STDERR) */
