#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <dlfcn.h>

#include "indic_input.h"
#include "xaux_locale.h"
#include "encode.h"

#define MAX_LINE_LEN	256

typedef unsigned short UTFCHAR;

IMEEngineRec 	*gEngine_Info[MAX_ENGINE_NUM];
IMEModeList *modeList[MAX_ENGINE_NUM];
LocaleList *localeList;

keyvalue_pair kvp[] = {
  {(char *)"IM_SHIFT_MASK", 1},
  {(char *)"IM_CTRL_MASK", 2},
  {(char *)"IM_META_MASK", 4},
  {(char *)"IM_ALT_MASK", 8},
  {(char *)"IM_ALT_GRAPH_MASK", 16},
  {(char *)"IM_BUTTON1_MASK", 32},
  {(char *)"IM_VK_CANCEL", 	3},
  {(char *)"IM_VK_CLEAR", 	12},
  {(char *)"IM_VK_SHIFT", 	16},
  {(char *)"IM_VK_CONTROL", 	17},
  {(char *)"IM_VK_ALT", 	18},
  {(char *)"IM_VK_PAUSE", 	19},
  {(char *)"IM_VK_CAPS_LOCK", 	20},
  {(char *)"IM_VK_ESCAPE", 	27},
  {(char *)"IM_VK_SPACE", 	32},
  {(char *)"IM_VK_PAGE_UP", 	33},
  {(char *)"IM_VK_PAGE_DOWN", 	34},
  {(char *)"IM_VK_END", 	35},
  {(char *)"IM_VK_HOME", 	36},
  {(char *)"IM_VK_LEFT", 	37},
  {(char *)"IM_VK_UP", 	38},
  {(char *)"IM_VK_RIGHT", 	39},
  {(char *)"IM_VK_DOWN", 	40},
  {(char *)"IM_VK_COMMA", 	44},
  {(char *)"IM_VK_MINUS", 	45},
  {(char *)"IM_VK_PERIOD", 	46},
  {(char *)"IM_VK_SLASH", 	47},
  {(char *)"IM_VK_0", 	48},
  {(char *)"IM_VK_1", 	49},
  {(char *)"IM_VK_2", 	50},
  {(char *)"IM_VK_3", 	51},
  {(char *)"IM_VK_4", 	52},
  {(char *)"IM_VK_5", 	53},
  {(char *)"IM_VK_6", 	54},
  {(char *)"IM_VK_7", 	55},
  {(char *)"IM_VK_8", 	56},
  {(char *)"IM_VK_9", 	57},
  {(char *)"IM_VK_SEMICOLON", 	59},
  {(char *)"IM_VK_EQUALS", 	61},
  {(char *)"IM_VK_A", 	65},
  {(char *)"IM_VK_B", 	66},
  {(char *)"IM_VK_C", 	67},
  {(char *)"IM_VK_D", 	68},
  {(char *)"IM_VK_E", 	69},
  {(char *)"IM_VK_F", 	70},
  {(char *)"IM_VK_G", 	71},
  {(char *)"IM_VK_H", 	72},
  {(char *)"IM_VK_I", 	73},
  {(char *)"IM_VK_J", 	74},
  {(char *)"IM_VK_K", 	75},
  {(char *)"IM_VK_L", 	76},
  {(char *)"IM_VK_M", 	77},
  {(char *)"IM_VK_N", 	78},
  {(char *)"IM_VK_O", 	79},
  {(char *)"IM_VK_P", 	80},
  {(char *)"IM_VK_Q", 	81},
  {(char *)"IM_VK_R", 	82},
  {(char *)"IM_VK_S", 	83},
  {(char *)"IM_VK_T", 	84},
  {(char *)"IM_VK_U", 	85},
  {(char *)"IM_VK_V", 	86},
  {(char *)"IM_VK_W", 	87},
  {(char *)"IM_VK_X", 	88},
  {(char *)"IM_VK_Y", 	89},
  {(char *)"IM_VK_Z", 	90},
  {(char *)"IM_VK_OPEN_BRACKET", 	91},
  {(char *)"IM_VK_BACK_SLASH", 	92},
  {(char *)"IM_VK_CLOSE_BRACKET", 	93},
  {(char *)"IM_VK_NUMPAD0", 	96},
  {(char *)"IM_VK_NUMPAD1", 	97},
  {(char *)"IM_VK_NUMPAD2", 	98},
  {(char *)"IM_VK_NUMPAD3", 	99},
  {(char *)"IM_VK_NUMPAD4", 	100},
  {(char *)"IM_VK_NUMPAD5", 	101},
  {(char *)"IM_VK_NUMPAD6", 	102},
  {(char *)"IM_VK_NUMPAD7", 	103},
  {(char *)"IM_VK_NUMPAD8", 	104},
  {(char *)"IM_VK_NUMPAD9", 	105},
  {(char *)"IM_VK_MULTIPLY", 	106},
  {(char *)"IM_VK_ADD", 	107},
  {(char *)"IM_VK_SEPARATER", 	108},
  {(char *)"IM_VK_SUBTRACT", 	109},
  {(char *)"IM_VK_DECIMAL", 	110},
  {(char *)"IM_VK_DIVIDE", 	111},
  {(char *)"IM_VK_DELETE", 	127},
  {(char *)"IM_VK_NUM_LOCK", 	144},
  {(char *)"IM_VK_SCROLL_LOCK", 	145},
  {(char *)"IM_VK_F1", 	112},
  {(char *)"IM_VK_F2", 	113},
  {(char *)"IM_VK_F3", 	114},
  {(char *)"IM_VK_F4", 	115},
  {(char *)"IM_VK_F5", 	116},
  {(char *)"IM_VK_F6", 	117},
  {(char *)"IM_VK_F7", 	118},
  {(char *)"IM_VK_F8", 	119},
  {(char *)"IM_VK_F9", 	120},
  {(char *)"IM_VK_F10", 	121},
  {(char *)"IM_VK_F11", 	122},
  {(char *)"IM_VK_F12", 	123},
  {(char *)"IM_VK_F13", 	61440},
  {(char *)"IM_VK_F14", 	61441},
  {(char *)"IM_VK_F15", 	61442},
  {(char *)"IM_VK_F16", 	61443},
  {(char *)"IM_VK_F17", 	61444},
  {(char *)"IM_VK_F18", 	61445},
  {(char *)"IM_VK_F19", 	61446},
  {(char *)"IM_VK_F20", 	61447},
  {(char *)"IM_VK_F21", 	61448},
  {(char *)"IM_VK_F22", 	61449},
  {(char *)"IM_VK_F23", 	61450},
  {(char *)"IM_VK_F24", 	61451},
  {(char *)"IM_VK_PRINTSCREEN", 	154},
  {(char *)"IM_VK_INSERT", 	155},
  {(char *)"IM_VK_HELP", 	156},
  {(char *)"IM_VK_META", 	157},
  {(char *)"IM_VK_BACK_QUOTE", 	192},
  {(char *)"IM_VK_QUOTE", 	222},
  {(char *)"IM_VK_KP_UP", 	224},
  {(char *)"IM_VK_KP_DOWN", 	225},
  {(char *)"IM_VK_KP_LEFT", 	226},
  {(char *)"IM_VK_KP_RIGHT", 	227},
  {(char *)"IM_VK_DEAD_GRAVE", 	128},
  {(char *)"IM_VK_DEAD_ACUTE", 	129},
  {(char *)"IM_VK_DEAD_CIRCUMFLEX", 	130},
  {(char *)"IM_VK_DEAD_TILDE", 	131},
  {(char *)"IM_VK_DEAD_MACRON", 	132},
  {(char *)"IM_VK_DEAD_BREVE", 	133},
  {(char *)"IM_VK_DEAD_ABOVEDOT", 	134},
  {(char *)"IM_VK_DEAD_DIAERESIS", 	135},
  {(char *)"IM_VK_DEAD_ABOVERING", 	136},
  {(char *)"IM_VK_DEAD_DOUBLEACUTE", 	137},
  {(char *)"IM_VK_DEAD_CARON", 	138},
  {(char *)"IM_VK_DEAD_CEDILLA", 	139},
  {(char *)"IM_VK_DEAD_OGONEK", 	140},
  {(char *)"IM_VK_DEAD_IOTA", 	141},
  {(char *)"IM_VK_DEAD_VOICED_SOUND", 	142},
  {(char *)"IM_VK_DEAD_SEMIVOICED_SOUND", 	143},
  {(char *)"IM_VK_AMPERSAND", 	150},
  {(char *)"IM_VK_ASTERISK", 	151},
  {(char *)"IM_VK_QUOTEDBL", 	152},
  {(char *)"IM_VK_LESS", 	153},
  {(char *)"IM_VK_GREATER", 	160},
  {(char *)"IM_VK_BRACELEFT", 	161},
  {(char *)"IM_VK_BRACERIGHT", 	162},
  {(char *)"IM_VK_AT", 	512},
  {(char *)"IM_VK_COLON", 	513},
  {(char *)"IM_VK_CIRCUMFLEX", 	514},
  {(char *)"IM_VK_DOLLAR", 	515},
  {(char *)"IM_VK_EURO_SIGN", 	516},
  {(char *)"IM_VK_EXCLAMATION_MARK", 	517},
  {(char *)"IM_VK_INVERTED_EXCLAMATION_MARK", 	518},
  {(char *)"IM_VK_LEFT_PARENTHESIS", 	519},
  {(char *)"IM_VK_NUMBER_SIGN", 	520},
  {(char *)"IM_VK_PLUS", 	521},
  {(char *)"IM_VK_RIGHT_PARENTHESIS", 	522},
  {(char *)"IM_VK_UNDERSCORE", 	523},
  {(char *)"IM_VK_FINAL", 	24},
  {(char *)"IM_VK_CONVERT", 	28},
  {(char *)"IM_VK_NONCONVERT", 	29},
  {(char *)"IM_VK_ACCEPT", 	30},
  {(char *)"IM_VK_MODECHANGE", 	31},
  {(char *)"IM_VK_KANA", 	21},
  {(char *)"IM_VK_KANJI", 	25},
  {(char *)"IM_VK_ALPHANUMERIC", 	240},
  {(char *)"IM_VK_KATAKANA", 	241},
  {(char *)"IM_VK_HIRAGANA", 	242},
  {(char *)"IM_VK_FULL_WIDTH", 	243},
  {(char *)"IM_VK_HALF_WIDTH", 	244},
  {(char *)"IM_VK_ROMAN_CHARACTERS", 	245},
  {(char *)"IM_VK_ALL_CANDIDATES", 	256},
  {(char *)"IM_VK_PREVIOUS_CANDIDATE", 	257},
  {(char *)"IM_VK_CODE_INPUT", 	258},
  {(char *)"IM_VK_JAPANESE_KATAKANA", 	259},
  {(char *)"IM_VK_JAPANESE_HIRAGANA", 	260},
  {(char *)"IM_VK_JAPANESE_ROMAN", 	261},
  {(char *)"IM_VK_CUT", 	65489},
  {(char *)"IM_VK_COPY", 	65485},
  {(char *)"IM_VK_PASTE", 	65487},
  {(char *)"IM_VK_UNDO", 	65483},
  {(char *)"IM_VK_AGAIN", 	65481},
  {(char *)"IM_VK_FIND", 	65488},
  {(char *)"IM_VK_PROPS", 	65482},
  {(char *)"IM_VK_STOP", 	65480},
  {(char *)"IM_VK_COMPOSE", 	65312},
  {(char *)"IM_VK_ALT_GRAPH", 	65406},
  {(char *)"IM_VK_UNDEFINED", 	0},
  {0, 0}
};

/* 
read profile from file "sysime.cfg" to memory buffer   
the struct of sysime.cfg is as follow:

# comments
# engine_options can be the path of the dictionary or options that
# the engine can recognize.
[ GENERIC_CODETABLE ]

[ locale_name ]
	engine_name		engine_path	

for example:
[ HINDI ]  
	trans	common/ctim.so 
  iscii common/ctim.so 

[ TAMIL ]  
	trans	common/ctim.so 
  iscii common/ctim.so 

*/ 

void get_ime_line(FILE *fd, char *line);
int set_keyvalues(char *buf, char *Lname);

void  getNEngineIds(){
  int i,j;
  int sflag,eflag;

  for(i=0; i<locale_Num; i++){
    sflag=0;
    eflag=0;
    for(j=0; j<gEngine_Num; j++) {
      if(!strcmp(localeList[i].locale_name, modeList[j]->locale_name)){
        if(!sflag){
          localeList[i].firstEngineId = modeList[j]->engine_id;
          sflag=1;
        }
        localeList[i].nEngineId++;
        if((i == (locale_Num - 1)) && (j == (gEngine_Num -1)))
          localeList[i].lastEngineId = modeList[j]->engine_id;
      }else{
        if(sflag && !eflag){
          localeList[i].lastEngineId = modeList[j-1]->engine_id;
          eflag=1;
        }
      }
    }
  }

  for(i=0; i<locale_Num; i++)
    log_f("getNEngineIds: locale_name [%s], start [%d], last [%d], nEngineIds [%d]\n",localeList[i].locale_name, localeList[i].firstEngineId, localeList[i].lastEngineId, localeList[i].nEngineId);
}

void  print_core()
{
     	int i;

     	log_f("gEngine_Num:%d\n", gEngine_Num);
     	for (i=0; i<gEngine_Num; i++) {
          	log_f("localeid:%d, imid:%d, ename:%s, lname: %s, cname:%s, status:%d\n", 
 			gEngine_Info[i]->core.baseinfo.locale_id,
			gEngine_Info[i]->core.baseinfo.engine_id,
 			gEngine_Info[i]->core.baseinfo.ename,
			gEngine_Info[i]->core.baseinfo.lname,
			gEngine_Info[i]->core.baseinfo.cname,
			gEngine_Info[i]->core.baseinfo.status);
	}
     	for (i=0; i<gEngine_Num; i++) {
        log_f("print_core: locale_name [%s], engine_name [%s], engine_id [%d]\n",modeList[i]->locale_name, modeList[i]->engine_name, modeList[i]->engine_id);
        log_f("print_core: nlocale_name [%s], nlayout_name [%s]\n",modeList[i]->nlocale_name, modeList[i]->nlayout_name);
      }
      log_f("print_core: localeNameKeyCode [%d] \n",localeNameKeyCode);
      log_f("print_core: localeNameModifier [%d] \n",localeNameModifier);
      log_f("print_core: layoutNameKeyCode [%d] \n",layoutNameKeyCode);
      log_f("print_core: layoutNameModifier [%d] \n",layoutNameModifier);
}

int  indic_input_init()
{
    	char            file_name[256], line[MAX_LINE_LEN]; 
	char		*engine_name, *engine_path, *engine_options;
	char		*keycode_name, *modifier_name;
  char keyCodeName[256], modifierName[256];
	char		locale_name[128], *kptr, *ptr;
    
	int  		len, i;
	int		locale_flag = ENCODE_ERROR;
  int generic_flag = 0;
  int switch_locale_flag = 0;
  int switch_layout_flag = 0;
	FILE 		*fd;

      locale_Num = 0;
      localeNameKeyCode = 0;
      localeNameModifier = 0;
      layoutNameKeyCode = 0;
      layoutNameModifier = 0;
    	gEngine_Num = 0;
      localeList = (LocaleList *)NULL;
       memset((char *)keyCodeName,'\0',sizeof(keyCodeName));
       memset((char *)modifierName,'\0',sizeof(modifierName));
	for (i=0; i<MAX_ENGINE_NUM; i++)
		gEngine_Info[i] = NULL;

    	sprintf(file_name, "%s/%s/%s",  DEFAULT_ENGINE_PATH, 
					XAUX_LOCALE_NAME, 
					SYSTEM_PROFILE_NAME);

    	log_f("file name :%s\n",file_name);
	fd = fopen(file_name, "r");
	if (! fd)
		return (-1);

	do {
		get_ime_line(fd, line);

		if (line[0] == '\0') break;
		if (line[0] == '#') continue;

		len = strlen(line);
		if (line[0] == '[' && line[len-1] == ']') {
			/* compute locale_flag */
			ptr = line + 1;
			while(isspace(*ptr)) ptr++;

      memset((char *)locale_name,'\0',sizeof(locale_name));
			/* get locale section name */
			kptr = locale_name;
			while (*ptr && !isspace(*ptr) && *ptr!=']') 
				*(kptr++) = *(ptr++);
			*kptr = '\0';

			/* get locale section name */
			if (!strcasecmp(locale_name, COMMON_ENGINE_PATH))
				locale_flag = ENCODES_NUM;
			else if(!strcasecmp(locale_name, GENERIC_CODETABLE_NAME)){
          generic_flag = 1;
          continue;
      }else if(!strcasecmp(locale_name, SWITCH_LOCALE_NAME)){
          switch_locale_flag = 1;
          continue;
      }else if(!strcasecmp(locale_name, SWITCH_LAYOUT_NAME)){
          switch_layout_flag = 1;
          continue;
      }else {
         if(!switch_locale_flag && (localeNameKeyCode == 0 && localeNameModifier == 0)){
           log_f("SWITCH_LOCALE_NAME is wrong in sysime.cfg\n");
           localeNameKeyCode = 116;
           localeNameModifier = 0;
           continue;
         }else if(!switch_layout_flag && (layoutNameKeyCode == 0 && layoutNameModifier == 0)){
            log_f("SWITCH_LAYOUT_NAME is wrong in sysime.cfg \n");
            layoutNameKeyCode = 117;
            layoutNameModifier = 0;
            continue;
          }
      }

      if(!generic_flag)
				  locale_flag = get_encodeid_from_locale(locale_name);
      else{
				locale_flag = ENCODES_NUM;
        if(!localeList){
          localeList = (LocaleList *)calloc(1, sizeof(LocaleList));
        }else{
           localeList = (LocaleList *) realloc((LocaleList *)localeList,
                                        (locale_Num+1)*sizeof(LocaleList));
        }
        if(!localeList)
          log_f("Error in calloc/realloc for LocaleList \n");

        localeList[locale_Num].locale_name = (char *)strdup(locale_name);
        localeList[locale_Num].nEngineId = 0;
        log_f("localeList[%d].locale_name [%s]\n",locale_Num, localeList[locale_Num].locale_name);
        locale_Num++;
      }
			log_f("locale_name:%s, locale_id:%d\n", locale_name, locale_flag);
			continue;
		}

    if (!strcasecmp(locale_name, SWITCH_LOCALE_NAME)){
      if(switch_locale_flag){
         log_f("LOCALE: locale_name <%s>\n",locale_name);
         set_keyvalues(line, locale_name);
         switch_locale_flag = 0;
         continue;
      }
    }

    if (!strcasecmp(locale_name, SWITCH_LAYOUT_NAME)){
      if (switch_layout_flag){
        log_f("LAYOUT: locale_name <%s>\n",locale_name);
        set_keyvalues(line, locale_name);
        switch_layout_flag = 0;
        continue;
      }
    }

		if (locale_flag == ENCODE_ERROR) continue;

		/* get IME language engine name */
		ptr = line;
		engine_name = line;
		while (*ptr && !isspace(*ptr)) ptr++;
		if (*ptr) {
			*ptr = '\0';
			ptr++;
		}
		
		while (*ptr && isspace(*ptr)) ptr++;
		engine_path = ptr;

		while (*ptr && !isspace(*ptr)) ptr++;
		if (*ptr) {
			*ptr = '\0';
			ptr++;
		}
		
		while (*ptr && isspace(*ptr)) ptr++;
		engine_options = ptr;

		log_f("locale_id:%d, locale:%s, Engine Name:%s\n", locale_flag, locale_name, engine_name);
		log_f("Engine Path: %s, Engine Options: %s\n", engine_path, engine_options);

		open_engine(locale_flag, locale_name, 
			    engine_name, engine_path, engine_options);

	} while (1);

  if ((localeNameKeyCode == 0) && (localeNameModifier == 0)){
    log_f("Switch Locale entry not present in sysime.cfg \n");
    localeNameKeyCode = 116;
    localeNameModifier = 0;
  }

  if ((layoutNameKeyCode == 0) && (layoutNameModifier == 0)){
    log_f("Switch Layout entry not present in sysime.cfg \n");
    layoutNameKeyCode = 117;
    layoutNameModifier = 0;
  }

	fclose(fd);

  getNEngineIds();
  print_core();

    	return 0;
}

void get_ime_line(FILE *fd, char *line)
{
	int line_ptr;
	char line_buf[256], *ptr;

	line_ptr = 0;
	line[0] = '\0';

	/* get line with no space */
 	while(fgets(line_buf, 255, fd) != NULL) {
		ptr = line_buf;

		/* skip space keys */
		while(*ptr && isspace(*ptr)) ptr++;

		/* if is space line, get new line */
		if (*ptr == '\n' || *ptr == '\0')
			continue;

		while(*ptr != '\n' && *ptr != '\0' && line_ptr < MAX_LINE_LEN) 
			line[line_ptr++] = *ptr++;

		/* trim right space */
		while (isspace(line[line_ptr-1])) line_ptr--;
		line[line_ptr] = '\0';

		/* if the line end with '\', then continue read the next line */
		if (line[line_ptr-1] == '\\') {
			line_ptr--;
			line[line_ptr] = '\0';
			continue;
		}

		break;
	}
}

/* engine_options can be data_path or engine options. */
int open_engine(locale_id, locale_name, engine_name, engine_path, engine_options)
int 	locale_id;
char 	*locale_name;
char 	*engine_name;
char 	*engine_path;
char 	*engine_options;
{
     	int    		ret, i;
     	char   		file_name[256];
	char 		data_path[256];
     	struct stat 	file_buffer;

     	void   		*so_handler;
     	IMEMethods	methods;

	int 		is_codetable_engine = 0;

     	if (gEngine_Num > MAX_ENGINE_NUM) return (-1);
    
     	/* read profile from file to memory buffer  */ 
	if (*engine_path) {
		if (engine_path[0] != '/') 
			sprintf(file_name, "%s/%s/%s",  DEFAULT_ENGINE_PATH, 
							XAUX_LOCALE_NAME, 
							engine_path);
		else
			sprintf(file_name, "%s", engine_path);
	} else {
		is_codetable_engine = 1;
     		sprintf(file_name, "%s/%s/%s/%s.so", DEFAULT_ENGINE_PATH, 
						     XAUX_LOCALE_NAME, 
						     locale_name, 
						     engine_name);
	}

     	if ((stat(file_name, &file_buffer)) == -1)
     	{ 
		if (is_codetable_engine) {
       			sprintf(file_name, "%s/%s/%s/%s.so", DEFAULT_ENGINE_PATH, 
							     XAUX_LOCALE_NAME, 
							     COMMON_ENGINE_PATH, 
							     CODETABLE_ENGINE_NAME);
        		if ((stat(file_name, &file_buffer)) == -1)
               			return (-1);
     		} else {
			return (-1);
		}
	}
	log_f("so_file_name:%s\n", file_name);

     	so_handler = (void *) dlopen(file_name, RTLD_LAZY);
     	if (!so_handler) {
           	printf("can not open so file: %s\n", file_name);
           	return (-1);
     	} else {
           	methods = (IMEMethods) dlsym(so_handler, "ime_methods");
           	if (!methods) {
                	printf("can not open method tables of file:%s\n", file_name);
                	dlclose(so_handler);
                	return(-1);
           	}
     	}

	gEngine_Info[gEngine_Num] = (IMEEngineRec *)calloc(1, sizeof(IMEEngineRec));
	if (gEngine_Info[gEngine_Num] == NULL) return(0);

     	gEngine_Info[gEngine_Num]->core.baseinfo.engine_id = gEngine_Num;
     	gEngine_Info[gEngine_Num]->core.baseinfo.locale_id = locale_id;
     	gEngine_Info[gEngine_Num]->core.baseinfo.status = ENGINE_NOT_INITIATED;
     	gEngine_Info[gEngine_Num]->core.baseinfo.ename = (char *)strdup(engine_name);

     	gEngine_Info[gEngine_Num]->core.envinfo.lang_name = (char *)strdup(XAUX_LOCALE_NAME);
     	gEngine_Info[gEngine_Num]->core.envinfo.locale_name = (char *)strdup(locale_name);
     	gEngine_Info[gEngine_Num]->core.envinfo.data_path = NULL;
     	gEngine_Info[gEngine_Num]->core.envinfo.data_ptr = NULL;

	gEngine_Info[gEngine_Num]->core.keymapinfo.bSet = 0;
	for (i=0; i<MAX_KEYMAP_KEY_NUM; i++) 
		gEngine_Info[gEngine_Num]->core.keymapinfo.keymap[i] = NULL;

     	gEngine_Info[gEngine_Num]->so_handler = so_handler;
     	gEngine_Info[gEngine_Num]->so_methods = methods;

	/* IME_SetValues: set the arguments of this IME */
	ret = methods->IME_SetOptions(&(gEngine_Info[gEngine_Num]->core), engine_options);
     	if (ret == -1) {
         	printf("Not successfully set options of the input method engine:%s\n",engine_name);
         	dlclose(so_handler);
         	return(-1);
     	}

	/* IME_Init: get the status, lname, cname, encode information of this Input Method engine */
	ret = methods->IME_Init(&(gEngine_Info[gEngine_Num]->core));
     	if (ret == -1) {
         	printf("Not successfully initialize the input method engine:%s\n",engine_name);
         	dlclose(so_handler);
         	return(-1);
     	}

	modeList[gEngine_Num] = (IMEModeList *)calloc(1, sizeof(IMEModeList));
	if (modeList[gEngine_Num] == NULL) return(0);

  log_f("open_engine: nlocale_name [%s], nlayout_name [%s]\n",gEngine_Info[gEngine_Num]->core.baseinfo.lname, gEngine_Info[gEngine_Num]->core.baseinfo.cname);
  modeList[gEngine_Num]->locale_name = (char *)strdup(locale_name);
  modeList[gEngine_Num]->nlocale_name = (char *)strdup(gEngine_Info[gEngine_Num]->core.baseinfo.lname);
  modeList[gEngine_Num]->nlayout_name = (char *)strdup(gEngine_Info[gEngine_Num]->core.baseinfo.cname);
  modeList[gEngine_Num]->engine_id = gEngine_Num;
  modeList[gEngine_Num]->engine_name = (char *)strdup(engine_name);

     	gEngine_Num ++;
	return(0);
}

void indic_input_done()
{
     	int i;
	char *name;

     	for(i=0; i<gEngine_Num; i++) {
		name = gEngine_Info[i]->core.baseinfo.ename;
		if (name) free(name);

		name = gEngine_Info[i]->core.envinfo.lang_name;
		if (name) free(name);

		name = gEngine_Info[i]->core.envinfo.locale_name;
		if (name) free(name);

	 	gEngine_Info[i]->so_methods->IME_Close(&(gEngine_Info[i]->core));
         	dlclose(gEngine_Info[i]->so_handler);
		free((char *)gEngine_Info[i]);
     	}
}

int get_key_value(char *key_str){
  int i;
  for (i = 0; kvp[i].key_name != 0; i++) {
    if(!strcmp(kvp[i].key_name, key_str)){
      return kvp[i].value;
    }
  }
}

int set_keyvalues(char *buf, char *Lname){
	 char *keycode_name, *modifier_name;
   char *ptr;
   int flag;

   flag = 0;
   ptr = buf;
   keycode_name = buf;

   while (*ptr && !isspace(*ptr)){
     if (isalpha(*ptr)){
       flag = 1;
     }
     ptr++;
   }

   if (*ptr) {
     *ptr = '\0';
     ptr++;
   }

   if (!strcasecmp(Lname, SWITCH_LOCALE_NAME)){
     log_f("SWITCH_LOCALE: keycode_name <%s>\n",keycode_name);
   }else if(!strcasecmp(Lname, SWITCH_LAYOUT_NAME)){
     log_f("SWITCH_LAYOUT: keycode_name <%s>\n",keycode_name);
   }
   
   if (flag){
     if ((keycode_name[0] == 'I') && (keycode_name[1] == 'M')){
       if (!strcasecmp(Lname, SWITCH_LOCALE_NAME)){
         localeNameKeyCode = get_key_value(keycode_name);
       }else if(!strcasecmp(Lname, SWITCH_LAYOUT_NAME)){
          layoutNameKeyCode = get_key_value(keycode_name); 
       }
     }else{
       if (!strcasecmp(Lname, SWITCH_LOCALE_NAME)){
         localeNameKeyCode = (UTFCHAR)strtol(keycode_name, NULL, 16);
       }else if(!strcasecmp(Lname, SWITCH_LAYOUT_NAME)){
          layoutNameKeyCode = (UTFCHAR)strtol(keycode_name, NULL, 16);
       }
     }
   }else{
      if (!strcasecmp(Lname, SWITCH_LOCALE_NAME)){
        localeNameKeyCode = atoi(keycode_name);
      }else if(!strcasecmp(Lname, SWITCH_LAYOUT_NAME)){
         layoutNameKeyCode = atoi(keycode_name);
      }
   }

   while (*ptr && isspace(*ptr)) ptr++;
   modifier_name = ptr;

   while (*ptr && !isspace(*ptr)){
     if (isalpha(*ptr)){
       flag = 1;
     }
     ptr++;
   }
   if (*ptr) {
     *ptr = '\0';
     ptr++;
   }

   if (!strcasecmp(Lname, SWITCH_LOCALE_NAME)){
     log_f("SWITCH_LOCALE: modifier_name <%s>\n",modifier_name);
   }else if(!strcasecmp(Lname, SWITCH_LAYOUT_NAME)){
     log_f("SWITCH_LAYOUT: modifier_name <%s>\n",modifier_name);
   }

   if (flag){
     if ((modifier_name[0] == 'I') && (modifier_name[1] == 'M')){
       if (!strcasecmp(Lname, SWITCH_LOCALE_NAME)){
         localeNameModifier = get_key_value(modifier_name);
       }else if(!strcasecmp(Lname, SWITCH_LAYOUT_NAME)){
          layoutNameModifier = get_key_value(modifier_name);
       }
     }else{
       if (!strcasecmp(Lname, SWITCH_LOCALE_NAME)){
         localeNameModifier = (UTFCHAR)strtol(modifier_name, NULL, 16);
       }else if(!strcasecmp(Lname, SWITCH_LAYOUT_NAME)){
          layoutNameModifier = (UTFCHAR)strtol(modifier_name, NULL, 16);
       }
     }
   }else{
      if (!strcasecmp(Lname, SWITCH_LOCALE_NAME)){
        localeNameModifier = atoi(modifier_name);
      }else if(!strcasecmp(Lname, SWITCH_LAYOUT_NAME)){
         layoutNameModifier = atoi(modifier_name);
      }
   }
   return 1;
}
