/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "xiiimp.h"
#include "iiimpIM.h"
#include "guiIM.h"
#include "status.h"
#include "XimpIm.h"

int
CallPreeditStartCallback(XicCommon ic, XPointer p) {
  XIMCallback *cb;
  int max_len = -1;

  cb = &ic->core.preedit_attr.start_callback;
  if (cb->callback &&
      ic->core.input_style & XIMPreeditCallbacks) {
    max_len = (*(int(*)())cb->callback)(ic, cb->client_data, NULL);
    ic->ximp_icpart->cbstatus |= XIMPCBPREEDITACTIVE ;
  } else {
    XIC_GUI(ic, change_preedit)((XIC)ic, PREEDIT_START, NULL);
  }
  return max_len;
}

Bool
CallPreeditDrawCallback(XicCommon ic, XIMPreeditDrawCallbackStruct *p,
			IMFeedbackList *feedback_list) {
  XIMCallback *cb;
  cb = &ic->core.preedit_attr.draw_callback;
  if (cb->callback &&
      ic->core.input_style & XIMPreeditCallbacks) {
    (*cb->callback)((XIC)ic, cb->client_data, (XPointer)p);
  } else {
    XIMDrawTextStruct preedit_draw;
    preedit_draw.call_data = (XPointer)p;
    preedit_draw.feedback_list = feedback_list;
    XIC_GUI(ic, change_preedit)((XIC)ic, PREEDIT_DRAW,
				(XPointer)&preedit_draw);
  }
  return True;
}

Bool
CallPreeditCaretCallback(XicCommon ic, XPointer p) {
  XIMCallback *cb;
  XIMPreeditCaretCallbackStruct *call_data = (XIMPreeditCaretCallbackStruct*)p;
  cb = &ic->core.preedit_attr.caret_callback;
  if (cb->callback &&
      ic->core.input_style & XIMPreeditCallbacks) {
    (*cb->callback)((XIC)ic, cb->client_data, (XPointer)call_data);
  } else {
    XIC_GUI(ic, change_preedit)((XIC)ic, PREEDIT_CARET, (XPointer)p);
  }
  return True;
}

Bool
CallPreeditDoneCallback(XicCommon ic, XPointer p) {
  XIMCallback *cb;
  cb = &ic->core.preedit_attr.done_callback;
  if (cb->callback &&
      ic->core.input_style & XIMPreeditCallbacks) {
    (*cb->callback)((XIC)ic, cb->client_data, NULL);
    ic->ximp_icpart->cbstatus &= ~XIMPCBPREEDITACTIVE ;
  } else {
    XIC_GUI(ic, change_preedit)((XIC)ic, PREEDIT_DONE, NULL);
  }
  return True;
}

Bool
CallStatusStartCallback(XicCommon ic, XPointer p) {
  XIMCallback *cb;
  cb = &ic->core.status_attr.start_callback;
  if (cb->callback &&
      ic->core.input_style & XIMStatusCallbacks) {
    (*cb->callback)((XIC)ic, cb->client_data, NULL);
    ic->ximp_icpart->cbstatus |= XIMPCBSTATUSACTIVE ;
  } else {
    XIC_GUI(ic, change_status)((XIC)ic, STATUS_START, (XPointer)p);
  }
  return True;
}

Bool
CallStatusDrawCallback(XicCommon ic, XIMStatusDrawCallbackStruct *call_data,
		       IMFeedbackList *feedback_list) {
  XIMCallback *cb;
  cb = &ic->core.status_attr.draw_callback;

  if (cb->callback &&
      ic->core.input_style & XIMStatusCallbacks) {
    (*cb->callback)((XIC)ic, cb->client_data, (XPointer)call_data);
  } else {
    XIMDrawTextStruct status_draw;

    if (XIM_IS_SWITCH(ic->core.im)) {
      /*
	fix for 4276042:
	status strings is not [English/European] when iiim IM is off
      */
      if (!IsConversionMode(ic)) {
	Ximp_Local_Status_Reset(ic);
	return True;
      }
    }
    status_draw.call_data = (XPointer)call_data->data.text;
    status_draw.feedback_list = feedback_list;
    XIC_GUI(ic, change_status)((XIC)ic, STATUS_DRAW,
			       (XPointer)&status_draw);
  }

  /* move preedit window */
  if (ic->core.input_style & XIMPreeditNothing) {
    XIC_GUI(ic, change_preedit)((XIC)ic, PREEDIT_WIN, NULL);
  }
  return True;
}

Bool
CallStatusDoneCallback(XicCommon ic, XPointer p) {
  XIMCallback *cb;
  cb = &ic->core.status_attr.done_callback;
  if (cb->callback &&
      ic->core.input_style & XIMStatusCallbacks) {
    (*cb->callback)((XIC)ic, cb->client_data, NULL);
    ic->ximp_icpart->cbstatus &= ~XIMPCBSTATUSACTIVE ;
  } else {
    XIC_GUI(ic, change_status)((XIC)ic, STATUS_DONE, NULL);
  }
  return True;
}
