/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include "commonIM.h"
#include "guiIM.h"
#include "iiimpDL.h"
#include "popupIM.h"
#include "XimpIm.h"
#include "ximp40.h"
#include "trace_message.h"

/*
   It is our private extension to prepare for CommonIM_Error_Handler
   as an error handler for the BadWindow error caused by XSendEvent().

   The BadWindow error may occur when the connection with the input
   method server is lost when XSendEvent() is called and failed to
   send a request to the input method server.
   We assume that this condition is not fatal and an application
   can survive after the error occurs. Therefore, _IIIMP_Error_Handler
   returns without calling exit system call.

   In addtion, when an application program sets its own error handler,
   we don't call _IIIMP_Error_Handler, but calls application's
   error handler. In this case, appl_error_handler is used to store the
   pointer of the application's error handler function.
*/
static XErrorHandler appl_error_handler = (XErrorHandler)NULL;
static int
CommonIM_Error_Handler(
    Display *dpy,
    XErrorEvent *event
)
{
    extern int _XDefaultError();

    if (appl_error_handler &&
	appl_error_handler != _XDefaultError) {
	return appl_error_handler(dpy, event);
    } else {
	char buffer[BUFSIZE];
	char number[32];

	if (event->request_code < 128) {
	    if (event->error_code == BadDrawable || event->error_code == BadWindow) {
		snprintf(number, sizeof(number), "%d", event->request_code);
		XGetErrorDatabaseText(dpy, "XRequest", number,
				      "", buffer, BUFSIZE);
	    }
	    /* 4378199: Linux Htt: can not operate after WMDoc client is
	       closed on VineLinux2.0
	       Need to check client_window is valid or not before creating
	       status, preedit and lookup

	       XFactoryCheckIMWindow() uses XGetGeometry() for checking.
	       XGetGeometry() may generate BadDrawable or BadDrawable
	    */
	    if (event->error_code == BadDrawable) {
		if (!strcmp(buffer, "X_GetGeometry"))
		    return 0;
	    } else if (event->error_code == BadWindow) {
		return 0;
#if 0
		if (!strcmp(buffer, "X_SendEvent"))
		    return 0;
		if (!strcmp(buffer, "X_GetGeometry"))
		    return 0;
		if (!strcmp(buffer, "X_GetWindowAttributes"))
		    return 0;
		if (!strcmp(buffer, "X_ChangeWindowAttributes"))
		    return 0;
		if (!strcmp(buffer, "X_ClearArea"))
		    return 0;
		if (!strcmp(buffer, "X_DestroyWindow"))
		    return 0;
		if (!strcmp(buffer, "X_GetProperty"))
		    return 0;
#endif
	    }
	}
    }

    return _XDefaultError(dpy, event);
}

Status
CommonOpenIM(
    XIM xim,
    XLCd lcd,
    Display *dpy,
    XrmDatabase rdb,
    char *res_name,
    char *res_class
)
{
    XimCommon im = (XimCommon)xim;

    TRACE_MESSAGE_INIT(NULL);

    /* Open mbs->wcs and wcs->mbs converters */
    if (!(im->wtom_conv = _XlcOpenConverter(lcd, XlcNWideChar,
					    lcd, XlcNMultiByte))) {
	goto Set_Error;
    }
    if (!(im->mtow_conv = _XlcOpenConverter(lcd, XlcNMultiByte,
					    lcd, XlcNWideChar))) {
	goto Set_Error;
    }
    im->core.lcd       = lcd;
    im->core.ic_chain  = (XIC)NULL;
    im->core.display   = dpy;
    im->core.rdb       = rdb;
    im->core.res_name  = NULL;
    im->core.res_class = NULL;
    im->core.im_name   = NULL;

    if ((res_name != NULL) && (*res_name != '\0')){
	im->core.res_name  = (char *)Xmalloc(strlen(res_name)+1);
	strcpy(im->core.res_name,res_name);
    }
    if ((res_class != NULL) && (*res_class != '\0')){
	im->core.res_class = (char *)Xmalloc(strlen(res_class)+1);
	strcpy(im->core.res_class,res_class);
    }

    /* set XIMP-dependent data */
    im->ximp_impart = (XIMXimp)Ximp_OpenIM(lcd);

    /* set dynamic loadble object data */
    im->dl_impart = OpenDynamicObject(lcd);

#if 1
    /* set error handler only once */
    if (appl_error_handler == (XErrorHandler)NULL)
	appl_error_handler = XSetErrorHandler(CommonIM_Error_Handler);
#endif

    return True;

Set_Error:
    if (im)
	CommonCloseIM((XIM)im);
    return False;
}

Status
CommonCloseIM(
    XIM xim
)
{
    XIC ic;
    XimCommon im = (XimCommon)xim;

#if 0
    for (ic = xim->core.ic_chain; ic; ic = ic->core.next)
	XDestroyIC(ic);
#endif

    if (im->mtow_conv)
	_XlcCloseConverter(im->mtow_conv);

    if (im->wtom_conv)
	_XlcCloseConverter(im->wtom_conv);

    if (im->ximp_impart) {
	Ximp_CloseIM(im->ximp_impart);
    }

    if (im->popup_impart) ClosePopupIM(im);

    if (im->dl_impart) {
	CloseDynamicObject(im->dl_impart);
    }
    if (im->core.res_name) Xfree(im->core.res_name);
    if (im->core.res_class) Xfree(im->core.res_class);

    return True;
}

Status
CommonCreateIC(
    XIC xic,
    XIMArg *arg
)
{
    XicCommon ic = (XicCommon)xic;

    /* ximp icpart */
    if (!ic->ximp_icpart) {
	ic->ximp_icpart = (XICXimp)Xmalloc(sizeof(XICXimpRec));
	if (!ic->ximp_icpart) goto Error;;
	memset(ic->ximp_icpart, 0, sizeof(XICXimpRec));
    }
    if (!ic->gui_icpart) {
	if (!(ic->gui_icpart = CreateGUI(ic, arg))) goto Error;
    }
    return True;
Error:
    CommonDestroyIC((XIC)ic);
    return False;
}

Status
CommonDestroyIC(
    XIC xic
)
{
    XicCommon ic = (XicCommon)xic;
    if (ic->ximp_icpart) Xfree(ic->ximp_icpart);
    ic->ximp_icpart = 0;
    if (ic->gui_icpart) DestroyGUI(ic); /* destroy gui */
    ic->gui_icpart = 0;
    return True;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
