#include <config.h>
#ifdef HAVE_SIGNAL
#include <signal.h>
#endif
#include "IMSignal.hh"
#include "IMSvr.hh"

IMSignal* IMSignal::psinst = NULL;

/*
  handlers
 */

void
IMSignal::sighup()
{
    psvr->reload();
}

void
IMSignal::term()
{
    psvr->terminate();
    delete this;
}

/*
  management functions.
 */

void
signal_handler(
    int num
)
{
    IMSignal *pims = IMSignal::get_instance();
    IMSignal_handler ph;

    if (!pims) return;
    ph = pims->getfunc(num);
    if (!ph) return;
    (pims->*ph)();
    return;
}

IMSignal_handler
IMSignal::getfunc(
    int num
)
{
    IMSignalHandlerMap::iterator i;

    i = hmap.find(num);
    if (i == hmap.end()) return NULL;

    return i->second;
}

void
IMSignal::add(
    int num,
    IMSignal_handler h
)
{
    hmap[num] = h;
#ifdef HAVE_SIGNAL
    ::signal(num, signal_handler);
#endif
}

void
IMSignal::ignore(
    int num
)
{
    hmap[num] = NULL;
#ifdef HAVE_SIGNAL
    ::signal(num, SIG_IGN);
#endif
}

IMSignal::IMSignal(
    IMSvr *pimsvr
) : psvr(pimsvr)
{
    add(SIGHUP, &IMSignal::sighup);
    add(SIGINT, &IMSignal::term);
    ignore(SIGPIPE);
}

IMSignal*
IMSignal::construct(
    IMSvr *pimsvr
)
{
    if (psinst) return psinst;
    psinst = new IMSignal(pimsvr);

    return psinst;
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
