/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef IMAUTH_HH_
#define IMAUTH_HH_

#include <stdlib.h>
#include <string.h>

class symbol_mapper
{
  private:
    struct sym {
	char *symname;
	char *value;
    };
    int alloced_size;
    int size;
    sym *psym;
    void expand_psym_slot(
	int aSize
    )
    { 
	psym = (sym*) realloc(psym, sizeof(sym) * aSize);
	alloced_size = aSize;
    }
  
public:
    void set_symbol_value(
	const char *sn,
	const char *val
    )
    {
	int i;
	if (size >= alloced_size)
	    expand_psym_slot(size * 2);
	psym[size].symname = strdup(sn);
	psym[size].value = strdup(val);
	size++;
    }
    char *get_symbol_value(const char *sn)
    {
	int i;
	for (i = 0;i < size;i++)
	    if (!strcmp(sn, psym[i].symname))
		return psym[i].value;
	return NULL;
    }
    symbol_mapper()
    {
	size = 0;
	alloced_size = 10;
	psym = (sym*) malloc(sizeof(sym) * alloced_size);
    }
    ~symbol_mapper()
    {
	int i;
	for (i = 0;i < size;i++) {
	    if (psym[i].symname) free(psym[i].symname);
	    if (psym[i].value) free(psym[i].value);
	}
	free(psym);
    }
};

class IMAuth
{
  public:
    enum pattern_type {
	    HOSTNAME,
	    ADDR,
	    ADDR6
    };
    enum access_type {
	    PERMIT,
	    DENY,
	    CHECKUSER,
	    PASSWORD,
	    NO_ENTRY,
	    UNKNOWN
    };
private:
    struct auth_entry {
	pattern_type pt;
	access_type at;
	char *host_pattern;
	int *addr_pattern;
	int bitlen;
    };

  int ae_num;
  int alloced_ae_num;
  auth_entry *pae;
  access_type def_at;
  symbol_mapper sm;

    int adjust_pae_slot_size(
	int newsize
    );

    int *from_address;
    int from_address_bitlen;
    char *from_hostname;

    char *command_name;
    char *domainname;
    int set_hostinfo();

    pattern_type check_pattern_type(
	const char *pat
    );

    int match_hostname_entry(
	const char *pat,
	const char *hostname
    );
    char *normalize_hostname_pattern(
	const char *pat
    );
    int addr_element_to_number(
	const char **addr
    );
    int store_addr_pattern(
	const char *pattern,
	int *addr_pattern
    );
    int match_addr46_entry(
	const int *pat,
	int patbitlen,
	const int *addr,
	int addrbitlen
    );
    int addr6_element_to_number(
	const char **addr
    );
    int store_addr6_pattern(
	const char *pattern,
	int *addr_pattern
    );
    int match_entry(auth_entry *p);

    access_type get_access_type(int fd);

  protected:
    virtual int set_fd_from(int fd);
    virtual int check_password(
	const char *user,
	const char *password
    ) { return 0; }
    char *get_command_name()
    { return command_name; }
    char *get_from_hostname()
    { return from_hostname; }

public:
    int set_entry(
	const char *pattern,
	access_type at
    );
    int set_default_entry(
	access_type at
    );
    void set_command_name(
	const char *cmdname
    );
    int clear_all_entries();
    int fd_ok(
	int fd
    );
    int auth_fd(
	int fd,
	const char *user = NULL,
	const char *password = NULL
    );

    IMAuth();
    virtual ~IMAuth();
};

#endif /* IMAUTH_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
