/*
 *  IHU -- I Hear U, easy VoIP application using Speex and Qt
 *
 *  Copyright (C) 2003-2005 M. Trotta - <mrotta@users.sourceforge.net>
 *
 *  http://ihu.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

#include "Config.hpp"
#include <qdir.h>

Config& Config::instance()
{
	static ConfigPtr i(new Config);
	return *i;
}

Config::Config()
{
	setDefault("/ihu/general/name", "");
	setDefault("/ihu/general/dumpin", "");
	setDefault("/ihu/general/dumpout", "");
	setDefault("/ihu/general/answer", IHU_DEFAULT_ANSWER);
	setDefault("/ihu/general/tray", IHU_DEFAULT_TRAY);
	setDefault("/ihu/general/autowait", IHU_DEFAULT_WAIT);
	setDefault("/ihu/general/autohide", IHU_DEFAULT_HIDE);
	setDefault("/ihu/host/default","");
	setDefault("/ihu/net/udp", IHU_DEFAULT_UDP);
	setDefault("/ihu/net/tcp", IHU_DEFAULT_TCP);
	setDefault("/ihu/net/protocol", IHU_DEFAULT_PROTOCOL);
	setDefault("/ihu/net/inport",IHU_DEFAULT_INPORT);
	setDefault("/ihu/net/outport",IHU_DEFAULT_OUTPORT);
	setDefault("/ihu/sound/inputdriver", IHU_DEFAULT_INDRIVER);
	setDefault("/ihu/sound/outputdriver", IHU_DEFAULT_OUTDRIVER);
	setDefault("/ihu/sound/inputinterface", IHU_DEFAULT_INTERFACE);
	setDefault("/ihu/sound/outputinterface", IHU_DEFAULT_INTERFACE);
	setDefault("/ihu/sound/threshold", IHU_DEFAULT_THRESHOLD);
	setDefault("/ihu/sound/txstop", IHU_DEFAULT_TXSTOP);
	setDefault("/ihu/sound/ringvolume", IHU_DEFAULT_RINGVOLUME);
	setDefault("/ihu/sound/adr", IHU_DEFAULT_ADR);
	setDefault("/ihu/sound/adrstretch", IHU_DEFAULT_ADRSTRETCH);
	setDefault("/ihu/sound/adrmindelay", IHU_DEFAULT_ADRMINDELAY);
	setDefault("/ihu/sound/adrmaxdelay", IHU_DEFAULT_ADRMAXDELAY);
	setDefault("/ihu/sound/agc", IHU_DEFAULT_AGC);
	setDefault("/ihu/sound/agcmin", IHU_DEFAULT_AGCMIN);
	setDefault("/ihu/sound/agcmax", IHU_DEFAULT_AGCMAX);
	setDefault("/ihu/sound/agcstep", IHU_DEFAULT_AGCSTEP);
	setDefault("/ihu/sound/agclevel", IHU_DEFAULT_AGCLEVEL);
	setDefault("/ihu/speex/mode", IHU_DEFAULT_MODE);
	setDefault("/ihu/speex/bitratemode", IHU_DEFAULT_BITRATEMODE);
	setDefault("/ihu/speex/quality", IHU_DEFAULT_QUALITY);
	setDefault("/ihu/speex/complexity", IHU_DEFAULT_COMPLEXITY);
	setDefault("/ihu/speex/vbrquality", IHU_DEFAULT_VBRQUALITY);
	setDefault("/ihu/speex/abr", IHU_DEFAULT_ABR);
	setDefault("/ihu/speex/vad", IHU_DEFAULT_VAD);
	setDefault("/ihu/speex/dtx", IHU_DEFAULT_DTX);
	setDefault("/ihu/security/crypt", IHU_DEFAULT_CRYPT);
	setDefault("/ihu/security/random", IHU_DEFAULT_RANDOM);
	setDefault("/ihu/security/showkey", IHU_DEFAULT_SHOWKEY);
	setDefault("/ihu/security/keylen", IHU_DEFAULT_KEYLEN);
	setDefault("/ihu/security/logfile","");
}

void Config::setDefault(const QString& key, const char* value)
{
	writeEntry(key,readEntry(key,(const QString)value));
}

void Config::setDefault(const QString& key, const int value)
{
	writeEntry(key,readNumEntry(key,value));
}

void Config::setDefault(const QString& key, bool value)
{
	writeEntry(key,readBoolEntry(key,value));
}
