'\" t
.TH c3270 1 "16 August 2020"
.SH "NAME"
c3270 \-
curses-based 
\s-1IBM\s+1 host access tool
.SH "SYNOPSIS"
\fBc3270\fP
[\fIoptions\fP]
[\fIhost\fP]
.br
\fBc3270\fP [\fIoptions\fP] \fIsession-file\fP.c3270
.SH "DESCRIPTION"
\fBc3270\fP opens a telnet connection to an \s-1IBM\s+1
host in a console window.
It implements RFCs 2355 (TN3270E), 1576 (TN3270) and 1646 (LU name selection),
and supports IND$FILE file transfer.
If the console is capable of displaying colors, then \fBc3270\fP emulates an
\s-1IBM\s+1 3279.  Otherwise, it emulates a 3278.
The full syntax for \fIhost\fP is:
.RS
[\fIprefix\fP:]...[\fILUname\fP@]\fIhostname\fP[:\fIport\fP][=\fIaccept\fP]
.RE
.LP
Prepending a \fBP:\fP onto \fIhostname\fP causes the connection to go
through the \fItelnet-passthru\fP service rather than directly to the host.
See \s-1PASSTHRU\s+1 below.
.LP
Prepending an \fBS:\fP onto \fIhostname\fP removes the "extended data
stream" option reported to the host.
See \fB\-tn\fP below for further information.
.LP
Prepending an \fBN:\fP onto \fIhostname\fP
turns off TN3270E support for the session.
.LP
Prepending an \fBL:\fP onto \fIhostname\fP
causes \fBc3270\fP to first create a TLS tunnel to the host, and then
create a TN3270 session inside the tunnel.  (This function is supported only if
\fBc3270\fP was built with TLS support).
Note that TLS-encrypted sessions using the TELNET START-TLS option are
negotiated with the host automatically; for these sessions the \fBL:\fP prefix
should not be used.
.LP
Prepending a \fBY:\fP onto \fIhostname\fP
causes \fBc3270\fP to skip validation of host TLS certificates.
This overrides any other configuration or command-line options.
.LP
Prepending an \fBA:\fP onto \fIhostname\fP is equivalent to setting the
\fB\-nvt\fP option; it forces an NVT-mode session instead of a
3270-mode session.
.LP
A specific Logical Unit (LU) name to use may be specified by prepending it to
the \fIhostname\fP with an `\fB@\fP'.
Multiple LU names to try can be separated by commas.
An empty LU can be placed in the list with an extra comma.
(Note that the LU name is used for different purposes by different kinds of
hosts.
For example, CICS uses the LU name as the Terminal ID.)
.LP
The \fIhostname\fP may optionally be placed inside square-bracket
characters `\fB[\fP' and `\fB]\fP'.
This will prevent any colon `\fB:\fP' characters in the hostname
from being interpreted as indicating option prefixes or port numbers.
This allows numeric IPv6 addresses to be used as hostnames.
.LP
On systems that support the \fIforkpty\fP library call, the
\fIhostname\fP may be replaced with \fB\-e\fP and a command string.
This will cause \fBc3270\fP to connect to a local child process, such as
a shell.
.LP
The port to connect to defaults to
\fBtelnet\fP.
This can be overridden with the \fB\-port\fP option, or by appending
a \fIport\fP to the \fIhostname\fP with a colon
`\fB:\fP'.
(For compatability with previous versions of \fBc3270\fP
and with \fItn3270\fP(1), the \fIport\fP
may also be specified as a second, separate argument.)
.LP
An optional accept name (a hostname to accept in the host's TLS
certificate) may be specified by appending it to the hostname with an equals
sign (`\fB=\fP').
The accept name can also be specified with the \fB\-accepthostname\fP
option.

.SH "OPTIONS"
 \fBc3270\fP understands
the following options:
.TP
\fB\-accepthostname\fP \fIname\fP
Specifies a particular hostname to accept when validating the name presented
in the server SSL certificate, instead of comparing to the name
used to make the connection.
.TP
\fB\-allbold\fP
Forces all characters to be displayed in bold.
This helps with PC consoles which display non-bold characters in unreadably
dim colors.
All-bold mode is the default for color displays, but not for monochrome
displays.
.TP
\fB\-altscreen \fIrows\fP\fBx\fP\fIcols\fP\fB=\fP\fIinit_string\fP\fP
Defines the dimensions and escape sequence for the alternate (132-column)
screen mode.
See \s-1SCREEN SIZE SWITCHING\s+1, below.
.TP
\fB\-cadir\fP \fIdirectory\fP
Specifies a directory containing CA (root) certificates to use when verifying a
certificate provided by the host. (OpenSSL only)
.TP
\fB\-cafile\fP \fIfilename\fP
Specifies a \s-1PEM\s+1-format file containing CA (root) certificates to use
when verifying a certificate provided by the host. (OpenSSL only)
.TP
\fB\-cbreak\fP
Causes \fBc3270\fP to operate in \fIcbreak\fP mode, instead of \fIraw\fP
mode.
In \fIcbreak\fP mode, the TTY driver will properly process XOFF and XON
characters, which are required by some terminals for proper operation.
However, those characters (usually ^S and ^Q), as well as the characters for
\fBinterrupt\fP, \fBquit\fP, and \fBlnext\fP (usually ^C, ^\\
and ^V respectively) will be seen by \fBc3270\fP only if preceded by
the \fBlnext\fP character.
The \fBsusp\fP character (usually ^Z) cannot be seen by \fBc3270\fP at all.
.TP
\fB\-certfile\fP \fIfilename\fP
Specifies a file containing a client certificate to provide to the host.
The default file type is \s-1PEM\s+1.
.TP
\fB\-clientcert\fP \fIname\fP
Specifies the name of a client certificate to provide to the host.
(MacOS only)
.TP
\fB\-certfiletype\fP \fItype\fP
Specifies the type of the certificate file specified
by \fB\-certfile\fP.
\fIType\fP can be \fBpem\fP or \fBasn1\fP. (OpenSSL only)
.TP
\fB\-chainfile \fIfilename\fP\fP
Specifies a certificate chain file in \s-1PEM\s+1 format, containing a
certificate to provide to the host, as well as one or more
intermediate certificates and the CA certificate used to sign that certificate.
If \fB\-chainfile\fP is specified, it
overrides \fB\-certfile\fP. (OpenSSL only)
.TP
\fB\-clear\fP \fItoggle\fP
Sets the initial value of \fItoggle\fP to \fBfalse\fP.
.TP
\fB\-codepage\fP \fIname\fP
Specifies an \s-1EBCDIC\s+1 host code page.
.TP
\fB\-connecttimeout\fP \fIseconds\fP
Specifies the time that c3270 will wait for a host connection to
complete.
.TP
\fB\-defaultfgbg\fP
Causes c3270 to use the terminal's default foreground color
instead of the curses color \fBblack\fP, and the terminal's
default background color instead of the curses color \fBwhite\fP.
This is helpful for emulators such as \fIgnome-terminal\fP whose
representation of a black background is a murky gray, and for emulators
configured to use black text on a white background.
It is set automatically if the environment variable \fBCOLORTERM\fP is
set to \fBgnome-terminal\fP. It is available only if c3270 was
compiled with a version of \fIncurses\fP that supports default colors,
if the emulator supports default colors, and if the termcap/terminfo entry
indicates this capability.
.TP
\fB\-defscreen \fIrows\fP\fBx\fP\fIcols\fP\fB=\fP\fIinit_string\fP\fP
Defines the dimensions and escape sequence for the default (80-column)
screen mode.
See \s-1SCREEN SIZE SWITCHING\s+1, below.
.TP
\fB\-devname\fP \fIname\fP
Specifies a device name (workstation ID) for RFC 4777 support.
.TP
\fB\-hostsfile\fP \fIfile\fP
Uses \fIfile\fP as the hosts file, which allows aliases for host names and
scripts to be executed at login.
See \fIibm_hosts\fP(1) for details.
.TP
\fB\-httpd\fP \fB[\fP\fIaddr\fP\fB:]\fP\fIport\fP
Specifies a port and optional address to listen on for HTTP connections.
\fIAddr\fP can be specified as `*' to indicate 0.0.0.0; the
default is 127.0.0.1. IPv6 numeric addresses must be specified inside of
square brackets, e.g., [::1]:4080 to specify the IPv6 loopback address and
TCP port 4080.
.IP
Note that this option is mutually-exclusive with the \-scriptport
option
.
.TP
\fB\-keyfile\fP \fIfilename\fP
Specifies a file containing the private key for the certificate file
(specified via \fB\-certfile\fP or \fB\-chainfile\fP).
The default file type is \s-1PEM\s+1. (OpenSSL only)
.TP
\fB\-keyfiletype\fP \fItype\fP
Specifies the type of the private key file specified
by \fB\-keyfile\fP.
\fIType\fP can be \fBpem\fP or \fBasn1\fP. (OpenSSL only)
.TP
\fB\-keypasswd\fP \fItype\fP:\fIvalue\fP
Specifies the password for the private key file (OpenSSL) or client
certificate file (MacOS), if it is encrypted.
The argument can be \fBfile\fP:\fIfilename\fP, specifying that the
password is in a file, or \fBstring\fP:\fIstring\fP, specifying the
password on the command-line directly.
If the private key file is encrypted and no \fB\-keypasswd\fP
option is given,
the password will be prompted for interactively.
.TP
\fB\-keymap\fP \fIname\fP
Specifies a keyboard map to be found in the resource
\fBc3270.keymap.\fP\fIname\fP or the file \fIname\fP.
See \s-1KEYMAPS\s+1 below for details.
.TP
\fB\-km\fP \fIname\fP
Specifies the local encoding method for multi-byte text.
\fIname\fP is an encoding name recognized by the ICU library.
(Supported only when c3270 is compiled with DBCS support, and necessary
only when c3270 cannot figure it out from the locale.)
.TP
\fB\-loginmacro\fP \fIAction(arg...) ...\fP
Specifies a macro to run at login time.
.TP
\fB\-model\fP \fIname\fP
The model of 3270 display to be emulated.
The model name is in two parts, either of which may be omitted:
.IP
The first part is the
\fBbase model\fP,
which is either \fB3278\fP or \fB3279\fP.
\fB3278\fP specifies a monochrome (green on black) 3270 display;
\fB3279\fP specifies a color 3270 display.
.IP
The second part is the
\fBmodel number\fP,
which specifies the number of rows and columns.
Model 4 is the default.
.PP
.TS
center;
c c c .
T{
.na
.nh
Model Number
T}	T{
.na
.nh
Columns
T}	T{
.na
.nh
Rows
T}
_
T{
.na
.nh
2
T}	T{
.na
.nh
80
T}	T{
.na
.nh
24
T}
T{
.na
.nh
3
T}	T{
.na
.nh
80
T}	T{
.na
.nh
32
T}
T{
.na
.nh
4
T}	T{
.na
.nh
80
T}	T{
.na
.nh
43
T}
T{
.na
.nh
5
T}	T{
.na
.nh
132
T}	T{
.na
.nh
27
T}
.TE
.IP
Note: Technically, there is no such 3270 display as a 3279-4 or 3279-5, but
most hosts seem to work with them anyway.
.IP
The default model
for a color display is \fB3279\-4\fP.
For a monochrome display, it is \fB3278\-4\fP.
.TP
\fB\-mono\fP
Prevents \fBc3270\fP from using color, ignoring any color capabilities
reported by the terminal.
.TP
\fB\-noprompt\fP
An alias for \-secure.
.TP
\fB\-noverifycert\fP
For TLS connections, do not verify the host certificate.
.TP
\fB\-nvt\fP
Start in NVT mode instead of waiting for the host to send data, and make the
default terminal type \fBxterm\fP.
.TP
\fB\-oversize\fP \fIcols\fP\fBx\fP\fIrows\fP
Makes the screen larger than the default for the chosen model number.
This option has effect only in combination with extended data stream support
(controlled by the "c3270.extended" resource), and only if the host
supports the Query Reply structured field.
The number of columns multiplied by the number of rows must not exceed
16383 (3fff hex), the limit of 14-bit 3270 buffer addressing.
.IP
It can also be specified as \fBauto\fP, which causes \fBc3270\fP to fill
the entire terminal or console window.
.TP
\fB\-port\fP \fIn\fP
Specifies a different \s-1TCP\s+1 port to connect to.
\fIn\fP can be a name from \fB/etc/services\fP like \fBtelnet\fP, or a
number.
This option changes the default port number used for all connections.
(The positional parameter affects only the initial connection.)
.TP
\fB\-proxy \fItype\fP:\fIhost\fP[:\fIport\fP]\fP
Causes \fBc3270\fP to connect via the specified proxy, instead of
using a direct connection.
The \fIhost\fP can be an IP address or hostname.
The optional \fIport\fP can be a number or a service name.
For a list of supported proxy \fItypes\fP, see \s-1PROXY\s+1
below.
.TP
\fB\-printerlu \fIluname\fP\fP
Causes \fBc3270\fP to automatically start a \fIpr3287\fP printer
session.
If \fIluname\fP is ".", then the printer session will be associated with the
interactive terminal session (this requires that the host support TN3270E).
Otherwise, the value is used as the explicit LU name to associate with the
printer session.
.TP
\fB\-reconnect\fP
Causes \fBc3270\fP
to automatically reconnect to the host if it ever disconnects.
This option has effect only if a hostname is specified on the command line.
.TP
\fB\-rv\fP
Switches c3270 from a white-on-black display to a black-on-white
display.
.TP
\fB\-sl\fP \fIn\fP
Specifies that \fIn\fP lines should be saved for scrolling back.
The default is 4096.
.TP
\fB\-scriptport\fP \fB[\fP\fIaddr\fP\fB:]\fP\fIport\fP
Specifies a port and optional address to listen on for scripting connections.
\fIAddr\fP can be specified as `*' to indicate 0.0.0.0; the
default is 127.0.0.1. IPv6 numeric addresses must be specified inside of
square brackets, e.g., [::1]:4081 to specify the IPv6 loopback address and
TCP port 4081.
.IP
Note that this option is mutually-exclusive with the \-httpd
option
.
.TP
\fB\-scriptportonce\fP
Allows c3270 to accept only one script connection. When that connection is
broken, c3270 will exit.
.TP
\fB\-secure\fP
Disables the interactive \fBc3270>\fP prompt.
When used, a hostname must be provided on the command line.
.TP
\fB\-set\fP \fItoggle\fP
Sets the initial value of \fItoggle\fP to \fBtrue\fP.
.TP
\fB\-socket\fP
Causes the emulator to create a Unix-domain socket when it starts, for use
by script processes to send actions to the emulator.
The socket is named \fB/tmp/x3sck.\fP\fIpid\fP.
The \fB\-p\fP option of \fIx3270if\fP causes it to use this socket,
instead of pipes specified by environment variables.
.TP
\fB\-tn\fP \fIname\fP
Specifies the terminal name to be transmitted over the telnet connection.
The default name is
\fBIBM\-\fP\fImodel_name\fP\fB\-E\fP,
for example,
\fBIBM\-3279\-4\-E\fP 
for a color display, or
\fBIBM\-3278\-4\-E\fP
for a monochrome display.
.IP
Some hosts are confused by the \fB\-E\fP
suffix on the terminal name, and will ignore the extra screen area on
models 3, 4 and 5.
Prepending an \fBS:\fP on the hostname, or setting the "c3270.extended"
resource to "false", removes the \fB\-E\fP
from the terminal name when connecting to such hosts.
.IP
The name can also be specified with the "c3270.termName" resource.
.TP
\fB\-trace\fP
Turns on data stream and event tracing at startup.
The default trace file name is
\fB/tmp/x3trc.\fP\fIpid\fP.
.TP
\fB\-tracefile\fP \fIfile\fP
Specifies a file to save data stream and event traces into.
If the name starts with `>>', data will be appended to the file.
.TP
\fB\-tracefilesize\fP \fIsize\fP
Places a limit on the size of a trace file.
If this option is not specified, or is specified as \fB0\fP or \fBnone\fP,
the trace file size will be unlimited.
The minimum size is 64 Kbytes.
The value of \fIsize\fP can have a \fBK\fP or \fBM\fP suffix, indicating
kilobytes or megabytes respectively.
When the trace file reaches the size limit, it will be renamed with a 
`-' appended and a new file started.
.TP
\fB\-user\fP \fIname\fP
Specifies the user name for RFC 4777 support.
.TP
\fB\-utf8\fP
Forces the local codeset to be UTF-8, ignoring the locale or Windows codepage.
.TP
\fB\-v\fP
Display the version and build options for \fBc3270\fP and exit.
.TP
\fB\-verifycert\fP
For TLS connections, verify the host certificate, and do not allow
the connection to complete unless it can be validated. (This is the default
setting.)
This option is overridden by a \fBY:\fP prepended to the hostname when
connecting.
.TP
\fB\-xrm\fP "c3270.\fIresource\fP: \fIvalue\fP"
Sets the value of the named \fIresource\fP to \fIvalue\fP.
Resources control less common \fBc3270\fP
options, and are defined under \s-1RESOURCES\s+1 below.
.SH "STATUS LINE"
If the terminal that \fBc3270\fP is running on
has at least one more row that the 3270 model requires (e.g., 25 rows for a
model 2), \fBc3270\fP will display a status line.
The \fBc3270\fP status line contains a variety of information.
From left to right, the fields are:
.TP
\fBcomm status\fP
The first symbol is always a \fB4\fP.
If \fBc3270\fP is in TN3270E mode, the second symbol is a \fBB\fP;
otherwise it is an \fBA\fP.
If 
\fBc3270\fP is in SSCP-LU mode, the third symbol is an \fBS\fP.
Otherwise it is blank.
.TP
\fBkeyboard lock\fP
If the keyboard is locked, an "X" symbol and a message field indicate the
reason for the keyboard lock.
.TP
\fBtypeahead\fP
The letter "T" indicates that one or more keystrokes are in the typeahead
buffer.
.TP
\fBtemporary keymap\fP
The letter "K" indicates that a temporary keymap is in effect.
.TP
\fBreverse\fP
The letter "R" indicates that the keyboard is in reverse field entry mode.
.TP
\fBinsert mode\fP
The 
letter "I" indicates that the keyboard is in insert mode.
.TP
\fBprinter session\fP
The letter "P" indicates that a \fIpr3287\fP session is active.
.TP
\fBsecure connection\fP
A green letter "S" indicates that the connection is secured via TLS.
.TP
\fBLU name\fP
The LU name associated with the session, if there is one.
.TP
\fBcursor position\fP
The cursor row and column are optionally displayed, zero padded and separated
by a "/".
Location 001/001 is at the upper left, which is different from the row and
columns parameters used with various actions, where the upper left corner is
row 0, column 0.

.SH "ACTIONS"
Here is a complete list of basic c3270 actions.
Script-specific actions are described on the
\fIx3270-script\fP(1) manual page.
.PP
Actions marked with an asterisk (*) may block, sending data to the host and
possibly waiting for a response.
.PP
.TS
center; lw(3i) lw(3i).
T{
.na
.nh
.in +2
.ti -2
*Attn()
T}	T{
.na
.nh
attention key
T}
T{
.na
.nh
.in +2
.ti -2
BackSpace()
T}	T{
.na
.nh
move cursor left (or send \s-1ASCII BS\s+1)
T}
T{
.na
.nh
.in +2
.ti -2
BackTab()
T}	T{
.na
.nh
tab to start of previous input field
T}
T{
.na
.nh
.in +2
.ti -2
Charset(\fIcharset\fP)
T}	T{
.na
.nh
change host code page
T}
T{
.na
.nh
.in +2
.ti -2
CircumNot()
T}	T{
.na
.nh
input "^" in \s-1NVT\s+1 mode, or "notsign" in 3270 mode
T}
T{
.na
.nh
.in +2
.ti -2
*Clear()
T}	T{
.na
.nh
clear screen
T}
T{
.na
.nh
.in +2
.ti -2
Compose()
T}	T{
.na
.nh
next two keys form a special symbol
T}
T{
.na
.nh
.in +2
.ti -2
*Connect(\fIhost\fP)
T}	T{
.na
.nh
connect to \fIhost\fP
T}
T{
.na
.nh
.in +2
.ti -2
*CursorSelect()
T}	T{
.na
.nh
Cursor Select \s-1AID\s+1
T}
T{
.na
.nh
.in +2
.ti -2
Delete()
T}	T{
.na
.nh
delete character under cursor (or send \s-1ASCII DEL\s+1)
T}
T{
.na
.nh
.in +2
.ti -2
DeleteField()
T}	T{
.na
.nh
delete the entire field
T}
T{
.na
.nh
.in +2
.ti -2
DeleteWord()
T}	T{
.na
.nh
delete the current or previous word
T}
T{
.na
.nh
.in +2
.ti -2
*Disconnect()
T}	T{
.na
.nh
disconnect from host
T}
T{
.na
.nh
.in +2
.ti -2
Down()
T}	T{
.na
.nh
move cursor down
T}
T{
.na
.nh
.in +2
.ti -2
Dup()([failonerror|nofailonerror])
T}	T{
.na
.nh
duplicate field
T}
T{
.na
.nh
.in +2
.ti -2
*Enter()
T}	T{
.na
.nh
Enter \s-1AID\s+1 (or send \s-1ASCII CR\s+1)
T}
T{
.na
.nh
.in +2
.ti -2
Erase()
T}	T{
.na
.nh
erase previous character (or send \s-1ASCII BS\s+1)
T}
T{
.na
.nh
.in +2
.ti -2
EraseEOF()
T}	T{
.na
.nh
erase to end of current field
T}
T{
.na
.nh
.in +2
.ti -2
EraseInput()
T}	T{
.na
.nh
erase all input fields
T}
T{
.na
.nh
.in +2
.ti -2
Escape()
T}	T{
.na
.nh
escape to \fBc3270>\fP prompt
T}
T{
.na
.nh
.in +2
.ti -2
FieldEnd()
T}	T{
.na
.nh
move cursor to end of field
T}
T{
.na
.nh
.in +2
.ti -2
FieldMark()([failonerror|nofailonError])
T}	T{
.na
.nh
mark field
T}
T{
.na
.nh
.in +2
.ti -2
HexString(\fIhex_digits\fP)
T}	T{
.na
.nh
insert control-character string
T}
T{
.na
.nh
.in +2
.ti -2
Home()
T}	T{
.na
.nh
move cursor to first input field
T}
T{
.na
.nh
.in +2
.ti -2
Insert()
T}	T{
.na
.nh
set insert mode
T}
T{
.na
.nh
.in +2
.ti -2
*Interrupt()
T}	T{
.na
.nh
send \s-1TELNET IP\s+1 to host
T}
T{
.na
.nh
.in +2
.ti -2
Keypad()
T}	T{
.na
.nh
Display pop-up keypad
T}
T{
.na
.nh
.in +2
.ti -2
Key(\fIkeysym\fP[,failonerror|nofailonerror])
T}	T{
.na
.nh
insert key \fIkeysym\fP
T}
T{
.na
.nh
.in +2
.ti -2
Key(0x\fIxx\fP[,failonError|nofailonerror])
T}	T{
.na
.nh
insert key with character code \fIxx\fP
T}
T{
.na
.nh
.in +2
.ti -2
Left()
T}	T{
.na
.nh
move cursor left
T}
T{
.na
.nh
.in +2
.ti -2
Left2()
T}	T{
.na
.nh
move cursor left 2 positions
T}
T{
.na
.nh
.in +2
.ti -2
Menu()
T}	T{
.na
.nh
Display menu bar
T}
T{
.na
.nh
.in +2
.ti -2
MonoCase()
T}	T{
.na
.nh
toggle uppercase-only mode
T}
T{
.na
.nh
.in +2
.ti -2
MoveCursor(\fIrow\fP,\fIcol\fP)
T}	T{
.na
.nh
move cursor to zero-origin (\fIrow\fP,\fIcol\fP)
T}
T{
.na
.nh
.in +2
.ti -2
Newline()
T}	T{
.na
.nh
move cursor to first field on next line (or send \s-1ASCII LF\s+1)
T}
T{
.na
.nh
.in +2
.ti -2
NextWord()
T}	T{
.na
.nh
move cursor to next word
T}
T{
.na
.nh
.in +2
.ti -2
*PA(\fIn\fP)
T}	T{
.na
.nh
Program Attention \s-1AID\s+1 (\fIn\fP from 1 to 3)
T}
T{
.na
.nh
.in +2
.ti -2
*PF(\fIn\fP)
T}	T{
.na
.nh
Program Function \s-1AID\s+1 (\fIn\fP from 1 to 24)
T}
T{
.na
.nh
.in +2
.ti -2
PreviousWord()
T}	T{
.na
.nh
move cursor to previous word
T}
T{
.na
.nh
.in +2
.ti -2
PasteString(\fIhex_digits\fP)
T}	T{
.na
.nh
insert string using pasting behavior
T}
T{
.na
.nh
.in +2
.ti -2
Printer(start[,\fIlu\fP]|stop)
T}	T{
.na
.nh
start or stop printer session
T}
T{
.na
.nh
.in +2
.ti -2
PrintText(\fIcommand\fP)
T}	T{
.na
.nh
print screen text on printer
T}
T{
.na
.nh
.in +2
.ti -2
Quit()
T}	T{
.na
.nh
exit \fBc3270\fP
T}
T{
.na
.nh
.in +2
.ti -2
Redraw()
T}	T{
.na
.nh
redraw window
T}
T{
.na
.nh
.in +2
.ti -2
Reset()
T}	T{
.na
.nh
reset locked keyboard
T}
T{
.na
.nh
.in +2
.ti -2
Right()
T}	T{
.na
.nh
move cursor right
T}
T{
.na
.nh
.in +2
.ti -2
Right2()
T}	T{
.na
.nh
move cursor right 2 positions
T}
T{
.na
.nh
.in +2
.ti -2
*Script(\fIcommand\fP[,\fIarg\fP...])
T}	T{
.na
.nh
run a script
T}
T{
.na
.nh
.in +2
.ti -2
Scroll(forward|backward)
T}	T{
.na
.nh
scroll screen
T}
T{
.na
.nh
.in +2
.ti -2
*String(\fIstring\fP)
T}	T{
.na
.nh
insert string (simple macro facility)
T}
T{
.na
.nh
.in +2
.ti -2
Tab()
T}	T{
.na
.nh
move cursor to next input field
T}
T{
.na
.nh
.in +2
.ti -2
Toggle(\fIoption\fP[,\fIset|clear\fP])
T}	T{
.na
.nh
toggle an option
T}
T{
.na
.nh
.in +2
.ti -2
ToggleInsert()
T}	T{
.na
.nh
toggle insert mode
T}
T{
.na
.nh
.in +2
.ti -2
ToggleReverse()
T}	T{
.na
.nh
toggle reverse-input mode
T}
T{
.na
.nh
.in +2
.ti -2
*Transfer(\fIoption\fP=\fIvalue\fP...')
T}	T{
.na
.nh
file transfer
T}
T{
.na
.nh
.in +2
.ti -2
Up()
T}	T{
.na
.nh
move cursor up
T}
T{
.na
.nh
.in +2
.ti -2
ignore()
T}	T{
.na
.nh
do nothing
T}
.TE
.LP
Any of the above actions may be entered at the \fBc3270>\fP prompt;
these actions are also available for use in keymaps
(see \s-1KEYMAPS\s+1).
Command names are case-insensitive.
Parameters can be specified with parentheses and commas, e.g.:
.RS
PF(1)
.RE
or with spaces, e.g.:
.RS
PF 1
.RE
Parameters can be quoted with double-quote characters, to allow spaces,
commas, and parentheses to be used.
.LP
\fBc3270\fP also supports the following interactive actions:
.TP
\fBHelp()\fP
Displays a list of available actions.
.TP
\fBScreenTrace()\fP
Turns screen tracing (saving screen images to a file) on or off.
The action \fBScreenTrace(on)\fP enables screen tracing;
the action \fBScreenTrace(off)\fP disables it.
After \fBon\fP, a filename may be specified to override the default
trace file name of
\fB/tmp/x3scr.\fP\fIpid\fP.
The keyword \fBon\fP can also be followed by the keyword \fBprinter\fP and an optional
print command
to direct screen traces directly to the printer.
.TP
\fBShow()\fP
Displays statistics and settings.
.TP
\fBTrace()\fP
Turns tracing on or off.
The action \fBTrace(on)\fP enables data stream and keyboard event tracing;
the action \fBTrace(off)\fP disables it.
The qualifier \fBdata\fP or \fBkeyboard\fP can be specified
before \fBon\fP or \fBoff\fP to enable or disable a particular trace.
After \fBon\fP, a filename may be specified to override the default
trace file name of
\fB/tmp/x3trc.\fP\fIpid\fP.
.LP
Note that certain parameters to c3270 actions (such as the names of files
and keymaps) are subject to \fIsubstitutions\fP:
.LP
The character \fB~\fP at the beginning of a string is replaced with the user's
home directory.
A \fB~\fP character followed by a username is
replaced with that user's home directory.
.LP
Environment variables are substituted using the Unix shell convention of
$\fIname\fP or ${\fIname\fP}.
.LP
Two special pseudo-environment variables are supported. ${TIMESTAMP} is
replaced with a microsecond-resolution timestamp; ${UNIQUE} is replaced with a
string guaranteed to make a unique filename (the process ID optionally
followed by a dash and a string of digits). ${UNIQUE} is used to form trace
file names.
.SH "KEYMAPS"
The \fB\-keymap\fP option
or the \fBc3270.keymap\fP resource
allow a custom keymap to be specified.
If the option \fB\-keymap\fP \fIxxx\fP is given (or the
\fBc3270.keymap\fP resource has the value \fIxxx\fP),
\fBc3270\fP
will look for a resource named \fBc3270.keymap.\fP\fIxxx\fP.
If no resource definition is found, it will look for a file named
\fIxxx\fP.
.LP
Multiple keymaps may be specified be separating their names with commas.
Definitions in later keymaps supercede those in earlier keymaps.
.LP
In addition, separate keymaps may be defined that apply only in 3270 mode or
\s-1NVT\s+1 mode.
For example, the resource definition
\fBc3270.keymap.\fP\fIxxx\fP\fB.nvt\fP
or the file
\fIxxx\fP\fB.nvt\fP
will augment the definition
of keymap \fIxxx\fP in \s-1NVT\s+1 mode.
Similarly, the resource definition
\fBc3270.keymap.\fP\fIxxx\fP\fB.3270\fP
or the file
\fIxxx\fP\fB.3270\fP
will augment the definition
of keymap \fIxxx\fP in 3270 mode.
.LP
Temporary keymaps can also be added or removed while c3270 is running
with the \fBKeymap\fP action.
See \fIx3270-script\fP(1) for details.
.LP
Each line (rule) in a keymap specifies actions to perform when a
particular key or sequence of keys is pressed.
Keymap rules have the following syntax:
.LP
.RS
[\fBMeta\fP][\fBCtrl\fP]\fB<Key>\fP\fIkey\fP...: \fIaction\fP[(\fIparam\fP[,...])] ...
.RE
.LP
Here is a sample keymap definition from a file:
.LP
.RS
! Lines beginning with ! are ignored and can
.br
! occur anywhere.
.br
! Definition of keymap xxx
.br
! \ When Alt-c is pressed, clear the screen.
.br
Alt<Key>c: Clear()
.br
! \ When PageUp is pressed, send PF7 to the host.
.br
<Key>PPAGE: PF(7)
.br
! \ When Ctrl-a is pressed, then F1, send PF13
.br
! \ to the host.
.br
Ctrl<Key>a <Key>F1: PF(13)
.RE
.LP
Here is the same definition as a resource:
.LP
.RS
! Lines beginning with ! are ignored, but NOT
.br
! within a definition.
.br
! Note that the \\ is required at the end of the
.br
! first line, and \\n\\ is
.br
! required at the end of every other line except
.br
! the last.
.br
! Definition of keymap xxx
.br
c3270.keymap.xxx: \\
.br
\ Alt<Key>c: Clear() \\n\\
.br
\ <Key>PPAGE: PF(7) \\n\\
.br
\ Ctrl<Key>A <Key>F1: PF(13)
.RE
.LP
The optional
\fBAlt\fP or \fBCtrl\fP modifiers specify that
the
\fBAlt\fP and \fBCtrl\fP keys are pressed along with the
specified \fIkey\fP, respectively.
\fIKey\fP is either an \s-1ISO\s+1 8859-1 symbol name, such as \fBequal\fP
for `=' and \fBa\fP for `a', or a symbolic
\fBncurses\fP key name,
such as \fBUP\fP.
More than one \fIkey\fP can be specified, indicating that a sequence of
keys must be pressed in order for the rule to be matched.
The \fIaction\fP is an action from the \s-1ACTIONS\s+1 list
above.
More than one \fIaction\fP may be specified; they will be executed in order.
.LP
Keymap entries are case-sensitive and modifier-specific.
This means that a keymap for the \fBb\fP key will match only a
lowercase \fBb\fP.
Actions for uppercase \fBB\fP, or for \fBAlt-B\fP,
must be specified separately.
.LP
The base keymap is:
.LP
.TS
l l.
T{
.na
.nh
Key
T}	T{
.na
.nh
Action
T}
_
T{
.na
.nh
Ctrl<Key>]
T}	T{
.na
.nh
Escape()
T}
T{
.na
.nh
Ctrl<Key>a Ctrl<Key>a
T}	T{
.na
.nh
Key(0x01)
T}
T{
.na
.nh
Ctrl<Key>a Ctrl<Key>]
T}	T{
.na
.nh
Key(0x1d)
T}
T{
.na
.nh
Ctrl<Key>a <Key>Tab
T}	T{
.na
.nh
BackTab()
T}
T{
.na
.nh
Ctrl<Key>a <Key>c
T}	T{
.na
.nh
Clear()
T}
T{
.na
.nh
Ctrl<Key>a <Key>e
T}	T{
.na
.nh
Escape()
T}
T{
.na
.nh
Ctrl<Key>a <Key>r
T}	T{
.na
.nh
Reset()
T}
T{
.na
.nh
Ctrl<Key>a <Key>k
T}	T{
.na
.nh
Keypad()
T}
T{
.na
.nh
Ctrl<Key>a <Key>l
T}	T{
.na
.nh
Redraw()
T}
T{
.na
.nh
Ctrl<Key>a <Key>m
T}	T{
.na
.nh
Compose()
T}
T{
.na
.nh
Ctrl<Key>a <Key>n
T}	T{
.na
.nh
Menu()
T}
T{
.na
.nh
Ctrl<Key>a <Key>p
T}	T{
.na
.nh
PrintText()
T}
T{
.na
.nh
Ctrl<Key>a <Key>^
T}	T{
.na
.nh
Key(notsign)
T}
T{
.na
.nh
Ctrl<Key>k
T}	T{
.na
.nh
Keypad()
T}
T{
.na
.nh
Ctrl<Key>n
T}	T{
.na
.nh
Menu()
T}
T{
.na
.nh
<Key>UP
T}	T{
.na
.nh
Up()
T}
T{
.na
.nh
<Key>DOWN
T}	T{
.na
.nh
Down()
T}
T{
.na
.nh
<Key>LEFT
T}	T{
.na
.nh
Left()
T}
T{
.na
.nh
<Key>RIGHT
T}	T{
.na
.nh
Right()
T}
T{
.na
.nh
<Key>F(\fIn\fP)
T}	T{
.na
.nh
PF(\fIn\fP)
T}
T{
.na
.nh
Ctrl<Key>a <Key>F(\fIn\fP)
T}	T{
.na
.nh
PF(\fIn\fP+12)
T}
T{
.na
.nh
Ctrl<Key>a <Key>1
T}	T{
.na
.nh
PA(1)
T}
T{
.na
.nh
Ctrl<Key>a <Key>2
T}	T{
.na
.nh
PA(2)
T}
T{
.na
.nh
Ctrl<Key>a <Key>3
T}	T{
.na
.nh
PA(3)
T}
T{
.na
.nh
<Key>PPAGE
T}	T{
.na
.nh
Scroll(backward)
T}
T{
.na
.nh
<Key>NPAGE
T}	T{
.na
.nh
Scroll(forward)
T}
.TE
.LP
The base 3270-mode keymap adds:
.LP
.TS
l l.
T{
.na
.nh
Key
T}	T{
.na
.nh
Action
T}
_
T{
.na
.nh
Ctrl<Key>c
T}	T{
.na
.nh
Clear()
T}
T{
.na
.nh
Ctrl<Key>d
T}	T{
.na
.nh
Dup()
T}
T{
.na
.nh
Ctrl<Key>f
T}	T{
.na
.nh
FieldMark()
T}
T{
.na
.nh
Ctrl<Key>i
T}	T{
.na
.nh
Tab()
T}
T{
.na
.nh
Ctrl<Key>l
T}	T{
.na
.nh
Redraw()
T}
T{
.na
.nh
Ctrl<Key>r
T}	T{
.na
.nh
Reset()
T}
T{
.na
.nh
Ctrl<Key>u
T}	T{
.na
.nh
DeleteField()
T}
T{
.na
.nh
<Key>BackSpace
T}	T{
.na
.nh
BackSpace()
T}
T{
.na
.nh
<Key>Return
T}	T{
.na
.nh
Enter()
T}
T{
.na
.nh
<Key>Tab
T}	T{
.na
.nh
Tab()
T}
T{
.na
.nh
<Key>Linefeed
T}	T{
.na
.nh
Newline()
T}
T{
.na
.nh
<Key>BACKSPACE
T}	T{
.na
.nh
BackSpace()
T}
T{
.na
.nh
<Key>DC
T}	T{
.na
.nh
Delete()
T}
T{
.na
.nh
<Key>HOME
T}	T{
.na
.nh
Home()
T}
T{
.na
.nh
<Key>IC
T}	T{
.na
.nh
ToggleInsert()
T}
.TE
.SH "THE META OR ALT KEY"
Some keyboards do not have a \fBMeta\fP key.
Instead, they have an \fBAlt\fP key.
Sometimes this key acts as a proper
\fBMeta\fP key, that is, it is a modifier key that sets the high-order bit
(0x80) in the code that is transmitted for each key.
Other keyboards send a two-character sequence when
the \fBAlt\fP key is pressed with another key: the Escape character (0x1b),
followed by the code for the other key.
.LP
The resource \fBc3270.metaEscape\fP and the termcap \fBkm\fP attribute
control how \fBc3270\fP will interpret these sequences.
When \fBc3270.metaEscape\fP is set to \fBtrue\fP, or when
\fBc3270.metaEscape\fP is set to \fBauto\fP and the termcap \fBkm\fP
attribute is set, the keyboard is assumed to have a separate \fBMeta\fP key.
The Escape key can be used as an ordinary data key and has no special meaning.
.LP
When \fBc3270.metaEscape\fP is set to \fBtrue\fP, or when
\fBc3270.metaEscape\fP is set to \fBauto\fP and the termcap \fBkm\fP
attribute is not set, the keyboard is assumed to use the Escape character
as a prefix to indicate that the following character is supposed to have the
high-order bit set.
When \fBc3270\fP sees an Escape character from the keyboard, it sets a short
timeout.
If another character arrives before the timeout expires, then \fBc3270\fP
will combine the two characters, setting the high-order bit of the second.
In an event trace file, the combined character is listed as \fIderived\fP.
In a keymap, only the combined character or the \fBMeta\fP prefix may be used.
The Escape key can still be used by itself, but only if there is a short pause
before pressing another key.
.LP
The default value for \fBc3270.metaEscape\fP is \fBauto\fP.
.SH "FILE TRANSFER"
The \fBTransfer()\fP action implements \fBIND$FILE\fP file transfer.
This action requires that the \fBIND$FILE\fP
program be installed on the \s-1IBM\s+1 host, and that the 3270 cursor
be located in a field that will accept a \s-1TSO\s+1 or \s-1VM/CMS\s+1 command.
.LP
The \fBTransfer()\fP action
can be entered at the \fBc3270>\fP prompt with no parameters, which will cause it
to prompt interactively for the file names and options.
It can also be invoked with parameters to define the entire transfer.
.LP
Because of the complexity and number of options for file transfer, the
parameters to the \fBTransfer()\fP action can take the unique form
of \fIoption\fP=\fIvalue\fP.
They can also be given with their parameters separately.
Options can appear in any order.
Note that if the \fIvalue\fP contains spaces (such as a VM/CMS file name),
then the entire parameter must be quoted, e.g., \fB"hostfile=xxx foo a"\fP.
With sequential options, this would be \fBhostfile,"xxx foo a"\fP.
The options are:
.LP
.TS
l c l l.
T{
.na
.nh
Option
T}	T{
.na
.nh
Required?
T}	T{
.na
.nh
Default
T}	T{
.na
.nh
Other Values
T}
_
T{
.na
.nh
direction
T}	T{
.na
.nh
No
T}	T{
.na
.nh
receive
T}	T{
.na
.nh
send
T}
T{
.na
.nh
hostfile
T}	T{
.na
.nh
Yes
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
localfile
T}	T{
.na
.nh
Yes
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
host
T}	T{
.na
.nh
No
T}	T{
.na
.nh
tso
T}	T{
.na
.nh
vm, cics
T}
T{
.na
.nh
mode
T}	T{
.na
.nh
No
T}	T{
.na
.nh
ascii
T}	T{
.na
.nh
binary
T}
T{
.na
.nh
cr
T}	T{
.na
.nh
No
T}	T{
.na
.nh
remove
T}	T{
.na
.nh
add, keep
T}
T{
.na
.nh
remap
T}	T{
.na
.nh
No
T}	T{
.na
.nh
yes
T}	T{
.na
.nh
no
T}
T{
.na
.nh
exist
T}	T{
.na
.nh
No
T}	T{
.na
.nh
keep
T}	T{
.na
.nh
replace, append
T}
T{
.na
.nh
recfm
T}	T{
.na
.nh
No
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
fixed, variable, undefined
T}
T{
.na
.nh
lrecl
T}	T{
.na
.nh
No
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
blksize
T}	T{
.na
.nh
No
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
allocation
T}	T{
.na
.nh
No
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
tracks, cylinders, avblock
T}
T{
.na
.nh
primaryspace
T}	T{
.na
.nh
Sometimes
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
secondaryspace
T}	T{
.na
.nh
No
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
avblock
T}	T{
.na
.nh
Sometimes
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}
T{
.na
.nh
buffersize
T}	T{
.na
.nh
No
T}	T{
.na
.nh
4096
T}	T{
.na
.nh
\ 
T}
.TE
.LP
The option details are as follows.
.TP
\fBdirection\fP
\fBsend\fP to send a file to the host,
\fBreceive\fP to receive a file from the host.
.TP
\fBhostfile\fP
The name of the file on the host.
.TP
\fBlocalfile\fP
The name of the file on the local workstation.
.TP
\fBhost\fP
The type of host (which dictates the form of the \fBIND$FILE\fP command):
\fBtso\fP (the default), \fBvm\fP or \fBcics\fP.
.TP
\fBmode\fP
Use \fBascii\fP (the default) for a text file, which will be translated
between \s-1EBCDIC\s+1 and \s-1ASCII\s+1 as necessary.
Use \fBbinary\fP for non-text files.
.TP
\fBcr\fP
Controls how newline characters are handled when transferring
\fBmode=ascii\fP files.
\fBremove\fP (the default) strips newline characters in local files
before transferring them to the host.
\fBadd\fP adds newline characters to each host file record before
transferring it to the local workstation.
\fBkeep\fP preserves newline characters when transferring a local file
to the host.
.TP
\fBremap\fP
Controls text translation for \fBmode=ascii\fP files.
The value \fByes\fP (the default) causes c3270 to remap the text to ensure
maximum compatibility between the workstation's character set and encoding
and the host's \s-1EBCDIC\s+1 code page.
The value \fBno\fP causes c3270 to pass the text to or from the host
as-is, leaving all translation to the \fBIND$FILE\fP program on the host.
.TP
\fBexist\fP
Controls what happens when the destination file already exists.
\fBkeep\fP (the default) preserves the file, causing the
\fBTransfer()\fP action to fail.
\fBreplace\fP overwrites the destination file with the source file.
\fBappend\fP appends the source file to the destination file.
.TP
\fBrecfm\fP
Controls the record format of files created on the host.
(\s-1TSO\s+1 and \s-1VM\s+1 hosts only.)
\fBfixed\fP creates a file with fixed-length records.
\fBvariable\fP creates a file with variable-length records.
\fBundefined\fP creates a file with undefined-length records (\s-1TSO\s+1 hosts
only).
The \fBlrecl\fP option controls the record length or maximum record length for
\fBrecfm=fixed\fP and \fBrecfm=variable\fP files, respectively.
.TP
\fBlrecl\fP
Specifies the record length (or maximum record length) for files created on
the host.
(\s-1TSO\s+1 and \s-1VM\s+1 hosts only.)
.TP
\fBblksize\fP
Specifies the block size for files created on the host.
(\s-1TSO\s+1 and \s-1VM\s+1 hosts only.)
.TP
\fBallocation\fP
Specifies the units for the \fBprimaryspace\fP and
\fBsecondaryspace\fP options: \fBtracks\fP, \fBcylinders\fP or
\fBavblock\fP. (\s-1TSO\s+1 hosts only.)
.TP
\fBprimaryspace\fP
Primary allocation for a file.
The units are given by the \fBallocation\fP option.
Required when the \fBallocation\fP is specified as something other than
\fBdefault\fP.
(\s-1TSO\s+1 hosts only.)
.TP
\fBsecondaryspace\fP
Secondary allocation for a file.
The units are given by the \fBallocation\fP option. (\s-1TSO\s+1 hosts only.) 
.TP
\fBavblock\fP
Average block size, required when \fBallocation\fP specifies \fBavblock\fP.
(\s-1TSO\s+1 hosts only.)
.TP
\fBbuffersize\fP
Buffer size for DFT-mode transfers.
Can range from 256 to 32768.
Larger values give better performance, but some hosts may not be able to
support them.
.LP
There are also resources that control the default values for each of the
file transfer parameters.
These resources have the same names as the \fBTransfer()\fP keywords, but with
\fBft\fP prepended and the option name capitalized. E.g., the default for the \fBmode\fP keyword is the
\fBc3270.ftMode\fP resource.

.SH "THE PRINTTEXT ACTION"
The \fBPrintText()\fP produces screen snapshots in a number of different
forms.
The default form wth no arguments sends a copy of the screen to the default
printer.
A single argument is
the command to use to print, e.g., \fBlpr\fP.
.LP
Multiple arguments can include keywords to control the output of
\fBPrintText()\fP:
.TP
\fBfile\fP,\fIfilename\fP
Save the output in a file.
.TP
\fBhtml\fP
Save the output as HTML.  This option implies \fBfile\fP.
.TP
\fBrtf\fP
Save the output as RichText.  This option implies \fBfile\fP.
The font defaults to \fBCourier New\fP and the
point size defaults to 8.
These can be overridden by the \fBprintTextFont\fP and \fBprintTextSize\fP
resources, respectively.
.TP
\fBstring\fP
Return the output as a string.  This can only be used from scripts.
.TP
\fBmodi\fP
Render modified fields in italics.
.TP
\fBcaption\fP,\fItext\fP
Add the specified \fItext\fP as a caption above the output.
Within \fItext\fP, the special sequence \fB%T%\fP will be replaced with
a timestamp.
.TP
\fBcommand\fP,\fIcommand\fP
Directs the output to a command.
This allows one or more of the other keywords to be specified, while still
sending the output to the printer.

.SH "SCRIPTS"
There are several types of
script functions available.
.TP
\fBThe String Action\fP
The simplest method for
scripting is provided via the \fBString()\fP
action, which
can be bound to any key in a keymap.
The arguments to \fBString()\fP are one or more double-quoted strings which are
inserted directly as if typed.
The C backslash conventions are honored as follows.
(Entries marked * mean that after sending the \s-1AID\s+1 code to the host,
\fBc3270\fP will wait for the host to unlock the keyboard before further
processing the string.)
.TS
l l.
T{
.na
.nh
\eb
T}	T{
.na
.nh
Left()
T}
T{
.na
.nh
\ee\fIxxxx\fP
T}	T{
.na
.nh
EBCDIC character in hex
T}
T{
.na
.nh
\ef
T}	T{
.na
.nh
Clear()*
T}
T{
.na
.nh
\en
T}	T{
.na
.nh
Enter()*
T}
T{
.na
.nh
\epa\fIn\fP
T}	T{
.na
.nh
PA(\fIn\fP)*
T}
T{
.na
.nh
\epf\fInn\fP
T}	T{
.na
.nh
PF(\fInn\fP)*
T}
T{
.na
.nh
\er
T}	T{
.na
.nh
Newline()
T}
T{
.na
.nh
\et
T}	T{
.na
.nh
Tab()
T}
T{
.na
.nh
\eT
T}	T{
.na
.nh
BackTab()
T}
T{
.na
.nh
\eu\fIxxxx\fP
T}	T{
.na
.nh
Unicode character in hex
T}
T{
.na
.nh
\ex\fIxxxx\fP
T}	T{
.na
.nh
Unicode character in hex
T}
.TE
.IP
Note that the numeric values for the \ee, \eu and \ex sequences
can be abbreviated to 2 digits.
Note also that EBCDIC codes greater than 255 and some Unicode character codes
represent DBCS characters, which will work only if c3270 is built with
DBCS support and the host allows DBCS input in the current field.
.IP
An example keymap entry would be:
.RS
Meta<Key>p: String("probs clearrdr\en")
.RE
.IP
\fBNote:\fP
The strings are in \s-1ASCII\s+1 and converted to \s-1EBCDIC\s+1,
so beware of inserting
control codes.
.IP
There is also an alternate form of the \fBString()\fP action, \fBHexString()\fP,
which is used to enter non-printing data.
The argument to \fBHexString()\fP is a string of hexadecimal digits, two per
character.  A leading 0x or 0X is optional.
In 3270 mode, the hexadecimal data represent \s-1EBCDIC\s+1 characters, which
are entered into the current field.
In \s-1NVT\s+1 mode, the hexadecimal data represent \s-1ASCII\s+1 characters,
which are sent directly to the host.
.TP
\fBThe Script Action\fP
This action causes \fBc3270\fP to start a child process which can
execute \fBc3270\fP actions.
Standard input and output from the child process are piped back to
\fBc3270\fP.
The \fBScript()\fP action is fully documented in
\fIx3270-script\fP(1).
.SH "COMPOSITE CHARACTERS"
\fBc3270\fP
allows the direct entry of accented letters and special symbols.
Pressing and releasing the "Compose" key, followed by two other keys, causes
entry of the symbol combining those two keys.
For example, "Compose" followed by the "C" key and the "," (comma) key, enters
the "C-cedilla" symbol.
A C on the status line indicates a pending composite character.
.PP
The mappings between these pairs of ordinary keys and the symbols they
represent is controlled by the "c3270.composeMap" resource; it gives the
name of the map to use.
The maps themselves are named "c3270.composeMap.\fIname\fP".
The default is "latin1", which gives mappings for most of the symbols in
the \s-1ISO\s+1 8859-1 Latin-1 character set that are not in the
7-bit \s-1ASCII\s+1
character set.
.PP
\fBNote:\fP
The default keymap defines
Meta<Key>m
as the "Compose" key.
You
may set up your own "Compose" key with
a keymap that maps some other keysym onto the \fBCompose()\fP action.
.SH "PRINTER SESSION SUPPORT"
c3270 supports associated printer sessions via the \fIpr3287\fP(1)
program.
The \fBPrinter()\fP action is used to start or stop a \fIpr3287\fP session.
.LP
The action \fBPrinter(Start)\fP starts a printer session, associated with the
current LU.  (This works only if the host supports TN3270E.)
.LP
The action \fBPrinter\fP(Start,\fIlu\fP) starts a printer session, associated
with a specific \fIlu\fP.
.LP
The action \fBPrinter Stop\fP stops a printer session.
.LP
The resource \fBc3270.printer.options\fP specifies extra options, such as
\fB-trace\fP to pass to \fIpr3287\fP.
.LP
See \fIpr3287\fP(1) for further details.
.LP
The resource \fBc3270.printerLu\fP controls automatic printer session
start-up.  If it is set to `\fB.\fP', then whenever a login session is started,
a printer session will automatically be started, associated with the login
session.  If it is set an LU name, then the automatic printer session will be
associated with the specified LU.

.SH "PASSTHRU"
\fBc3270\fP supports the Sun \fItelnet-passthru\fP
service provided by the \fIin.telnet-gw\fP server.
This allows outbound telnet connections through a firewall machine.
When a \fBP:\fP is prepended to a hostname, \fBc3270\fP
acts much like the \fIitelnet\fP(1) command.
It contacts the machine named \fBinternet-gateway\fP at the port defined in
\fB/etc/services\fP as \fBtelnet-passthru\fP
(which defaults to 3514).
It then passes the requested hostname and port to the
\fBin.telnet-gw\fP server.
.SH "PROXY"
The \fB\-proxy\fP option or the \fBc3270.proxy\fP resource
causes c3270 to use a proxy server to connect to the host.
The syntax of the option or resource is:
.RS
\fItype\fP:[\fIusername\fP:\fIpassword\fP@]\fIhost\fP[:\fIport\fP]

.RE
The supported values for \fItype\fP are:
.TS
center;
c l c .
T{
.na
.nh
Proxy Type
T}	T{
.na
.nh
Protocol
T}	T{
.na
.nh
Default Port
T}
_
T{
.na
.nh
http
T}	T{
.na
.nh
RFC 2817 HTTP tunnel (squid)
T}	T{
.na
.nh
3128
T}
T{
.na
.nh
passthru
T}	T{
.na
.nh
Sun in.telnet-gw
T}	T{
.na
.nh
none
T}
T{
.na
.nh
socks4
T}	T{
.na
.nh
SOCKS version 4
T}	T{
.na
.nh
1080
T}
T{
.na
.nh
socks5
T}	T{
.na
.nh
SOCKS version 5 (RFC 1928)
T}	T{
.na
.nh
1080
T}
T{
.na
.nh
telnet
T}	T{
.na
.nh
No protocol (just send \fBconnect\fP \fIhost port\fP)
T}	T{
.na
.nh
none
T}
.TE
.LP
The special types \fBsocks4a\fP and \fBsocks5d\fP can also be used to force
the proxy server to do the hostname resolution for the SOCKS protocol.
Note that only the \fBhttp\fP and \fBsocks5\fP proxies support a username and
password.
.SH "SCREEN SIZE SWITCHING"
When running as a 3270 Model 5, \fBc3270\fP can take advantage of terminals
that can switch between 80 and 132 column modes.
.LP
Because the curses library does not support mode switching, the escape
sequences and resulting screen dimensions must be specified explicitly to
\fBc3270\fP.
These are specified with the \fB\-altscreen\fP and
\fB\-defscreen\fP command-line options, or the
\fBaltScreen\fP and \fBdefScreen\fP resources.
\fB\-altscreen\fP or \fBaltScreen\fP defines the alternate
(132-column) mode; \fB\-defscreen\fP or \fBdefScreen\fP defines the
default (80-column) mode.
.LP
The syntax for the options and resources is
\fIrows\fP\fBx\fP\fIcols\fP\fB=\fP\fIinit_string\fP,
where \fIrows\fP and \fIcols\fP give the screen dimensions, and
\fIinit_string\fP is the escape sequence to transmit to the terminal to
enter that mode.
For \fBdefscreen\fP, the minimum dimensions are 24 rows and 80 columns.
For \fBaltscreen\fP, the minimum dimensions are 27 rows and 132 columns.
Within \fIinit_string\fP, the usual escape sequences are supported
(\\E for escape, \\r, \\b, etc.).
For example, the init string for a 132-column xterm is:
.IP
\\E[?40h\\E[?3h
.LP
Note: When \fBdefscreen\fP and \fBaltscreen\fP are specified, the model
number is always set to 5.
.SH "RESOURCES"
Certain \fBc3270\fP
options can be configured via resources.
Resources are defined
in the file \fB.c3270pro\fP in the user's
home directory, and
by \fB\-xrm\fP options.
The definitions are similar to X11 resources, and use a similar syntax.
The resources available in \fBc3270\fP are:
.LP
.TS
l l l l.
T{
.na
.nh
Resource
T}	T{
.na
.nh
Default
T}	T{
.na
.nh
Option
T}	T{
.na
.nh
Purpose
T}
_
T{
.na
.nh
allBold
T}	T{
.na
.nh
Auto
T}	T{
.na
.nh
\-allbold
T}	T{
.na
.nh
Display all characters bold
T}
T{
.na
.nh
altScreen
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\-altscreen
T}	T{
.na
.nh
132-col screen definition
T}
T{
.na
.nh
blankFill
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\-set blankFill
T}	T{
.na
.nh
Blank Fill mode
T}
T{
.na
.nh
charset
T}	T{
.na
.nh
bracket
T}	T{
.na
.nh
\-charset
T}	T{
.na
.nh
\s-1EBCDIC\s+1 character set
T}
T{
.na
.nh
composeMap
T}	T{
.na
.nh
latin1
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Name of composed-character map
T}
T{
.na
.nh
cursesColor\%ForHostColor\fIn\fP
T}	T{
.na
.nh
(note 6)
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Color mapping
T}
T{
.na
.nh
cursesColor\%ForDefault
T}	T{
.na
.nh
green
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Default color mapping
T}
T{
.na
.nh
cursesColor\%ForIntensified
T}	T{
.na
.nh
red
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Default color mapping
T}
T{
.na
.nh
cursesColor\%ForProtected
T}	T{
.na
.nh
blue
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Default color mapping
T}
T{
.na
.nh
cursesColor\%ForProtectedIntensified
T}	T{
.na
.nh
white
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Default color mapping
T}
T{
.na
.nh
cursesKeymap
T}	T{
.na
.nh
True
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Set curses keymap option
T}
T{
.na
.nh
defScreen
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\-defscreen
T}	T{
.na
.nh
80-col screen definition
T}
T{
.na
.nh
dbcsCgcsgid
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Override DBCS CGCSGID
T}
T{
.na
.nh
dsTrace
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\-trace
T}	T{
.na
.nh
Data stream tracing
T}
T{
.na
.nh
eof
T}	T{
.na
.nh
^D
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\s-1NVT\s+1-mode \s-1EOF\s+1 character
T}
T{
.na
.nh
erase
T}	T{
.na
.nh
^H
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\s-1NVT\s+1-mode erase character
T}
T{
.na
.nh
extended
T}	T{
.na
.nh
True
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Use 3270 extended data stream
T}
T{
.na
.nh
eventTrace
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\-trace
T}	T{
.na
.nh
Event tracing
T}
T{
.na
.nh
hostsFile
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\-hostsfile
T}	T{
.na
.nh
Host alias/macro file
T}
T{
.na
.nh
icrnl
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Map \s-1CR\s+1 to \s-1NL\s+1 on \s-1NVT\s+1-mode input
T}
T{
.na
.nh
inlcr
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Map \s-1NL\s+1 to \s-1CR\s+1 in \s-1NVT\s+1-mode input
T}
T{
.na
.nh
intr
T}	T{
.na
.nh
^C
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\s-1NVT\s+1-mode interrupt character
T}
T{
.na
.nh
keymap
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\-keymap
T}	T{
.na
.nh
Keyboard map name
T}
T{
.na
.nh
keymap.\fIfoo\fP
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Definition of keymap \fIfoo\fP
T}
T{
.na
.nh
kill
T}	T{
.na
.nh
^U
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\s-1NVT\s+1-mode kill character
T}
T{
.na
.nh
lineWrap
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\-set lineWrap
T}	T{
.na
.nh
\s-1NVT\s+1 line wrap mode
T}
T{
.na
.nh
lnext
T}	T{
.na
.nh
^V
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\s-1NVT\s+1-mode lnext character
T}
T{
.na
.nh
m3279
T}	T{
.na
.nh
(note 1)
T}	T{
.na
.nh
\-model
T}	T{
.na
.nh
3279 (color) emulation
T}
T{
.na
.nh
metaEscape
T}	T{
.na
.nh
Auto
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Interpret ESC-x as Meta-x
T}
T{
.na
.nh
mono
T}	T{
.na
.nh
(note 5)
T}	T{
.na
.nh
\-mono
T}	T{
.na
.nh
Ignore terminal color capabilities
T}
T{
.na
.nh
monoCase
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\-set monoCase
T}	T{
.na
.nh
Mono-case mode
T}
T{
.na
.nh
noPrompt
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\-noprompt
T}	T{
.na
.nh
Disable \fBc3270>\fP-prompt mode
T}
T{
.na
.nh
numericLock
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Lock keyboard for numeric field error
T}
T{
.na
.nh
oerrLock
T}	T{
.na
.nh
True
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Lock keyboard for input error
T}
T{
.na
.nh
oversize
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\-oversize
T}	T{
.na
.nh
Oversize screen dimensions
T}
T{
.na
.nh
port
T}	T{
.na
.nh
telnet
T}	T{
.na
.nh
\-port
T}	T{
.na
.nh
Non-default TCP port
T}
T{
.na
.nh
printer.*
T}	T{
.na
.nh
(note 4)
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Printer session config
T}
T{
.na
.nh
printerLu
T}	T{
.na
.nh
(note 4)
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Printer session config
T}
T{
.na
.nh
quit
T}	T{
.na
.nh
^\e
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\s-1NVT\s+1-mode quit character
T}
T{
.na
.nh
reconnect
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\-reconnect
T}	T{
.na
.nh
Automatically reconnect to host
T}
T{
.na
.nh
rprnt
T}	T{
.na
.nh
^R
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\s-1NVT\s+1-mode reprint character
T}
T{
.na
.nh
sbcsCgcsgid
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Override SBCS CGCSGID
T}
T{
.na
.nh
secure
T}	T{
.na
.nh
False
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Disable "dangerous" options
T}
T{
.na
.nh
termName
T}	T{
.na
.nh
(note 2)
T}	T{
.na
.nh
\-tn
T}	T{
.na
.nh
\s-1TELNET\s+1 terminal type string
T}
T{
.na
.nh
traceDir
T}	T{
.na
.nh
/tmp
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Directory for trace files
T}
T{
.na
.nh
traceFile
T}	T{
.na
.nh
(note 3)
T}	T{
.na
.nh
\-tracefile
T}	T{
.na
.nh
File for trace output
T}
T{
.na
.nh
typeahead
T}	T{
.na
.nh
True
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
Allow typeahead
T}
T{
.na
.nh
werase
T}	T{
.na
.nh
^W
T}	T{
.na
.nh
\ 
T}	T{
.na
.nh
\s-1NVT\s+1-mode word-erase character
T}
.TE
.LP
.RS
\fINote 1\fP: \fBm3279\fP defaults to
\fBTrue\fP if the terminal supports color,
\fBFalse\fP otherwise.
It can be forced to \fBFalse\fP with the proper \fB\-model\fP
option.
.LP
\fINote 2\fP:
The default terminal type string is constructed from the model number, color
emulation, and extended data stream modes.
E.g., a model 2 with color emulation and the extended data stream option
would be sent as \fBIBM-3279-2-E\fP.
Note also that when \s-1TN3270E\s+1
mode is used, the terminal type is always sent as 3278, but this does not
affect color capabilities.
.LP
\fINote 3\fP: The default trace file is
\fBx3trc.\fP\fIpid\fP in the directory specified by
the \fBtraceDir\fP resource.
.LP
\fINote 4\fP: See \s-1PRINTER SUPPORT\s+1 for details.

.LP
\fINote 5\fP: \fBmono\fP defaults to \fBfalse\fP if the
terminal supports at least 8 colors and to \fBtrue\fP otherwise.
.LP
\fINote 6\fP: The default curses color mappings for host colors
0 through 15 are: black, blue, red, magenta, green, cyan, yellow, white, black,
blue, yellow, blue, green, cyan, black and white.

.RE
.LP
In \fB.c3270pro\fP, lines are continued with a
backslash character.
.LP
\fB\-xrm\fP options override definitions found in \fB.c3270pro\fP.
If more than one \fB\-xrm\fP option is given for the same resource,
the last one on the command line is used.
.SH "FILES"
/usr/local/lib/x3270/ibm_hosts
.br
$HOME/.c3270pro

.SH "SEE ALSO"
pr3287(1), s3270(1), x3270-script(1), 
x3270(1), telnet(1), tn3270(1)
.br
Data Stream Programmer's Reference, IBM GA23-0059
.br
Character Set Reference, IBM GA27-3831
.br
RFC 1576, TN3270 Current Practices
.br
RFC 1646, TN3270 Extensions for LUname and Printer Selection
.br
RFC 2355, TN3270 Enhancements
.SH "COPYRIGHTS"
Copyright 1993-2020, Paul Mattes.
.br
Copyright 2004-2005, Don Russell.
.br
Copyright 2004, Dick Altenbern.
.br
Copyright 1990, Jeff Sparkes.
.br
Copyright 1989, Georgia Tech Research Corporation (GTRC), Atlanta, GA
 30332.
.br
All rights reserved.
.LP
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

.TP
*
Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
.TP
*
Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.
.TP
*
Neither the names of Paul Mattes, Don Russell, Dick Altenbern, Jeff Sparkes,
GTRC nor
the names of their contributors may be used to endorse or promote
products derived from this software without specific prior written
permission.

.LP
THIS SOFTWARE IS PROVIDED BY PAUL MATTES, DON RUSSELL, DICK ALTENBERN, JEFF
SPARKES AND GTRC
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL PAUL MATTES, DON RUSSELL, DICK
ALTENBERN, JEFF
SPARKES OR GTRC BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.SH "VERSION"
c3270 4.0ga11
