'\" t
.TH s3270 1 "24 December 2007"
.SH "NAME"
s3270 \-
\s-1IBM\s+1 host access tool
.SH "SYNOPSIS"
\fBs3270\fP
[\fIoptions\fP]
[\fIhost\fP]


.SH "DESCRIPTION"
\fBs3270\fP opens
a telnet connection to an \s-1IBM\s+1
host, then allows a script to control the host login session.
It is derived from
\fIx3270\fP(1),
an X-windows IBM 3270 emulator.
It implements RFCs 2355 (TN3270E), 1576 (TN3270) and 1646 (LU name selection),
and supports IND$FILE file transfer.
.LP
The full syntax for \fIhost\fP is:
.RS
[\fIprefix\fP:]...[\fILUname\fP@]\fIhostname\fP[:\fIport\fP]
.RE
.LP
Prepending a \fBP:\fP onto \fIhostname\fP causes the connection to go
through the \fItelnet-passthru\fP service rather than directly to the host.
See \s-1PASSTHRU\s+1 below.
.LP
Prepending an \fBS:\fP onto \fIhostname\fP removes the "extended data
stream" option reported to the host.
See \fB\-tn\fP below for further information.
.LP
Prepending an \fBN:\fP onto \fIhostname\fP
turns off TN3270E support for the session.
.LP
Prepending an \fBL:\fP onto \fIhostname\fP
causes \fBs3270\fP to first create an SSL tunnel to the host, and then
create a TN3270 session inside the tunnel.  (This function is supported only if
\fBs3270\fP was built with SSL/TLS support).
Note that TLS-encrypted sessions using the TELNET START-TLS option are
negotiated with the host automatically; for these sessions the \fBL:\fP prefix
should not be used.
.LP
A specific Logical Unit (LU) name to use may be specified by prepending it to
the \fIhostname\fP with an `\fB@\fP'.
Multiple LU names to try can be separated by commas.
An empty LU can be placed in the list with an extra comma.
(Note that the LU name is used for different purposes by different kinds of
hosts.
For example, CICS uses the LU name as the Terminal ID.)
.LP
The \fIhostname\fP may optionally be placed inside square-bracket
characters `\fB[\fP' and `\fB]\fP'.
This will prevent any colon `\fB:\fP' characters in the hostname
from being interpreted as indicating option prefixes or port numbers.
This allows numeric IPv6 addresses to be used as hostnames.
.LP
On systems that support the \fIforkpty\fP library call, the
\fIhostname\fP may be replaced with \fB\-e\fP and a command string.
This will cause \fBs3270\fP to connect to a local child process, such as
a shell.
.LP
The port to connect to defaults to
\fBtelnet\fP.
This can be overridden with the \fB\-port\fP option, or by appending
a \fIport\fP to the \fIhostname\fP with a colon
`\fB:\fP'.
(For compatability with previous versions of \fBs3270\fP
and with \fItn3270\fP(1), the \fIport\fP
may also be specified as a second, separate argument.)

.SH "OPTIONS"
 \fBs3270\fP understands
the following options:
.TP
\fB\-charset\fP \fIname\fP
Specifies an \s-1EBCDIC\s+1 host character set.
See \s-1CHARACTER SETS\s+1 below.
.TP
\fB\-clear\fP \fItoggle\fP
Sets the initial value of \fItoggle\fP to \fBfalse\fP.
The list of toggle names is under \s-1TOGGLES\s+1
below.
.TP
\fB\-im\fP \fImethod\fP
Specifies the name of the input method to use for multi-byte input.
(Supported only when s3270 is compiled with DBCS support.)
.TP
\fB\-km\fP \fIname\fP
Specifies the local encoding method for multi-byte text.
\fIname\fP is an encoding name recognized by the ICU library.
(Supported only when s3270 is compiled with DBCS support, and necessary
only when s3270 cannot figure it out from the locale.)
.TP
\fB\-model\fP \fIname\fP
The model of 3270 display to be emulated.
The model name is in two parts, either of which may be omitted:
.IP
The first part is the
\fBbase model\fP,
which is either \fB3278\fP or \fB3279\fP.
\fB3278\fP specifies a monochrome (green on black) 3270 display;
\fB3279\fP specifies a color 3270 display.
.IP
The second part is the
\fBmodel number\fP,
which specifies the number of rows and columns.
Model 4 is the default.
.PP
.TS
center;
c c c .
T{
.na
.nh
Model Number
T}	T{
.na
.nh
Columns
T}	T{
.na
.nh
Rows
T}
_
T{
.na
.nh
2
T}	T{
.na
.nh
80
T}	T{
.na
.nh
24
T}
T{
.na
.nh
3
T}	T{
.na
.nh
80
T}	T{
.na
.nh
30
T}
T{
.na
.nh
4
T}	T{
.na
.nh
80
T}	T{
.na
.nh
43
T}
T{
.na
.nh
5
T}	T{
.na
.nh
132
T}	T{
.na
.nh
27
T}
.TE
.IP
Note: Technically, there is no such 3270 display as a 3279-4 or 3279-5, but
most hosts seem to work with them anyway.
.IP
The default model
is \fB3278\-4\fP.
.TP
\fB\-oversize\fP \fIcols\fP\fBx\fP\fIrows\fP
Makes the screen larger than the default for the chosen model number.
This option has effect only in combination with extended data stream support
(controlled by the "s3270.extended" resource), and only if the host
supports the Query Reply structured field.
The number of columns multiplied by the number of rows must not exceed
16383 (3fff hex), the limit of 14-bit 3270 buffer addressing.
.TP
\fB\-port\fP \fIn\fP
Specifies a different \s-1TCP\s+1 port to connect to.
\fIn\fP can be a name from \fB/etc/services\fP like \fBtelnet\fP, or a
number.
This option changes the default port number used for all connections.
(The positional parameter affects only the initial connection.)
.TP
\fB\-proxy \fItype\fP:\fIhost\fP[:\fIport\fP]\fP
Causes \fBs3270\fP to connect via the specified proxy, instead of
using a direct connection.
The \fIhost\fP can be an IP address or hostname.
The optional \fIport\fP can be a number or a service name.
For a list of supported proxy \fItypes\fP, see \s-1PROXY\s+1
below.
.TP
\fB\-set\fP \fItoggle\fP
Sets the initial value of \fItoggle\fP to \fBtrue\fP.
The list of toggle names is under \s-1TOGGLES\s+1
below.
.TP
\fB\-socket\fP
Causes the emulator to create a Unix-domain socket when it starts, for use
by script processes to send commands to the emulator.
The socket is named \fB/tmp/x3sck.\fP\fIprocess_id\fP.
The \fB\-p\fP option of \fIx3270if\fP causes it to use this socket,
instead of pipes specified by environment variables.
.TP
\fB\-tn\fP \fIname\fP
Specifies the terminal name to be transmitted over the telnet connection.
The default name is
\fBIBM\-\fP\fImodel_name\fP\fB\-E\fP,
for example,
\fBIBM\-3278\-4\-E\fP.
.IP
Some hosts are confused by the \fB\-E\fP
suffix on the terminal name, and will ignore the extra screen area on
models 3, 4 and 5.
Prepending an \fBs:\fP on the hostname, or setting the "s3270.extended"
resource to "false", removes the \fB\-E\fP
from the terminal name when connecting to such hosts.
.IP
The name can also be specified with the "s3270.termName" resource.
.TP
\fB\-trace\fP
Turns on data stream and event tracing at startup.
The default trace file name is
\fB/tmp/x3trc.\fP\fIprocess_id\fP.
.TP
\fB\-tracefile\fP \fIfile\fP
Specifies a file to save data stream and event traces into.
.TP
\fB\-tracefilesize\fP \fIsize\fP
Places a limit on the size of a trace file.
If this option is not specified, or is specified as \fB0\fP or \fBnone\fP,
the trace file will be unlimited.
If specified, the trace file cannot already exist, and the (silently enforced)
minimum size is 64 Kbytes.
The value of \fIsize\fP can have a \fBK\fP or \fBM\fP suffix, indicating
kilobytes or megabytes respectively.
.TP
\fB\-xrm\fP "s3270.\fIresource\fP: \fIvalue\fP"
Sets the value of the named \fIresource\fP to \fIvalue\fP.
Resources control less common \fBs3270\fP
options, and are defined under \s-1RESOURCES\s+1 below.
.SH "FILES"
/usr/local/lib/x3270/ibm_hosts
.br

.SH "SEE ALSO"

x3270(1), c3270(1), tcl3270(1), ibm_hosts(5), x3270-script(1), telnet(1), tn3270(1)
.br
Data Stream Programmer's Reference, IBM GA23-0059
.br
Character Set Reference, IBM GA27-3831
.br
RFC 1576, TN3270 Current Practices
.br
RFC 1646, TN3270 Extensions for LUname and Printer Selection
.br
RFC 2355, TN3270 Enhancements
.SH "COPYRIGHTS"
.LP
Modifications and original code Copyright 1993, 1994, 1995, 1996, 1997, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007 by Paul Mattes.
.br
DFT File Transfer Code Copyright  October 1995 by Dick Altenbern.
.br
RPQNAMES Code Copyright  2004, 2005 by Don Russell.
.br
Original X11 Port Copyright 1990 by Jeff Sparkes.
.RS
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.
.RE
Copyright 1989 by Georgia Tech Research Corporation, Atlanta, GA 30332.
.RS
All Rights Reserved.  GTRC hereby grants public use of this software.
Derivative works based on this software must incorporate this copyright
notice.
.RE
.br
s3270 is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the file LICENSE for more details.
.SH "VERSION"
s3270 3.3.7
