# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Initial Developer of the Original Code is Everything Solved.
# Portions created by Everything Solved are Copyright (C) 2007
# Everything Solved. All Rights Reserved.
#
# The Original Code is the Bugzilla Bug Tracking System.
#
# Contributor(s): Max Kanat-Alexander <mkanat@bugzilla.org>
#
# Translated by Marc Schumann <wurblzap@gmail.com>

# This file contains a single hash named %strings, which is used by the
# installation code to display strings before Template-Toolkit can safely
# be loaded.
#
# Each string supports a very simple substitution system, where you can
# have variables named like ##this## and they'll be replaced by the string
# variable with that name.
#
# Please keep the strings in alphabetical order by their name.

%strings = (
    any  => 'beliebig',
    blacklisted => '(auf der schwarzen Liste)',
    checking_for => 'Ueberpruefe auf',
    checking_dbd      => 'Ueberpruefe verfuegbare Perl-DBD-Module...',
    checking_optional => 'Die folgenden Perl-Module sind optional:',
    checking_modules  => 'Ueberpruefe Perl-Module...',
    chmod_failed      => '##path##: Fehler beim Aendern der Zugriffsberechtigung: ##error##',
    chown_failed      => '##path##: Fehler beim Aendern der Inhaberschaft: ##error##',
    commands_dbd      => <<EOT,
SIE MUESSEN EINES DER FOLGENDEN KOMMANDOS AUSFUEHREN LASSEN (abhaengig davon,
welche Datenbank Sie verwenden):
EOT
    commands_optional => 'KOMMANDOS ZUR INSTALLATION OPTIONALER MODULE:',
    commands_required => <<EOT,
KOMMANDOS ZUR INSTALLATION BENOETIGTER MODULE (Sie *muessen* all diese
Kommandos ausfuehren, und dann dieses Skript erneut laufen lassen):
EOT
    done => 'erledigt.',
    extension_must_return_name => <<END,
##file## gab ##returned## zurueck, was keine gueltige Bezeichnung fuer eine
Erweiterung ist.
Erweiterungen muessen ihre Bezeichnung zurueckgeben, nicht 1 oder eine andere
Zahl.
Bitte beachten Sie die Dokumentation von Bugzilla::Extension fuer Details.
END
    feature_auth_ldap         => 'LDAP-Authentifizierung',
    feature_auth_radius       => 'RADIUS-Authentifizierung',
    feature_graphical_reports => 'Grafische Berichte',
    feature_html_desc         => 'Mehr HTML in Produkt- und Gruppenbeschreibungen',
    feature_inbound_email     => 'Eingehende E-Mail',
    feature_jobqueue          => 'Mailversand-Queue',
    feature_jsonrpc           => 'JSON-RPC-Schnittstelle',
    feature_new_charts        => 'Neue Grafiktechnik',
    feature_old_charts        => 'Alte Grafiktechnik',
    feature_mod_perl          => 'mod_perl',
    feature_moving            => 'Bugs zwischen Installationen transferieren',
    feature_patch_viewer      => 'Patch-Betrachter',
    feature_smtp_auth         => 'SMTP-Authentifizierung',
    feature_updates           => 'Automatische Update-Benachrichtigungen',
    feature_xmlrpc            => 'XML-RPC-Schnittstelle',

    header => "* Dies ist Bugzilla ##bz_ver## mit Perl ##perl_ver##\n"
            . "* auf ##os_name## ##os_ver##",
    install_all => <<EOT,

Um eine automatische Installation aller benoetigten und optionalen Module
zu versuchen, geben Sie folgenden Befehl ein:

  ##perl## install-module.pl --all

EOT
    install_data_too_long => <<EOT,
WARNUNG: Manche der Eintraege in der Tabellenspalte ##table##.##column## sind
laenger als die neue Maximallaenge von ##max_length## Zeichen. Die zu kuerzenden
Daten sind im Folgenden aufgefuehrt, mit dem Wert der Spalte ##id_column##
zuerst, und dahinter dem zu kuerzenden Wert der Spalte ##column##:

EOT
    install_module => 'Installiere ##module##, Version ##version##...',
    installation_failed => '*** Installation fehlgeschlagen. Bitte beachten Sie obige Meldungen. ***',
    max_allowed_packet => <<EOT,
WARNUNG: Sie muessen den max_allowed_packet-Parameter Ihrer MySQL-
Installation auf mindestens ##needed## setzen. Derzeit hat er den Wert
##current##. Sie koennen diesen Parameter im Abschnitt [mysqld] Ihrer MySQL-
Konfigurationsdatei pflegen.
EOT
    min_version_required => "Mindestens benoetigte Version: ",

# Note: When translating these "modules" messages, don't change the formatting
# if possible, because there is hardcoded formatting in
# Bugzilla::Install::Requirements to match the box formatting.
    modules_message_db => <<EOT,
***********************************************************************
* DATENBANKZUGRIFF                                                    *
***********************************************************************
* Bugzilla benoetigt zum Zugriff auf Ihre Datenbank das zu Ihrer      *
* Datenbank passende DBD-Modul. Im Folgenden finden Sie das korrekte  *
* Kommando, um das zu Ihrer Datenbank passende Modul zu installieren. *
EOT
    modules_message_optional => <<EOT,
***********************************************************************
* OPTIONALE MODULE                                                    *
***********************************************************************
* Einige Perl-Module benoetigt Bugzilla zwar nicht, Sie koennen aber  *
* zusaetzliche Funktionalitaeten aktivieren, wenn Sie sie             *
* installieren.                                                       *
*                                                                     *
* Nichtinstallierte optionale Module sind im Folgenden aufgelistet,   *
* mit der Bezeichnung der Funktionalitaet, die sie aktivieren.        *
* Darunter finden Sie die Kommandos, mit denen Sie die Module         *
* installieren koennen.                                               *
EOT
    modules_message_required => <<EOT,
***********************************************************************
* BENOETIGTE MODULE                                                   *
***********************************************************************
* Bugzilla erfordert einige Perl-Module, die derzeit entweder nicht   *
* installiert sind, oder in einer zu alten Version installiert sind.  *
* Im Folgenden finden Sie die Kommandos, mit denen Sie die Module     *
* installieren koennen.                                               *
EOT

    module_found => "v##ver## gefunden",
    module_not_found => "nicht gefunden",
    module_ok => 'in Ordnung',
    module_unknown_version => "unbekannte Version gefunden",
    no_such_module => "Es gibt bei CPAN kein Modul namens ##module##.",
    ppm_repo_add => <<EOT,
***********************************************************************
* Hinweis fuer Windows-Benutzer                                       *
***********************************************************************
* Um die aufgelisteten Module installieren zu koennen, muessen Sie    *
* zunaechst dieses Kommando als Administrator ausfuehren:             *
*                                                                     *
*   ppm repo add theory58S ##theory_url##
EOT
    ppm_repo_up => <<EOT,
*                                                                     *
* Anschliessend muessen Sie dies befehlen (ebenfalls als              *
* Administrator):                                                     *
*                                                                     *
*   ppm repo up theory58S                                             *
*                                                                     *
* Wiederholen Sie dieses Kommando so lange, bis Sie "theory58S" am    *
* Anfang der angezeigten Liste sehen.                                 *
EOT
    template_precompile   => "Kompiliere Templates vor...",
    template_removal_failed => <<END,
WARNUNG: Das Verzeichnis '##datadir##/template' konnte nicht geloescht werden.
         Es wurde nach '##datadir##/deleteme' verschoben und sollte manuell
         geloescht werden, um Festplattenplatz zurueckzugewinnen.
END
    template_removing_dir => "Entferne vorkompilierte Templates...",
);

1;
