# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Initial Developer of the Original Code is Everything Solved.
# Portions created by Everything Solved are Copyright (C) 2007
# Everything Solved. All Rights Reserved.
#
# The Original Code is the Bugzilla Bug Tracking System.
#
# Contributor(s): Max Kanat-Alexander <mkanat@bugzilla.org>
#
# Translated by Marc Schumann <wurblzap@gmail.com>

# This file contains a single hash named %strings, which is used by the
# installation code to display strings before Template-Toolkit can safely
# be loaded.
#
# Each string supports a very simple substitution system, where you can
# have variables named like ##this## and they'll be replaced by the string
# variable with that name.
#
# Please keep the strings in alphabetical order by their name.

%strings = (
    any  => 'beliebig',
    blacklisted => '(auf der schwarzen Liste)',
    checking_for => 'Ueberpruefe auf',
    checking_dbd      => 'Ueberpruefe verfuegbare Perl-DBD-Module...',
    checking_optional => 'Die folgenden Perl-Module sind optional:',
    checking_modules  => 'Ueberpruefe Perl-Module...',
    done => 'erledigt.',
    header => "* Dies ist Bugzilla ##bz_ver## auf perl ##perl_ver##\n"
            . "* auf ##os_name## ##os_ver##",
    install_all => <<EOT,

Um eine automatische Installation aller benoetigten und optionalen Module
zu versuchen, geben Sie folgenden Befehl ein:

  ##perl## install-module.pl --all

EOT
    install_data_too_long => <<EOT,
WARNUNG: Manche der Eintraege in der Tabellenspalte ##table##.##column## sind
laenger als die neue Maximallaenge von ##max_length## Zeichen. Die zu kuerzenden
Daten sind im Folgenden aufgefuehrt, mit dem Wert der Spalte ##id_column##
zuerst, und dahinter dem zu kuerzenden Wert der Spalte ##column##:

EOT
    install_module => 'Installiere ##module##, Version ##version##...',
    module_found => "v##ver## gefunden",
    module_not_found => "nicht gefunden",
    module_ok => 'in Ordnung',
    module_unknown_version => "unbekannte Version gefunden",
    template_precompile   => "Kompiliere Templates vor...",
    template_removing_dir => "Entferne vorkompilierte Templates...",
);

1;
