#Plugins must start with "Plugin"
#Put them in ~/.bughugger/plugins
#
# Author: Brian Murray <brian@canonical.com>
# Copyright (C) 2009 Canonical, Ltd.
#
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# This plugin will prompt for a user defined tag to add to bug reports

import gtk
class PluginTag():
    def __init__(self, launchpad):
        print "initializing PluginTag"
        self.launchpad = launchpad

    @property
    def buttontext(self):
        return "Add _Tag"

    def action(self, bug_tasks):
        dialog = gtk.Dialog("Tag",None,gtk.DIALOG_MODAL,(gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT, gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))
        content_area = dialog.get_content_area()
        hbox = gtk.HBox(2, 5)
        label = gtk.Label("Tag to use:")
        entry = gtk.Entry()
        hbox.pack_start(label,False, False)
        hbox.pack_end(entry, False, True)
        content_area.pack_start(hbox)
        hbox.show()
        label.show()
        entry.show()

        result = dialog.run()

        tag = entry.get_text()
        print tag
        
        if not result == gtk.RESPONSE_ACCEPT:
            return

        dialog.destroy()

        for bug_task in bug_tasks:
        # not for each task of a bug but the list of tasks passed to the Plugin
            if tag not in bug_task.bug.tags:
                bug = self.launchpad.bugs[bug_task.bug.id]# fresh bug object, LP: #336866 workaround
                bug.tags = bug.tags + ['%s' % tag]# LP: #254901 workaround
                bug.lp_save()
    
    @property
    def hide(self):
        return False

def InitializePlugin(launchpad):
    inst = PluginTag(launchpad)
    return inst
