#Plugins must start with "Plugin"
#Put them in ~/.bughugger/plugins
#
# Author: Brian Murray <brian@canonical.com>
# Copyright (C) 2009 Canonical, Ltd.
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# This plugin will ask a reporter to run apport-collect and set the bug to incomplete

import gtk
class PluginCollectIt():
    def __init__(self, launchpad):
        print "initializing PluginCollectIt"
        self.launchpad = launchpad

    @property
    def buttontext(self):
        return "_Collect It"

    def action(self, bug_tasks):
        for bug_task in bug_tasks:
        # not for each task of a bug but the list of tasks passed to the Plugin
            comment = "Thank you for taking the time to report this bug and helping to make Ubuntu better. Please execute the following command, as it will automatically gather debugging information, in a terminal:\n\napport-collect %s\n\nThis will help us to find and resolve the problem. Bear in mind that you may need to install the python-launchpadlib package from the universe repository.  Additionally, when prompted to give apport-collect permissions for Launchpad you will need to give it at least the ability to \"Change Non-Private\" data as it will be adding information to your bug report.  Thanks in advance!" % (bug_task.bug.id)
            bug_task.bug.newMessage(content=comment, subject="Request for information")
            bug_task.status = "Incomplete"
            bug_task.lp_save()

    @property
    def hide(self):
        return False

def InitializePlugin(launchpad):
    inst = PluginCollectIt(launchpad)
    return inst
