/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_WORKSPACE_H
#define INCLUDED_WORKSPACE_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QFRAME_H
#include <qframe.h>
#define INCLUDED_QFRAME_H
#endif // INCLUDED_QFRAME_H

#ifndef INCLUDED_QDIR_H
#include <qdir.h>
#define INCLUDED_QDIR_H
#endif // INCLUDED_QDIR_H

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif // INCLUDED_VECTOR

/*------- forward declarations:
-------------------------------------------------------------------*/
class QSplitter;
class LeftView;
class RightView;
class ViewWindow;
class OneFileCopier;
class ViewWindow;

/*------- class declaration:
-------------------------------------------------------------------*/
class Workspace : public QFrame
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	Workspace( QWidget* const in_parent );
private:
	Workspace( const Workspace& );
	Workspace& operator=( const Workspace& );

// ******* MEMBERS *******
private:
	static const int HANDLE_WIDTH;
	static const QString CMP_FILES_CAPTION;
	static const QString CMP_FILES_MSG;
	static const QString CMP_FILES_ICON;
	static const QString CMP_FILES_NEG_INFO;
	static const QString CMP_FILES_IOERROR;
	static const QString CMP_FILES_BREAK;
	static const QString CMP_FILES_EQUAL;
	static const QString CMP_FILES_NOT_EQUAL;
	static const QString CMP_FILES_KOMPARE;
	static const QString CMP_FILES_DIFF;
	static const QString KOMPARE_PRG_NAME;
	
	typedef std::vector<QString> Strings;
	//....................................
	enum {
		LEFT_TO_RIGHT = 1,
		RIGHT_TO_LEFT
	};
	//....................................
	ViewWindow*          d_left_view_window;
	ViewWindow*          d_right_view_window;
	QSplitter*     const d_splitter;
	LeftView*      const d_viewL;
	RightView*     const d_viewR;
	
// ******* MTHODS *******
public:
	void set_left_view_window ( ViewWindow* const in_view );
	void set_right_view_window( ViewWindow* const in_view );
private:
	void show             ();
	void ctrl_O           ();
	void copy_subdir      ( const QString& in_src_path, const QString& in_dst_path );
	void copy_next        ( const QFileInfo& in_fi, const QString& in_dst_path );
	bool can_copy         ( const QString& in_fname );
	void copy             ( const int in_direction );
	void pack             ( const int in_direction );
	void keyPressEvent    ( QKeyEvent* e );
private slots:
	void slot_switch_panels();
	void configure        ();
	void cmp_dirs         ();
	void dir_synch        ();
	void cmp_files        ();
	void date_time        ();
	void select           ();
	void unselect         ();
	void revers           ();
	void slot_ftp_start   ();
	void slot_ftp_end     ();
	void slotF2           ();
	void slotF3           ();
	void slotF4           ();
	void slotF5           ();
	void slotF6           ();
	void slotF7           ();
	void slotF8           ();
	void slotF9           ();
	void lang_changed     ();
	void selection_changed();
	void slot_tree        ();
	void slot_md5_create  ();
	void slot_md5_check   ();
	void disconnect_signals();
	void slot_tab_new     ();
	void slot_tab_remove  ();
	void slot_ftp_rejected();
signals:
	void looks_refresh    ();
	void select_left      ();
	void select_right     ();
	void unselect_left    ();
	void unselect_right   ();
	void revers_left      ();
	void revers_right     ();
	void ftp_start_left   ();
	void ftp_start_right  ();
	void ftp_end          ();
	void reload           ();
	void filter           ( bool in_on );
	void F2ToLeft         ();
	void F2ToRight        ();
	void F3ToLeft         ();
	void F3ToRight        ();
	void F4ToLeft         ();
	void F4ToRight        ();
	void F6ToLeft         ();
	void F6ToRight        ();
	void F7ToLeft         ();
	void F7ToRight        ();
	void F8ToLeft         ();
	void F8ToRight        ();
	void ftp_rejected     ();
	void stop             ();
	void update_lang      ();
	void update_selection ();
	void tree_left        ();
	void tree_right       ();
	void md5_create_left  ();
	void md5_check_left   ();
	void md5_create_right ();
	void md5_check_right  ();
	void tab_new_left     ();
	void tab_new_right    ();
	void tab_remove_left  ();
	void tab_remove_right ();
};

#endif // INCLUDED_WORKSPACE_H
