package Bric::Util::Language::ru_ru;

=encoding utf8

=head1 NAME

Bric::Util::Language::ru_ru - Bricolage Russian translation

=head1 VERSION

$LastChangedRevision$

=cut

require Bric; our $VERSION = Bric->VERSION;

=head1 DATE

$LastChangedDate: 2004-09-14 18:17:46 -0700 (Tue, 14 Sep 2004) $

=head1 SYNOPSIS

In F<bricolage.conf>:

  LOAD_LANGUAGES = ru_ru

=head1 DESCRIPTION

Bricolage Russian Translation.

=cut

use strict;
use utf8;
use base qw(Bric::Util::Language);

use constant key => 'ru_ru';

our %Lexicon = (

# Date
   'Jan' => 'Янв',
   'Feb' => 'Фев',
   'Mar' => 'Мар',
   'Apr' => 'Апр',
   'May' => 'Май',
   'Jun' => 'Июнь',
   'Jul' => 'Июль',
   'Aug' => 'Авг',
   'Sep' => 'Сен',
   'Oct' => 'Окт',
   'Nov' => 'Ноя',
   'Dec' => 'Дек',
   'Day' => 'День',
   'Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec' =>
   'Янв Фев Мар Апр Май Июнь Июль Авг Сен Окт Ноя Дек',
   'Month' => 'Мес',

# Time
   'Date'=>'Дата',
   'Hour'=> 'Час',
   'Minute'=>'Минута',
   'Second'=>'Секунда',

#Expiries
   '1 Day' => '1 День',
   '3 Days' => '3 Дня',
   '5 Days' => '5 Дней',
   '10 Days' => '10 Дней',
   '15 Days' => '15 Дней',
   '20 Days' => '20 Дней',
   '30 Days' => '30 Дней',
   '45 Days' => '45 Дней',
   '90 Days' => '90 Дней',
   '180 Days' => '180 Дней',
   '1 Year' => '1 Год',



# Priotity
   'High'=> 'Высокий',
   'Low'     => 'Низкий',
   'Medium High' => 'Выше среднего',
   'Medium Low' => 'Ниже среднего',
   'Normal'  => 'Нормальный',

# Areas
   'Alert Type Manager' => 'Менеджер Типов Оповещений',
   'Category Manager' => 'Менеджер Категорий',
   'Contributor Type Manager ' => 'Менеджер Типов Авторов',
   'Current Output Channels' => 'Текущие Каналы Вывода',
   'Destination Manager' => 'Destination Manager',
   'Element Manager' => 'Менеджер Элементов',
   'Element Type Manager' => 'Менеджер Типов Элементов',
   'Group Manager' => 'Менеджер Групп',
   'Job Manager' => 'Менеджер Заданий',
   'Manager' => 'Менеджер',
   'Media Gallery' => 'Галлерея Медиа-данных',
   'Media Type Manager' => 'Менеджер Типов Медиа-данных',
   'Preference Manager ' => 'Менеджер Предпочтений',
   'Source Manager '           => 'Менеджер Источников',
   'Source Manager' => 'Менеджер Источников',
   'User Manager' => 'Менеджер Пользователей',
   'Workflow Manager '         => 'Менеджер Ребочего Процесса',
   'Workflow Manager' => 'Менеджер Рабочего Процесса',
   'Workspace for [_1]' => 'Рабочее Пространство для [_1]',

# Interface Objects
   'Checkbox'  => 'Checkbox',
   'Columns' => 'Колонки',
   'Custom Fields' => 'Поля пользователя',
   'Page' => 'Страница',
   'Pulldown'  => 'Pulldown',
   'Radio Buttons' => 'Radio Buttons',
   'Rows'      => 'Строки',
   'Size'      => 'Размер',
   'Template'  => 'Шаблон',
   'Text Area' => 'Область текста',
   'Workflows' => 'Рабочие Процессы',
   'Workflow'  => 'Рабочий Процесс',
   '[_1] Field Text' => '[_1] Текст поля',

# General Information
  '&quot;Story&quot;' => '&quot;Текст&quot;',
  '&quot;Template&quot;' => '&quot;Шаблон&quot;',
  'ADMIN' => 'АДМИН',
  'ADVANCED SEARCH' => 'РАСШИРЕННЫЙ ПОИСК',
  'Actions' => 'Действия',
  'Active' => 'Активный',
  'Active Media' => 'Активные Медиа-данные',
  'Active Stories' => 'Активные Тексты',
  'Active Templates' => 'Активные Шаблоны',
  'Ad String' => 'Строка оповещения',
  'Ad String 2' => 'Строка оповещения 2',
  'Ad Strings' => 'Строки оповещения',
  'Admin' => 'Администратор',
  'Advanced Search' => 'Расширенный поиск',
  'Alert Types' => 'Типы Оповещений',
  'All' => 'Все',
  'All Contributors' => 'Все Авторы',
  'All Elements' => 'Все Элементы',
  'All Groups' => 'Все Группы',
  'All Categories' => 'Все Категории',
  'Asset Type' => 'Тип Материалов',
  'Available Groups' => 'Доступные Группы',
  'Available Output Channels' => 'Доступные Каналы Вывода',
  'Bricolage' => 'Bricolage',
  'By Last' => 'По последнему',
  'By Source name' => 'По имени Источника',
  'CONTACTS' => 'Контакты',
  'Caption' => 'Заголовок',
  'Categories' => 'Категории',
  'Category' => 'Категория',
  'Category Assets' => 'Материалы Категории',
  'Category Profile' => 'Профиль Категории',
  'Category tree' => 'Дерево Категорий',
  'Characters' => 'Символы',
  'Choose Site' => 'Выберите Сайт',
  'Contacts' => 'Контакты',
  'Content' => 'Контент',
  'Content Type' => 'Тип Контента',
  'Contributor Roles' => 'Роли Авторов',
  'Contributor Type' => 'Тип Автора',
  'Contributor Type Profile' => 'Профиль Типа Автора',
  'Contributor Types' => 'Типы Авторов',
  'Contributors' => 'Авторы',
  'Cookie' => 'Cookie',
  'Copy' => 'Копия',
  'Cover Date' => 'Заглавная Дата',
  'Current Groups' => 'Текущие Группы',
  'Current Note' => 'Текущее примечание',
  'Current Version' => 'Текущая версия',
  'Currently Related Story' => 'Текущий связанный текст',
  'DISTRIBUTION' => 'РАСПРОСТРАНЕНИЕ',
  'Data Elements' => 'Элементы Данных',
  'Default Value' => 'Значение по умолчанию',
  'Deployed Date' => 'Дата размещения',
  'Description' => 'Описание',
  'Desk Permissions' => 'Разрешения для Стола',
  'Desks' => 'Столы',
  'Destinations' => 'Адресаты',
  'Directory' => 'Каталог',
  'Display Name' => 'Имя для отображения',
  'Domain Name' => 'Имя Домена',
  'Download' => 'Загрузить',
  'Element' => 'Элемент',
  'Element Profile' => 'Профиль Элемента',
  'Element Type' => 'Тип Элемента',
  'Element Type Profile' => 'Профиль ТИпа Элемента',
  'Element Types' => 'Типы Элементов',
  'Elements' => 'Элементы',
  'Error' => 'Ошибка',
  'Event Type' => 'Тип События',
  'Events' => 'События',
  'Existing %n' => '%n имеется',
  'EXISTING CATEGORIES' => 'СУЩЕСТВУЮЩИЕ КАТЕГОРИИ',
  'EXISTING DESTINATIONS' => 'СУЩЕСТВУЮЩИЕ АДРЕСАТЫ',
  'EXISTING ELEMENT TYPES' => 'СУЩЕСТВУЮЩИЕ ТИПЫ ЭЛЕМЕНТОВ',
  'EXISTING ELEMENTS' => 'СУЩЕСТВУЮЩИЕ ЭЛЕМЕНТЫ',
  'EXISTING MEDIA TYPES' => 'СУЩЕСТВУЮЩИЕ МЕДИА-ТИПЫ',
  'EXISTING OUTPUT CHANNELS' => 'СУЩЕСТВУЮЩИЕ КАНАЛЫ ВЫВОДА',
  'EXISTING SOURCES' => 'СУЩЕСТВУЮЩИЕ ИСТОЧНИКИ',
  'EXISTING USERS' => 'СУЩЕСТВУЮЩИЕ ПОЛЬЗОВАТЕЛИ',
  'Expiration' => 'Истечение',
  'Expire Date' => 'Срок хранения',
  'Extension' => 'Расширение',
  'Extensions' => 'Расширения',
  'Fields' => 'Поля',
  'File Name' => 'Имя файла',
  'File Path' => 'Путь к файлу',
  'First' => 'Первый',
  'First Name' => 'Имя',
  'Fixed' => 'Фиксированный URL',
  'Generic' => 'Общий',
  'Group Type' => 'Тип Группы',
  'Groups' => 'Группы',
  'HTML::Template' => 'HTML::Template',
  'ID' => 'ID',
  'Information' => 'Информация',
  'Jobs' => 'Задания',
  'Key Name' => 'Ключевое Имя',
  'Label' => 'Метка',
  'Last' => 'Последний',
  'Last Name' => 'Фамилия',
  'Legal' => 'Legal',
  'Log' => 'Журнал',
  'Login ' => 'Имя Пользователя',
  'Login and Password' => 'Имя Пользователя и Пароль',
  'MIME Type' => 'Тип MIME',
  'Mason' => 'Mason',
  'Max size' => 'Максимальный размер',
  'Maximum size' => 'Максимальный размер',
  'Media' => 'Медиа',
  'Media Profile' => 'Профиль Медиа',
  'Media Type' => 'Тип Медиа',
  'Media Type Element' => 'Элемент Типа Медиа',
  'Media Type Profile' => 'Профиль Типа Медиа',
  'Media Types' => 'Типы Медиа',
  'Member Type  ' => 'Тип Члена',
  'Members' => 'Члены',
  'My Alerts' => 'Мои Оповещения',
  'My Workspace' => 'Мое Рабочее Пространство',
  'NAME' => 'ИМЯ',
  'Name' => 'Имя',
  'Never' => 'Никогда',
  'New' => 'Новый',
  'New Role Name' => 'Новое Имя Роли',
  'New password' => 'Новый пароль',
  'No' => 'Нет',
  'No custom fields defined.' => 'Не определены поля пользователя',
  'Normal' => 'Нормальный',
  'Note' => 'Примечание',
  'Note saved.' => 'Сохраненное примечание.',
  'Notes' => 'Примечания',
  'OS' => 'ОС',
  'Old password' => 'Старый пароль',
  'Option, Label' => 'Опция, Метка',
  'Options, Label' => 'Опции, Метка',
  'Order' => 'Порядок',
  'Organization' => 'Организация',
  'Output Channel' => 'Канал вывода',
  'Output Channels' => 'Каналы вывода',
  'Owner' => 'Владелец',
  'PREFERENCES' => 'ПРЕДПОЧТЕНИЯ',
  'PROPERTIES' => 'СВОЙСТВА',
  'PUBLISHING' => 'ПУБЛИКАЦИЯ',
  'Parent Category' => 'Категория-родитель',
  'Password' => 'Пароль',
  'Pending ' => 'Ожидание',
  'Pending %n' => 'Ожидание %n',
  'Position' => 'Позиция',
  'URI Suffix' => 'URI суффикс',
  'URI Prefix' => 'URI перфикс',
  'Preferences' => 'Предпочтения',
  'Prefix' => 'Префикс',
  'Previews' => 'Просмотр',
  'Primary Category' => 'Первичная Категория',
  'Primary Output Channel' => 'Первичный Канал вывода',
  'Priority' => 'Приоритет',
  'Profile' => 'Профиль',
  'Properties' => 'Свойства',
  'Publish Date' => 'Дата публикации',
  'Publish Desk' => 'Стол публикации',
  'Publishes' => 'Публикует',
  'Recipients' => 'Получатели',
  'Related Media' => 'Связанные Медиа-данные',
  'Related Story' => 'Связанные тексты',
  'Repeatable' => 'Повторяющийся',
  'Required' => 'Требуемый',
  'Resources' => 'Ресурсы',
  'Role' => 'Роль',
  'Roles' => 'Роли',
  'STORIES' => 'ТЕКСТЫ',
  'SYSTEM' => 'СИСТЕМА',
  'Separator String' => 'Строка-разделитель',
  'Simple Search' => 'Простой поиск',
  'Site Profile' => 'Профиль сайта',
  'Sites' => 'Сайты', 
  'Site'  => 'сайт',
  'Slug' => 'Идентификатор',
  'Source' => 'Источник',
  'Source Profile' => 'Профиль Источника',
  'Source name' => 'Имя Источника',
  'Sources' => 'Источники',
  'Start Desk' => 'Исходный Стол',
  'Statistics' => 'Статистика',
  'Story' => 'Текст',
  'Story Type' => 'Тип Текста',
  'Story Type Element' => 'Тип Элемента Текста',
  'Subelements' => 'Субэлементы',
  'Teaser' => 'Teaser',
  'Template Name' => 'Имя Шаблона',
  'Text box' => 'Окно текста',
  'Title' => 'Заголовок',
  'Trail' => 'След',
  'Type' => 'Тип',
  'URI' => 'URI',
  'URL' => 'URL',
  'Username' => 'Имя пользователя',
  'Users' => 'Пользователи',
  'Value Name' => 'Имя значения',
  'Version' => 'Версия',
  'Welcome to Bricolage.' => 'Добро пожаловать в Bricolage',
  'Welcome to [_1].' => 'Добро пожаловать в [_1]',
  'Words' => 'Слова',
  'Workflow Permissions' => 'Разрешения рабочего процесса',
  'Year' => 'Год',
  'Yes' => 'Да',
  '_AUTO' => 1,
  'all' => 'все',
  'one per line' => 'по одному в строке',
  'to' => 'для',


# Action Commands

   'Associate' => 'Ассоциировать',
   'Add New Field' => 'Добавить новое поле',
   'Add a New Alert Type' => 'Добавить новый Тип Оповещений',
   'Add a New Category' => 'Добавить новую Категорию',
   'Add a New Contributor Type' => 'Добавит новый тип Авторов',
   'Add a New Desk' => 'Добавить новый Стол',
   'Add a New Destination' => 'Добавить нового Адресата',
   'Add a New Element Type' => 'Добавить новый Тип Элементов',
   'Add a New Element' => 'Добавить новый Элемент',
   'Add a New Group' => 'Новую Группу',
   'Add a New Media Type' => 'Добавить новый Тип Медиа',
   'Add a New Output Channel' => 'Добавить новый Канал Вывода',
   'Add a New Source' => 'Добавить новый Источник',
   'Add a New Workflow' => 'Добавить новый Рабочий Процесс',
   'Add a New Keyword' => 'Добавить новое Ключевое Слово',
   'Add a New User' => 'Добавить нового Пользователя',
   'Add to Element' => 'Добавить к Элементу',
   'Add to Include' => 'Добавить для включения',
   'Add' => 'Добавить',
   'Allow multiple' => 'Разрешить несколько',
   'Burner' => 'Система публикации',
   'Check In Assets' => 'Отправить Материалы',
   'Check In to Edit' => 'Отправить для редактирования',
   'Check In to Publish' => 'Отправить для публикации',
   'Check In to' => 'Отправить для',
   'Check In' => 'Отправить',
   'Checkin' => 'Отправить',
   'Check Out' => 'Загрузить',
   'Checkout' => 'Загрузить',
   'Choose Contributors' => 'Выбрать авторов',
   'Choose Related Media' => 'Выбрять связанные Медиа-данные',
   'Choose Subelements' => 'Выбрать субэлементы',
   'Create a New Category' => 'Создать новую Категорию',
   'Create a New Media' => 'Создать новые Медиа-данные',
   'Create a New Story' => 'Создать новый Текст',
   'Create a New Template' => 'Создать новый Шаблон',
   'Delete this Desk from all Workflows' =>
   'Удалить этот Стол из всех рабочих процессов',
   'Delete this Element' => 'Удалить этот Элемент',
   'Delete this Profile' => 'Удалить этот профиль',
   'Delete' => 'Удалить',
   'Deploy' => 'Разместить',
   'Download' => 'Загрузить',
   'Edit' => 'Редактировать',
   'Expire' => 'Истечь',
   'Find Media' => 'Найти Медиа-данные',
   'Find Stories' => 'Найти Тексты',
   'Find Templates' => 'Найти Шаблоны',
   'Manage' => 'Управлять',
   'Move Assets' => 'Переместить Материалы',
   'Move to' => 'Переместить',
   'New Media ' => 'Новые Медиа-данные ',
   'New Media' => 'Новые Медиа-данные',
   'New Story' => 'Новый Текст',
   'New Template' => 'Новый Шаблон',
   'Preview in' => 'Просмотреть в',
   'Publish' => 'Публиковать',
   'Relate' => 'Соотноести',
   'Remove' => 'Удалить',
   'Repeat new password' => 'Повторите новый пароль',
   'SEARCH' => 'ПОИСК',
   'SUBMIT' => 'ПЕРЕДАТЬ',
   'Scheduler' => 'Планировщик',
   'Select Desk' => 'Выбрать Стол',
   'Select Role' => 'Выбрать Роль',
   'Select an Event Type' => 'Выбрать Тип События',
   'Select' => 'Выбрать',
   'Sort By' => 'Сортировать по',
   'Submit' => 'Передать',
   'Switch Roles' => 'Переключить роли',
   'Template Profile' => 'Профиль шаблона',
   'Template Code' => 'Код шаблона',
   'Un-Associate' => 'Разъединить',
   'Upload a file' => 'Подгрузить файл',
   'User Override' => 'Обойти пользователя',
   'View' => 'Просмотр',
   'Workflow Profile' => 'Профиль Рабочего Процесса',
   'Grant "[_1]" members permission to access assets in these categories.' =>
    'Предоставить разрешение [_1] членам для доступа к данным в этих Категориях.',
   'Grant "[_1]" members permission to access assets in these workflows.' =>
    'Предоставить разрешение [_1] членам для доступа к данным в этих Рабочих Процессах.',
   'Grant "[_1]" members permission to access assets on these desks.' =>
    'Предоставить разрешение [_1] членам для доступа к данным на этих Столах.',
   'Grant "[_1]" members permission to access the members of these groups.' =>
    'Предоставить разрешение [_1] членам для доступа к членам в этих Группах.',
   'Grant the members of the following groups permission to access the members of the "[_1]" group.' =>
    'Предоставить разрешение членам следующих групп для доступа к членам "[_1]" Группы.',


# System reply messages
  '"[_1]" Elements saved.' => '"[_1]" Элементов сохранено.',
  '%n Found' => '%n Найдено',
  '404 NOT FOUND' => '404 -- НЕ НАЙДЕН',
  'A site with the [_1] "[_2]" already exists' => 'Сайт с [_1] "[_2]" уже существует',
  'Action profile "[_1]" deleted.' => 'Профиль действия "[_1]" удален.',
  'Action profile "[_1]" saved.' => 'Профиль действия "[_1]" сохранен.',
  'Add a New Action' => 'Добавить новое действие',
  'Add a New Server' => 'Добавить новый сервер',
  'Alert Type profile "[_1]" deleted.' => 'Профиль Типа Оповещения "[_1]" удален.',
  'Alert Type profile "[_1]" saved.' => 'Профиль Типа Оповещения "[_1]" сохранен.',
  'Alias in Category' => 'Алиас в Категории',
  'Alias to "[_1]" created and saved.' => 'Алиас на "[_1]" создан и сохранен.',
  'All Types' => 'Все Типы',
  'An "[_1]" attribute already exists. Please try another name.' => 'Атрибут "[_1]" уже существует. Попробуйте другое имя.',
  'An active template already exists for the selected output channel, category, element and burner you selected.  You must delete the existing template before you can add a new one.' => 'Для выбранных вами Канала Вывода, Категории, Элемента или Системы публикации активный шаблон уже существует. Вам необходимо удалить существующий шаблон прежде, чем добавлять новый.',
  'An error occurred while processing your request:' => 'При обработке вашего запроса возникла ошибка:',
  'An error occurred.' => 'Возникла ошибка.',
  'At least one extension is required.' => 'Необходимо как минимум одно расширение.',
  'Bad element name "[_1]". Did you mean "[_2]"?' => 'Неверное имя Элемента "[_1]". Может быть "[_2]"?',
  'Cannot auto-publish related media "[_1]" because it is checked out.' => 'Автопубликация связанных медиа-данных невозможна потому, что они уже кем-то загружены.',
  'Cannot auto-publish related story "[_1]" because it is checked out.' => 'Автопубликация связанного текста невозможна потому, что он уже кем-то загружен.',
  'Cannot both delete and make primary a single output channel.' => 'Назначение первичным и одновременное удаление Канала вывода -- невозможны',
  'Cannot cancel "[_1]" because it is currently executing.' => 'Невозможно отменить выполнение. "[_1]" уже выполняется.',
  'Cannot create an alias to a media in the same site.' => 'Нельзя создать алиас для Медиа-данных на том же сайте.',
  'Cannot create an alias to a story in the same site.' => 'Нельзя создать алиас для Текста на том же сайте.',
  'Cannot move [_1] asset "[_2]" while it is checked out' => 'НЕвозможно переместить [_1] материалы "[_2]", поскольку они кем-то уже загружены.',
  'Cannot preview asset "[_1]" because there are no Preview Destinations associated with its output channels.' => 'Невозмоэно просмотреть материалы "[_1]", поскольку с данным Каналом вывода не связано ни одного места для просмотра.',
  'Cannot publish asset "[_1]" to "[_2]" because there are no Destinations associated with this output channel.' => 'Невозможно опубликовать материалы "[_1]" на "[_2]", поскольку с данным Каналом вывода не связано ни одного места для публикации.',
  'Cannot publish checked-out media "[_1]"' => 'С медиа-материалами "[_1]" еще работают. Публикация невозможна.',
  'Cannot publish checked-out story "[_1]"' => 'С текстами "[_1]" еще работают. Публикация невозможна.',
  'Cannot publish media "[_1]" because it is checked out.' => 'Невозможно опубликовать медиа-материалы "[_1]", поскольку с ними еще работают.',
  'Cannot publish story "[_1]" because it is checked out.' => 'Невозможно опубликовать текст "[_1]", поскольку с ними еще работают.',
  'Cascade into Subcategories' => 'Разбить на Подкатегории',
  'Category "[_1]" added.' => 'Категория "[_1]" добавлена.',
  'Category "[_1]" cannot be deleted.' => 'Категория"[_1]" не может быть удалена.',
  'Category "[_1]" disassociated.' => 'Категория "[_1]" отсоединена.',
  'Category Permissions' => 'Разрешения Категории',
  'Category URI' => 'URI Категории',
  'Category profile "[_1]" and all its categories deleted.' => 'Профиль Категории "[1]" и все соответствующие Категории удалены.',
  'Category profile "[_1]" deleted.' => 'Профиль Категории"[_1]" удален.',
  'Category profile "[_1]" saved.' => 'Профиль Категории "[_1]" сохранен.',
  'Changes not saved: permission denied.' => 'Изменения не сохранены: доступ запрещен.',
  'Check In to [_1]' => 'Отправить на [_1]',
  'Choose a Related Story' => 'Выберите связанный текст',
  'Contributor "[_1]" disassociated.' => 'Автор "[_1]" отсоединен.',
  'Contributor Type Manager' => 'Менеджер ТИпов Авторов',
  'Contributor profile "[_1]" deleted.' => 'Тип Автора "[_1]" удален.',
  'Contributor profile "[_1]" saved.' => 'Профиль Автора "[_1]" сохранен.',
  'Contributors disassociated.' => 'Авторы отсоединены.',
  'Copy Resources' => 'Копировать ресурсы',
  'Cover Date incomplete.' => 'Неполная Заглавная Дата.',
  'Delete this Category and All its Subcategories' => 'Удалить эту Категорию и все ее Подкатегории',
  'Deployed Version' => 'Размещенная версия',
  'Desk profile "[_1]" deleted from all workflows.' => 'Профиль стола "[_1]" удален из всех рабочих процессов.',
  'Destination' => 'Адресат (Место)',
  'Destination Profile' => 'Профиль Адресата',
  'Destination not specified' => 'Адресат не указан',
  'Destination profile "[_1]" deleted.' => 'Профиль адресата "[_1]" удален.',
  'Destination profile "[_1]" saved.' => 'Профиль адресата "[_1]" сохранен.',
  'Directory name "[_1]" contains invalid characters. Please try a different directory name.' => 'Имя каталога "[_1]" содержит недопустимые символы. Задайте другое имя каталога.',
  'Distributing files.' => 'Передаваемые файлы.',
  'Document Root' => 'Корневой каталог сайта',
  'Element "[_1]" deleted.' => 'Элемент "[_1]" удален.',
  'Element "[_1]" saved.' => 'Элемент "[_1]" сохранен.',
  'Element Type profile "[_1]" deleted.' => 'Профиль Типа Элемента "[_1]" удален.',
  'Element Type profile "[_1]" saved.' => 'Профиль Типа Элемента "[_1]" сохранен.',
  'Expire Date incomplete.' => 'Срок хранения задан не полностью.',
  'Extension "[_1]" ignored.' => 'Расширение "[_1]" проигнорировано.',
  'Extension "[_1]" is already used by media type "[_2]".' => 'Расширение "[_1]" уже используется Медиа-типом "[_2]".',
  'FTP' => 'FTP',
  'Field "[_1]" appears more than once but it is not a repeatable element.  Please remove all but one.' => 'Поле "[_1]" повторяется, не являясь повторяющимся элементом. Оставьте только одно.',
  'Field profile "[_1]" deleted.' => 'Профиль поля "[_1]" удален.',
  'Field profile "[_2]" saved.' => 'Профиль поля "[_1]" сохранен.',
  'File System' => 'Файловая система',
  'Find Media To Alias' => 'Найти Медиа-данные по алиасу',
  'Find Story To Alias' => 'Найти Текст по алиасу',
  'Find a media to alias' => 'Найти Медиа-данные по алиасу',
  'Find a story to alias' => 'Найти Текст по алиасу',
  'From' => 'От',
  'Group Label' => 'Метка Группы',
  'Group Memberships' => 'Членство в Группах',
  'Group cannot be deleted.' => 'Группа не может быть удалена.',
  'Group profile "[_1]" deleted.' => 'Профиль Группы "[_1]" удален.',
  'Group profile "[_1]" saved.' => 'Профиль Группы "[_1]" сохранен.',
  'Hi [_1]!' => 'Привет [_1]!',
  'Host Name' => 'Имя компьютера',
  'Invalid date value for "[_1]" field.' => 'Неверная дата для поля "[_1]".',
  'Invalid page request' => 'Некорректный запрос страницы',
  'Invalid password. Please try again.' => 'Неверный пароль. Повторите еще раз.',
  'Invalid username or password. Please try again.' => 'Неверные имя пользователя или пароль. Повторите еще раз.',
  'Job profile "[_1]" deleted.' => 'Профиль задания "[_1]" удален.',
  'Job profile "[_1]" saved.' => 'Профиль задания "[_1]" сохранен.',
  'Keyword' => 'Ключевое слово',
  'Keyword Manager' => 'Менеджер ключевых слов',
  'Keyword Profile' => 'Профиль ключевого слова',
  'Keywords' => 'Ключевые слова',
  'Keywords saved.' => 'Ключевые слова сохранены.',
  'Login "[_1]" contains invalid characters.' => 'Имя пользователя "[_1]" содержит недопустимые символы.',
  'Login "[_1]" is already in use. Please try again.' => 'Имя "[_1]" уже используется. Попробуйте еще раз.',
  'Login cannot be blank. Please enter a login.' => 'Имя пользователя не должно быть пустым. Введите корректное имя.',
  'Login must be at least [_1] characters.' => 'Имя пользователя должно содержать не менее [_1] символов.',
  'MEDIA FOUND' => 'НАЙДЕННЫЕ МЕДИА-ДАННЫЕ',
  'Media "[_1]" check out canceled.' => 'Загрузка медиа-данных "[_1]" прервана.',
  'Media "[_1]" created and saved.' => 'Медиа-данные "[_1]" созданы и сохранены.',
  'Media "[_1]" deleted.' => 'Медиа-данные "[_1]" удалены.',
  'Media "[_1]" published.' => 'Медиа-данные "[_1]" опубликованы.',
  'Media "[_1]" reverted to V.[_2]' => 'Медиа-данные "[_1]" возвращены к версии [_2]',
  'Media "[_1]" saved and checked in to "[_2]".' => 'Медиа-данные "[_1]" сохранены и отправлены в "[_2]".',
  'Media "[_1]" saved and moved to "[_2]".' => 'Медиа-данные "[_1]" сохранены и перемещены в "[_2]".',
  'Media "[_1]" saved and shelved.' => 'Медиа-данные "[_1] сохранены и заархивированы.',
  'Media "[_1]" saved.' => 'Медиа-данные "[_1]" сохранены.',
  'Media Type profile "[_1]" deleted.' => 'Профиль Типа Медиа-данных "[_1]" удален.',
  'Media Type profile "[_1]" saved.' => 'Профиль Типа Медиа-данных "[_1]" сохранен.',
  'Move Method' => 'Метод перемещения',
  'Move to Desk' => 'Переместить на Стол',
  'Name is required.' => 'Требуется Имя.',
  'Needs to be Deployed' => 'Необходимо разместить',
  'Needs to be Published' => 'Необходимо опубликовать',
  'New Alias' => 'Новый Алиас',
  'New passwords do not match. Please try again.' => 'Новый пароль не совпадает. Попробуйте еще раз.',
  'No Alias' => 'Нет Алиаса',
  'No alert types were found' => 'Тип оповещений не найден',
  'No categories were found' => 'Категории не найдены',
  'No contributor types were found' => 'Типы авторов не найдены',
  'No contributors defined' => 'Авторы отсутствуют',
  'No contributors defined.' => 'Авторы отсутствуют. ',
  'No destinations were found' => 'Адресаты не найдены',
  'No element types were found' => 'Типы элементов не найдены',
  'No elements are present.' => 'Элементы отсутствуют.',
  'No elements have been added.' => 'Не добавлено ни одного элемента.',
  'No elements were found' => 'Элементы не найдены',
  'No existing notes.' => 'Нет примечаний.',
  'No file associated with media "[_1]". Skipping.' => 'Отсутствует файл, связанный с медиа-данными "[_1]". Пропущено.',
  'No file has been uploaded' => 'Файл не отправлен',
  'No groups were found' => 'Группы не найдены',
  'No jobs were found' => 'Задания не найдены',
  'No keywords defined.' => 'Ключевые слова не определены.',
  'No media file is associated with asset "[_1]", so none will be distributed.' => 'Нет медиа-файла связанного с материалами "[_1]", поэтому ничего отправлено не будет.',
  'No media types were found' => 'Типы медиа-данных не найдены',
  'No media were found' => 'Медиа-данные не найдены',
  'No output channels were found' => 'Каналы вывода не найдены',
  'No output to preview.' => 'Нет результатов для просмотра',
  'No related Stories' => 'Нет связанных текстов',
  'No servers were found' => 'Серверы не найдены',
  'No sources were found' => 'Источники не найдены',
  'No stories were found' => 'Тексты не найдены',
  'No templates were found' => 'Шаблоны не найдены',
  'No users were found' => 'Пользователи не найдены',
  'No workflows were found' => 'Рабочие процессы не найдены',
  'Note: Container element "[_1]" removed in bulk edit but will not be deleted.' => 'Примечание: Контейнерный элемент "[_1]" удален из группового редактирования, но, как таковой, удален не будет.',
  'Note: Data element "[_1]" is required and cannot be completely removed.  Will delete all but one.' => 'Примечание: Элемент данных "[_1]" необходим и не может быть полностью удален. Будут удалены все, кроме одного.',
  'Object Group Permissions' => 'Разрешения для Группы Объектов',
  'Or Pick a Type' => 'или выберите ТИП',
  'Output Channel profile "[_1]" deleted.' => 'Профиль Канала Вывода "[_1]" удален.',
  'Output Channel profile "[_1]" saved.' => 'Профиль Канала Вывода "[_1]" сохранен.',
  'PENDING JOBS' => 'ОЖИДАЮЩИЕ ЗАДАНИЯ',
  'Parent cannot choose itself or its child as its parent. Try a different parent.' => 'Родитель не может выбрать себя или своего потомка в качестве собственного родителя. Выберите другого родителя.',
  'Password contains illegal preceding or trailing spaces. Please try again.' => 'Пароль содержит пробелы в начале или в конце. Введите еще раз.',
  'Passwords cannot have spaces at the beginning!' => 'Пробелы в начале пароля не допускаются!',
  'Passwords cannot have spaces at the end!' => 'Пробелы в конце пароля не допускаются!',
  'Passwords do not match!  Please re-enter.' => 'Пароли не совпадают! Повторите ввод.',
  'Passwords must be at least [_1] characters!' => 'Количество символов в пароле не должно быть меньше [_1]!',
  'Passwords must match!' => 'Пароли должны совпадать!',
  'Permission Denied' => 'Разрешение отсутствует',
  'Permission to checkout "[_1]" denied.' => 'Разрешение на загрузку "[_1]" отсутствует.',
  'Permission to delete "[_1]" denied.' => 'Разрешение на удаление "[_1]" отсутствует.',
  'Permissions saved.' => 'Разрешения сохранены',
  'Please check the URL and try again. If you feel you have reached this page as a result of a server error or other bug, please notify the server administrator. Be sure to include as much detail as possible, including the type of browser, operating system, and the steps leading up to your arrival here.' => 'Проверьте URL и повторите попытку. Если вы думаете, что получили это сообщение в результате сбоя сервера или другой ошибки, то известите системного администратора. Постарайтесь собрать как можно больше подробностей, включая тип броузера, тип операционной системы, а также протокол действий, в результате которых вы оказались здесь.',
  'Please click [_1]here[_2] to start.' => 'Начало работы [_1]здесь[_2].',
  'Please log in:' => 'Введите имя пользователя:',
  'Please select a primary category.' => 'Выберите первичную категорию.',
  'Please select a primary output channel.' => 'Выберите первичный канал вывода.',
  'Please select a story type.' => 'Выберите тип текста.',
  'Preference "[_1]" updated.' => 'Предпочтение "[_1]" изменено.',
  'Problem adding "[_1]"' => 'Проблема добавлена "[_1]".',
  'Problem deleting "[_1]"' => 'Проблема удалена "[_1]".',
  'Published Version' => 'Опубликованная версия',
  'Redirecting to preview.' => 'Перенаправление для просмотра.',
  'Related Media to Alias' => 'Связанные Медиа-данные по Алиасу',
  'Related Story to Alias' => 'Связанные Тексты по Алиасу',
  'STORY INFORMATION' => 'ИНФОРМАЦИЯ О ТЕКСТЕ',
  'Scheduled Time' => 'Запланированное время',
  'Select Alias' => 'Выберите Алиас',
  'Select Categories' => 'Выберите Категории',
  'Separator Changed.' => 'Разделитель изменен.',
  'Server profile "[_1]" deleted.' => 'Профиль сервера "[_1]" удален.',
  'Server profile "[_1]" saved.' => 'Профиль сервера "[_1]" сохранен.',
  'Servers' => 'Серверы',
  'Site "[_1]" requires a primary output channel.' => 'Сайт "[_1]" требует первичного канала вывода',
  'Site profile "[_1]" deleted.' => 'Профиль сайта "[_1]" удален.',
  'Site profile "[_1]" saved.' => 'Профиль сайта "[_1]" сохранен.',
  'Slug must conform to URI character rules.' => 'Идентификатор должен удовлетворять правилам написания URI.',
  'Sort Name' => 'Имя сортировки',
  'Source profile "[_1]" deleted.' => 'Профиль источника "[_1]" удален.',
  'Source profile "[_1]" saved.' => 'Профиль источника "[_1]" сохранен.',
  'Status' => 'Статус',
  'Stories' => 'Тексты',
  'Stories in this category' => 'Тексты в этой категории',
  'Story "[_1]" check out canceled.' => 'Загрузка текста "[_1]" прервана.',
  'Story "[_1]" created and saved.' => 'Текст "[_1]" создан и сохранен.',
  'Story "[_1]" deleted.' => 'Текст "[_1]" удален.',
  'Story "[_1]" published.' => 'Текст "[_1]" опубликован.',
  'Story "[_1]" reverted to V.[_2].' => 'Текст "[_1]" возвращен к версии [_2].',
  'Story "[_1]" saved and checked in to "[_2]".' => 'Текст "[_1]" сохранен и отправлен в "[_2]".',
  'Story "[_1]" saved and moved to "[_2]".' => 'Тект "[_1]" сохранен и перемещен в "[_2]"',
  'Story "[_1]" saved and shelved.' => 'Текст "[_1]" сохранен и заархивирован.',
  'Story "[_1]" saved.' => 'Текст "[_1]" сохранен.',
  'Template "[_1]" check out canceled.' => 'Загрузка шаблона "[_1]" прервана.',
  'Template "[_1]" deleted.' => 'Шаблон "[_1]" удален.',
  'Template "[_1]" saved and checked in to "[_2]".' => 'Шаблон "[_1]" сохранен и отправлен в "[_2]".',
  'Template "[_1]" saved and moved to "[_2]".' => 'Шаблон "[_1]" сохранен и перемещен в "[_2]".',
  'Template "[_1]" saved and shelved.' => 'Шаблон "[_1]" сохранен и заархивирован.',
  'Template "[_1]" saved.' => 'Шаблон "[_1]" сохранен.',
  'Template Includes' => 'Шаблон включает',
  'Template compile failed: [_1]' => 'Ошибка при компиляции Шаблона: [_1]',
  'Template deployed.' => 'Шаблон размещен',
  'Templates' => 'Шаблоны',
  'Templates Found' => 'Найденные Шаблоны',
  'Text to search' => 'Текст для поиска',
  'The URI "[_1]" is not unique. Please change the cover date, output channels, category, or file name as necessary to make the URIs unique.' => 'Такой URI "[_1]" уже существует. Для получения уникального URI измените заглавную дату, каналы вывода, категорию или имя файла.',
  'The URL you requested, <b>[_1]</b>, was not found on this server' => 'Запрошенный URL, <b>[_1]</b>, на этом сервере не найден',
  'The name "[_1]" is already used by another Alert Type.' => 'Имя "[_1]" уже используется другим Типом Оповещений.',
  'The name "[_1]" is already used by another Desk.' => 'Имя "[_1]" уже используется на другом Столе.',
  'The name "[_1]" is already used by another Destination.' => 'Имя "[_1]" уже используется другим Адресатом',
  'The name "[_1]" is already used by another Element Type.' => 'Имя "[_1]" уже используется другим Типом Элементов.',
  'The name "[_1]" is already used by another Media Type.' => 'Имя "[_1]" уже используется другим Медиа-типом.',
  'The name "[_1]" is already used by another Output Channel.' => 'Имя "[_1]" уже используется другим Каналом Вывода.',
  'The name "[_1]" is already used by another Server in this Destination.' => 'Имя "[_1]" уже используется другим Сервером у данного Адресата',
  'The name "[_1]" is already used by another Source.' => 'Имя "[_1]" уже используется другим Источником',
  'The name "[_1]" is already used by another Workflow.' => 'Имя "[_1]" уже используется другим Рабочим Процессом.',
  'The slug can only contain alphanumeric characters (A-Z, 0-9, - or _)!' => 'Идентификатор должен содержать только алфавитно-цифровые символы (A-Z, 0-9, - или _)!',
  'The slug, category and cover date you selected would have caused this story to have a URI conflicting with that of story [_1].' => 'URI, полученный из выбранных вами идентификатора, категории и заглавной даты, конфликтует с URI текста [_1].',
  'This day does not exist! Your day is changed to the' => 'Такой день не существует! Ваш день заменен на',
  'This story has not been assigned to a category.' => 'Текст не присвоен категории.',
  'To' => 'Чтобы',
  'URI "[_1]" is already in use. Please try a different directory name or parent category.' => 'URI "[_1]" уже используется. Используйте другое имя каталога или родительской директории.',
  'Un-relate' => 'Разъединить',
  'User profile "[_1]" deleted.' => 'Профиль пользователя "[_1]" удален.',
  'User profile "[_1]" saved.' => 'Профиль пользователя "[_1]" сохранен.',
  'Usernames must be at least 6 characters!' => 'Имена пользователей должны состоять не менее, чем из 6 символов!',
  'Using Bricolage without JavaScript can result in corrupt data and system instability. Please activate JavaScript in your browser before continuing.' => 'Использование Bricolage без JavaScript может привести к разрушению данных и нестабильности системы. Для продолжения активируйте JavaScript в вашем броузере.',
  'V.' => 'V.',
  'Value of [_1] cannot be empty' => 'Значение [_1] не может быть пустым',
  'Warning! Bricolage is designed to run with JavaScript enabled.' => 'Внимание! Для работы Bricolage необходимо включить JavaScript.',
  'Warning! State inconsistent: Please use the buttons provided by the application rather than the \'Back\'/\'Forward\' buttons.' => 'Внимание! Недопустимое состояние: для навигации используйте клавиши приложения, а не \'Назад\'/\'Вперед\'.',
  'Warning:  Use of element\'s \'name\' field is deprecated for use with element method \'get_container\'.  Please use the element\'s \'key_name\' field instead.' => 'Внимание:  Использование поля \'name\' элемента в методе \'get_container\' не допускается. Используйте поле \'key_name\'.',
  'Warning:  Use of element\'s \'name\' field is deprecated for use with element method \'get_data\'.  Please use the element\'s \'key_name\' field instead.' => 'Внимание:  Использование поля \'name\' элемента с методом \'get_data\' не допускается.  Используйте поле \'key_name\'.',
  'Warning: object "[_1]" had no associated desk.  It has been assigned to the "[_2]" desk.' => 'Внимание: объект "[_1]" не связан ни с одним Столом. Он будет привязан к Столу "[_2]".',
  'Warning: object "[_1]" had no associated workflow.  It has been assigned to the "[_2]" workflow.' => 'Внимание: объект "[_1]" не связан с Рабочим Процессом. Он будет привязан к процессу "[_2]"',
  'Warning: object "[_1]" had no associated workflow.  It has been assigned to the "[_2]" workflow. This change also required that this object be moved to the "[_3]" desk.' => 'Внимание: объект "[_1]" не связан с Рабочим Процессом. Он будет привязан к процессу "[_2]". При этом требуется переместить объект на стол "[_3]"',
  'Welcome to [_1]' => 'Добро пожаловать в [_1]',
  'Workflow profile "[_1]" deleted.' => 'Профиль Рабочего Процесса "[_1]" удален.',
  'Writing files to "[_1]" Output Channel.' => 'Запись файлов в Канал Вывода "[_1]".',
  'You are about to permanently delete items! Do you wish to continue?' => 'Вы собрались безвозвратно удалить эти материалы! Хотите продолжить?',
  'You cannot remove all Sites.' => 'Вы не можете удалить все сайты.',
  'You have not been granted <b>[_1]</b> access to the <b>[_2]</b> [_3]' => 'У вас нет прав <b>[_1]</b> для доступа к <b>[_2]</b> [_3]',
  'You must be an administrator to use this function.' => 'Для использования этой функции у вас должны быть права администратора.',
  'You must select an Element or check the &quot;Generic&quot; check box.' => 'Вы должны выбрать Элемент или поставить отметку &quot;Genérico&quot;.',
  'You must select an Element.' => 'Необходимо выбрать Элемент',
  'You must supply a unique name for this role!' => 'Этой роли необходимо присвоить униакльное имя!',
  'You must supply a value for ' => 'Необходимо задать значение ',
  '[_1] recipients changed.' => '[_1] адресатов изменены.',
  '[quant,$quant,Contributors] [_1] [quant,$quant,disassociated].' => '[_1] Автор(ов) дисассоциировано.',
  '[quant,_1,Alert] acknowledged.' => '[quant,_1,Alert] подтверждены.',
  '[quant,_1,Contributor] "[_2]" associated.' => '[quant,_1,Contributor] "[_2]" ассоциирован.',
  '[quant,_1,Template] deployed.' => '[quant,_1,Template] размещен.',
  '[quant,_1,media,media] published.' => '[quant,_1,media,media] опубликован',
  '[quant,_1,story,stories] published.' => '[quant,_1,story,stories] опубликован',
  'contains illegal characters!' => 'содержит недопустимые символы!',
  'Element must be associated with at least one site and one output channel.' => 'Элемент должен быть связан не менее, чем с одним Сайтом (site) и одним Каналом вывода (output channel).',
  'Permission to manage "[_1]" group membership denied' => 'Нет разрешения для управления членством в группе "[_1]"',
  'Permission to grant permission "[_1]" to group "[_2]" denied' => 'Нет разрешения для предоставления прав "[_1]" для группы "[_2]"',
  'This job has failed' => 'Эта задача завершилась аварийно',
  'The error message is available below.  No further execution attempts will be made on this job.  Please leave it in the queue until your administrator has seen the error message.' => 'Сообщение об ошибке помещено ниже. Дальнейших попыток продолжить выполнение данной задачи предпринято не будет. Оставьте ее в очереди до тех пор, пока ваш администратор не увидит сообщения об ошибке.',
  'First Published' => 'Впервые опубликовано',
  'You do not have permission to add "[_1]" objects' => 'У вас нет прав добавлять "[_1]" объектов',
  'Remaining' => 'Осталось',
  'Object Groups' => 'Группы объектов',
  '[_1] Site Categories' => '[_1] Категории сайта',
  'You do not have permission to override user "[_1]"' => 'У вас нет прав обходить пользователя "[_1]"',
   '_AUTO' => 1,
);


=begin comment

To translate:

  'Slug required for non-fixed (non-cover) story type.' => 'Slug required for non-fixed (non-cover) story type.',
  '[_1] Site [_2] Permissions' => '[_1] Site [_2] Permissions', # Site Category Permissions
  'The URI "[_1]" is not unique. Please change the cover date, output channels, slug, or categories as necessary to make the URIs unique.' => 'The URI "[_1]" is not unique. Please change the cover date, output channels, slug, or categories as necessary to make the URIs unique.'
  'Name "[_1]" is not a valid media name. The name must be of the form "type/subtype".' => 'Name "[_1]" is not a valid media name. The name must be of the form "type/subtype".',
  '[quant,_1,media,media] expired.' => '[quant,_1,media,media] expired.',
  '[quant,_1,story,stories] expired.' => '[quant,_1,story,stories] expired.',

=end comment

=cut

1;
__END__

=head1 AUTHOR

Sergey Samoilenko <Sergey@Samoilenko.ru>

=head1 SEE ALSO

L<Bric::Util::Language|Bric::Util::Language>

=cut
