/*
Copyright (C) 2003 Parallel Realities

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "info.h"

void doStatusBar()
{
	graphics.setFontSize(0);
	graphics.setFontColor(0xff, 0xff, 0xff, 0x00, 0x00, 0x00);

	char string[1024];

	graphics.blit(graphics.infoBar, 0, 0, graphics.screen, false);

	graphics.drawString(engine.translate("Health"), 50, 5, TXT_RIGHT, graphics.screen);

	for (int i = 0 ; i < MAX_HEALTH ; i++)
	{
		if (i < player.health)
			graphics.blit(graphics.getSprite("HealthBlock", true)->getCurrentFrame(), 60 + (i * 15), 7, graphics.screen, false);
		else
			graphics.blit(graphics.getSprite("HealthBlockEmpty", true)->getCurrentFrame(), 60 + (i * 15), 7, graphics.screen, false);
	}

	if (player.health <= 3)
		if (engine.getFrameLoop() < 30)
			for (int i = 0 ; i < player.health ; i++)
				graphics.blit(graphics.getSprite("WarningBlock", true)->getCurrentFrame(), 60 + (i * 15), 7, graphics.screen, false);

	if ((!game.hasAquaLung) && (!engine.cheatExtras))
	{
		graphics.drawString(engine.translate("Oxygen"), 305, 5, TXT_RIGHT, graphics.screen);

		for (int i = 0 ; i < 7 ; i++)
		{
			if (i < player.oxygen)
				graphics.blit(graphics.getSprite("OxygenBlock", true)->getCurrentFrame(), 315 + (i * 15), 7, graphics.screen, false);
			else
				graphics.blit(graphics.getSprite("OxygenBlockEmpty", true)->getCurrentFrame(), 315 + (i * 15), 7, graphics.screen, false);
		}

		if (player.oxygen <= 3)
			if (engine.getFrameLoop() < 30)
				for (int i = 0 ; i < player.oxygen ; i++)
					graphics.blit(graphics.getSprite("WarningBlock", true)->getCurrentFrame(), 315 + (i * 15), 7, graphics.screen, false);
	}
	else if ((game.hasJetPack) || (engine.cheatExtras))
	{
		graphics.drawString(engine.translate("Jetpack"), 260, 5, false, graphics.screen);

		for (int i = 0 ; i < 7 ; i++)
		{
			if (i < player.fuel)
				graphics.blit(graphics.getSprite("OxygenBlock", true)->getCurrentFrame(), 315 + (i * 15), 7, graphics.screen, false);
			else
				graphics.blit(graphics.getSprite("OxygenBlockEmpty", true)->getCurrentFrame(), 315 + (i * 15), 7, graphics.screen, false);
		}

		if ((player.fuel < 3) && (!(player.flags & ENT_FLIES)))
			if (engine.getFrameLoop() < 30)
				for (int i = 0 ; i < player.fuel ; i++)
					graphics.blit(graphics.getSprite("WarningBlock", true)->getCurrentFrame(), 315 + (i * 15), 7, graphics.screen, false);
	}

 	if (engine.messageTime > -1)
	{
		switch (engine.messageType)
		{
			case INFO_NORMAL:
				graphics.setFontColor(0xff, 0xff, 0xff, 0x00, 0x00, 0x00);
				break;
			case INFO_OBJECTIVE:
				graphics.setFontColor(0x00, 0xff, 0x00, 0x00, 0x00, 0x00);
				break;
			case INFO_HINT:
				graphics.setFontColor(0xff, 0xaa, 0x00, 0x00, 0x00, 0x00);
				break;
			case INFO_ACTIVATE:
				graphics.setFontColor(0x00, 0xff, 0xff, 0x00, 0x00, 0x00);
				break;
			case INFO_BAD:
				graphics.setFontColor(0xff, 0x00, 0x00, 0x00, 0x00, 0x00);
				break;
		}

		graphics.blit(graphics.infoBar, 0, 455, graphics.screen, false);

		graphics.drawString(engine.message, 320, 466, true, graphics.screen);
  		engine.messageTime--;
		if (engine.messageTime == -1)
			engine.messagePriority = -1;

		graphics.setFontColor(0xff, 0xff, 0xff, 0x00, 0x00, 0x00);
	}

	sprintf(string, "%s %s", engine.translate("Weapon:"), engine.translate(player.currentWeapon->name));
	graphics.drawString(string, 630, 5, TXT_RIGHT, graphics.screen);
}

void doPauseInfo()
{
	int col1, col2, y;

	col1 = 310;
	col2 = 330;
	y = 60;

	graphics.fade(128);

	char string[1024];
	strcpy(string, "");

	#if !USEPAK
	sprintf(string, "Position = %d:%d", (int)player.x, (int)player.y);
	graphics.drawString(string, 5, 25, false, graphics.screen);
	#endif

	graphics.drawString(engine.translate("*** PAUSED ***"), 320, y, TXT_CENTERED, graphics.screen);

	graphics.drawString(engine.translate("MIAs in Area"), col1, y += 30, TXT_RIGHT, graphics.screen);
	sprintf(string, "%d", map.totalMIAs - map.foundMIAs);
	graphics.drawString(string, col2, y, TXT_LEFT, graphics.screen);

	graphics.drawString(engine.translate("Enemies Defeated"), col1, y += 20, TXT_RIGHT, graphics.screen);
	sprintf(string, "%d", game.currentMissionEnemiesDefeated);
	graphics.drawString(string, col2, y, TXT_LEFT, graphics.screen);

	graphics.drawString(engine.translate("Items Collected"), col1, y += 20, TXT_RIGHT, graphics.screen);
	sprintf(string, "%d / %d", map.foundItems, map.totalItems);
	graphics.drawString(string, col2, y, TXT_LEFT, graphics.screen);

	graphics.drawString(engine.translate("Best Combo"), col1, y += 20, TXT_RIGHT, graphics.screen);
	sprintf(string, "%s", engine.translate("%d Hits"));
	sprintf(string, string, game.maxComboHits);
	graphics.drawString(string, col2, y, TXT_LEFT, graphics.screen);

	graphics.drawString(engine.translate("++ Inventory ++"), 320, y += 40, TXT_CENTERED, graphics.screen);
	showCarriedItems();

	// Do the objectives list
	Objective *objective = (Objective*)map.objectiveList.getHead();
	char message[100];

	y += 60;

	if (map.totalMIAs > 0)
	{
		graphics.setFontColor(0xff, 0xff, 0xff, 0x00, 0x00, 0x00);
		sprintf(message, "%s", engine.translate("Rescue %d MIAs"));
		sprintf(message, message, map.requiredMIAs);
		graphics.drawString(message, col1, y, TXT_RIGHT, graphics.screen);

		if (map.foundMIAs < map.requiredMIAs)
		{
			graphics.setFontColor(0xff, 0x00, 0x00, 0x00, 0x00, 0x00);
			sprintf(message, "%d / %d", map.foundMIAs, map.requiredMIAs);
			graphics.drawString(message, col2, y, TXT_LEFT, graphics.screen);
		}
		else
		{
			graphics.setFontColor(0x00, 0xff, 0x00, 0x00, 0x00, 0x00);
			graphics.drawString(engine.translate("Completed"), col2, y, TXT_LEFT, graphics.screen);
		}
	}

	while (objective->next != NULL)
	{
		objective = (Objective*)objective->next;

		y += 20;

		graphics.setFontColor(0xff, 0xff, 0xff, 0x00, 0x00, 0x00);
		graphics.drawString(objective->description, col1, y, TXT_RIGHT, graphics.screen);
		
		// this is a fake objective (for the 4th Ancient Tomb)
		if (objective->targetValue == -1)
		{
			graphics.setFontColor(0xff, 0x00, 0x00, 0x00, 0x00, 0x00);
			graphics.drawString(engine.translate("Incomplete"), col2, y, TXT_LEFT, graphics.screen);
		}
		else if (objective->currentValue < objective->targetValue)
		{
			graphics.setFontColor(0xff, 0x00, 0x00, 0x00, 0x00, 0x00);
			if (objective->targetValue == 1)
			{
				graphics.drawString(engine.translate("Incomplete"), col2, y, TXT_LEFT, graphics.screen);
			}
			else
			{
				sprintf(message, "%d / %d", objective->currentValue, objective->targetValue);
    			graphics.drawString(message, col2, y, TXT_LEFT, graphics.screen);
			}

			if (!objective->required)
			{
				graphics.setFontColor(0xff, 0xff, 0xff, 0x00, 0x00, 0x00);
				graphics.drawString(engine.translate("(optional)"), 450, y, TXT_LEFT, graphics.screen);
			}
		}
		else
		{
			graphics.setFontColor(0x00, 0xff, 0x00, 0x00, 0x00, 0x00);
			graphics.drawString(engine.translate("Completed"), col2, y, TXT_LEFT, graphics.screen);
		}
	}

	graphics.setFontColor(0xff, 0xff, 0xff, 0x00, 0x00, 0x00);

	y += 10;

	sprintf(string, "%s - %.2d:%.2d:%.2d", engine.translate("Mission Time"), game.currentMissionHours, game.currentMissionMinutes, game.currentMissionSeconds);
	graphics.drawString(string, 320, 430, TXT_CENTERED, graphics.screen);
}
