/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/csystem.c               */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Jan 20 08:45:23 1993                          */
/*    Last change :  Wed Nov 16 07:50:01 2005 (serrano)                */
/*    Copyright   :  2002-05 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    System interface                                                 */
/*=====================================================================*/
#include <time.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef _MINGW_VER
#  define _BGL_WIN32_VER
#  include <io.h>
#  include <winsock2.h>
#  define lstat stat
#else
#  ifdef _MSC_VER
#    define _BGL_WIN32_VER
#    include <io.h>
#    include <winsock2.h>
#    define lstat stat
#  else
#    include <unistd.h>
#    include <sys/socket.h>
#    include <netinet/in.h>
#    include <arpa/inet.h>
#    include <netdb.h>
#  endif
#endif
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    La table des handlers de signaux                                 */
/*---------------------------------------------------------------------*/
static obj_t handler[ 32 ];

/*---------------------------------------------------------------------*/
/*    Signal mutex                                                     */
/*---------------------------------------------------------------------*/
static obj_t signal_mutex = BUNSPEC;
DEFINE_STRING( signal_mutex_name, _1, "signal-mutex", 12 );

/*---------------------------------------------------------------------*/
/*    bgl_init_signal ...                                              */
/*---------------------------------------------------------------------*/
void
bgl_init_signal() {
   if( signal_mutex == BUNSPEC ) {
      signal_mutex = bgl_make_mutex( signal_mutex_name );
   }
}
          
/*---------------------------------------------------------------------*/
/*    get_handler ...                                                  */
/*---------------------------------------------------------------------*/
static obj_t
get_handler( int num ) {
   /* Re-install the signal handler because some OS (such as Solaris) */
   /* de-install it when the signal is raised.                        */
#if !HAVE_SIGACTION
   signal( num, (void (*)( int ))(get_handler) );
#endif   
   return ((obj_t (*)())PROCEDURE_ENTRY(handler[ num ]))( handler[ num ],
                                                          BINT( num ),
                                                          BEOA );
}
    
/*---------------------------------------------------------------------*/
/*    obj_t ...                                                        */
/*---------------------------------------------------------------------*/
obj_t
c_signal( int sig, obj_t thunk ) {
   bgl_mutex_lock( signal_mutex );
   
   if( PROCEDUREP( thunk ) ) {
      /* store the thunk in the signal table */
      handler[ sig ] = thunk;

#if HAVE_SIGACTION
      {
	 struct sigaction sigact;
	 
	 sigemptyset( &(sigact.sa_mask) );
	 sigact.sa_handler = (void (*)( int ))get_handler;
	 sigact.sa_flags = SA_RESTART;

	 sigaction( sig, &sigact, NULL );
      }
#else      
      signal( (int)sig, (void (*)( int ))get_handler );
#endif      
      
   } else {
      /* on met le thunk dans la table des handlers */
      handler[ sig ] = thunk;
      
      if( thunk == BTRUE ) {
	 signal( (int)sig, SIG_IGN );
      } else {
	 if( thunk == BFALSE ) {
	    signal( (int)sig, SIG_DFL );
	 }
      }
   }
   
   bgl_mutex_unlock( signal_mutex );
   
   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    get_signal_handler ...                                           */
/*---------------------------------------------------------------------*/
obj_t
get_signal_handler( int sig ) {
   return PROCEDUREP( handler[ sig ] ) ? handler[ sig ] : BFALSE;
}

/*---------------------------------------------------------------------*/
/*    c_date ...                                                       */
/*---------------------------------------------------------------------*/
char *
c_date() {
#if( defined( sony_news ) )
   long now;
#else      
   time_t now;
#endif

   now = time( 0L );
   return ctime( &now );
}
      
/*---------------------------------------------------------------------*/
/*    long                                                             */
/*    bgl_last_modification_time ...                                   */
/*---------------------------------------------------------------------*/
long
bgl_last_modification_time( char *file ) {
   struct stat _stat;

   if( lstat( file, &_stat ) )
      return -1;
   else
      return (long)(_stat.st_mtime);
}

/*---------------------------------------------------------------------*/
/*    long                                                             */
/*    bgl_file_size ...                                                */
/*---------------------------------------------------------------------*/
long
bgl_file_size( char *file ) {
   struct stat _stat;

   if( stat( file, &_stat ) )
      return -1;
   else
      return (long)_stat.st_size;
}

/*---------------------------------------------------------------------*/
/*    long                                                             */
/*    bgl_file_uid ...                                                 */
/*---------------------------------------------------------------------*/
long
bgl_file_uid( char *file ) {
   struct stat _stat;

   if( lstat( file, &_stat ) )
      return -1;
   else
      return _stat.st_uid;
}

/*---------------------------------------------------------------------*/
/*    long                                                             */
/*    bgl_file_gid ...                                                 */
/*---------------------------------------------------------------------*/
long
bgl_file_gid( char *file ) {
   struct stat _stat;

   if( lstat( file, &_stat ) )
      return -1;
   else
      return _stat.st_gid;
}

/*---------------------------------------------------------------------*/
/*    long                                                             */
/*    bgl_file_mode ...                                                */
/*---------------------------------------------------------------------*/
long
bgl_file_mode( char *file ) {
   struct stat _stat;

   if( stat( file, &_stat ) )
      return -1;
   else
      return _stat.st_mode;
}

/*---------------------------------------------------------------------*/
/*    int                                                              */
/*    bgl_chmod ...                                                    */
/*---------------------------------------------------------------------*/
int
bgl_chmod( char *file, int read, int write, int exec ) {
# ifndef _BGL_WIN32_VER
    return chmod( file,
                  (read ? S_IRUSR : 0) |
                  (write ? S_IWUSR : 0) |
                  (exec ? S_IXUSR : 0) );
# else
    return _chmod( file,
                   (read ? S_IREAD : 0) |
                   (write ? S_IWRITE : 0) );
# endif
}
		 
/*---------------------------------------------------------------------*/
/*    int                                                              */
/*    bgl_setenv ...                                                   */
/*---------------------------------------------------------------------*/
int
bgl_setenv( char *id, char *val ) {
   size_t l1 = strlen( id ), l2 = strlen( val );
   char *s = malloc( l1 + l2 + 2 );
   
   strcpy( s, id );
   s[ l1 ] = '=';
   strcpy( &s[ l1 + 1 ], val );

   return putenv( s );
}

/*---------------------------------------------------------------------*/
/*    char *                                                           */
/*    bgl_gethostname ...                                              */
/*---------------------------------------------------------------------*/
char *
bgl_gethostname() {
#define MAXHOSTNAME 1024   
   static char h[ MAXHOSTNAME ];
   struct hostent *hp;
   
   gethostname( h, MAXHOSTNAME );
   hp = gethostbyname( h );

   return hp ? hp->h_name : "localhost";
#undef MAXHOSTNAME
}
