;*=====================================================================*/
;*    serrano/prgm/project/bigloo/fthread/src2.6b/Llib/types.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Feb 13 15:49:42 2002                          */
;*    Last change :  Fri Jun 13 11:06:14 2003 (serrano)                */
;*    Copyright   :  2002-03 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The user types defined by the fair threads library               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __ft_types
   
   (export (abstract-class thread
	      ;; the actual native thread
	      (%builtin read-only)
	      ;; the timeout for idle threads
	      (%timeout::int (default 1))
	      ;; state
	      (%state::symbol (default 'unattached))
	      ;; a boolean set to #t iff the thread is suspended
	      (%is-suspend::bool (default #f))
	      ;; terminate entry point
	      (%terminate::procedure (default list))
	      ;; the value associated with the dead thread
	      (%result::obj (default #unspecified))
	      ;; end exception value
	      (%exc-result (default #unspecified))
	      ;; does the thread terminates because of an exception
	      (%exc-raised::bool (default #f))
	      ;; identifier
	      (%ident::int (default 0))
	      ;; a list of mutex owned by this thread
	      (%mutexes::pair-nil (default '()))
	      ;; list of exception handlers
	      %exc-handlers::pair-nil
	      ;; the signals that have registered this threads
	      (%signals::pair-nil (default '()))
	      ;; the signals that have registered this threads
	      (%awake-signal (default #f))
	      ;; the signal value that have registered this threads
	      (%awake-value (default #f))
	      ;; the name of the thread
	      (name read-only)
	      ;; local memory
	      (specific (default #unspecified))
	      ;; the scheduler the threads belongs to
	      (scheduler (default #f))
	      ;; finalizer to be invoked when the thread terminates
	      (cleanup (default #f)))
	   
	   (abstract-class scheduler::thread
	      ;; the environment
	      (env+::pair read-only))
	   
	   (abstract-class ftenv
	      (instant::long (default 0)))

	   (abstract-class mutex
	      ;; the name of the mutex
	      (name read-only)
	      ;; local memory
	      (specific (default #unspecified))
	      ;; unlock signal
	      (%unlock-signal read-only (default (cons 'mutex 'unlock))))

	   (abstract-class condition-variable
	      ;; the name of the mutex
	      (name read-only)
	      ;; local memory
	      (specific (default #unspecified)))

	   *thread-strict-order*))

;*---------------------------------------------------------------------*/
;*    *thread-strict-order*                                            */
;*---------------------------------------------------------------------*/
(define *thread-strict-order* #f)

