(module win32-helpers
  (use (win32-base))
  (export GetErrorMessage))

(define (GetErrorMessage error-code::LONG)
  (let* ((buffer-length 1024)
         (result (make-string buffer-length)))
    (if (zero? (FormatMessage FORMAT_MESSAGE_FROM_SYSTEM ; | FORMAT_MESSAGE_IGNORE_INSERTS !!!!!
                              (make-null-LPVOID)
                              error-code
                              0
                              result
                              buffer-length
                              (make-null-LPVOIDARRAY)))
        "[Could not retrieve error message]"
        result)))
