/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_STYLETREE_H
#define INCLUDED_STYLETREE_H


#include "libraries.h"
#include "style.h"
#include <gtk/gtk.h>


void styletree_load_stylesheet (GtkTreeStore * store, const ustring& stylesheet, GtkTreeView * treeview);
void styletree_load_recently_used_styles (GtkTreeStore * store, GtkTreeView * treeview);
void styletree_clear_recently_used_style (const ustring& style);
void styletree_clear_recently_used_styles ();
void styletree_use_style (GtkTreeStore * store, GtkWidget * treeview, const ustring& style);
void styletree_store_state (GtkTreeStore * store, GtkTreeIter *iter, bool expand);
bool styletree_get_state (const ustring& row);
void styletree_focus_string (GtkWidget * treeview, const ustring& string);
ustring styletree_get_focused_style (GtkWidget * treeview);
vector<ustring> styletree_get_focused_regular_styles (GtkWidget * treeview);
vector<ustring> styletree_get_focused_recently_used_styles (GtkWidget * treeview);
vector<ustring> styletree_get_focused_categories (GtkWidget * treeview);
ustring styletree_get_string_before_focus (GtkWidget * treeview);
void styletree_rename_stylesheet (GtkWidget * parent);
bool styletree_import_stylesheet (GtkWidget * parent);
void styletree_export_stylesheet (GtkWidget * parent);
void styletree_delete_categories (vector<ustring> categories);
bool styletree_expand_collapse (GtkWidget * treeview, bool expand);


#endif
