/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_EDITOR_NOTE_H
#define INCLUDED_EDITOR_NOTE_H


#include "libraries.h"
#include "usfm.h"
#include "xmlfo-utils.h"
#include "notecaller.h"
#include "editorobject.h"


class EditorNote
{
public:
  EditorNote (const Usfm& usfm);
  ~EditorNote ();
  void extract (ustring& line);
  vector <EditorObjectType> types;
  vector <size_t> positions;
  vector <size_t> lengths;
  vector <ustring> openers;
  vector <ustring> callers;
  vector <ustring> rendered_callers;
  vector <ustring> texts;
  vector <ustring> closers;
private:
  NoteNumberingRestartType footnote_numbering_restart;
  NoteNumberingRestartType endnote_numbering_restart;
  NoteNumberingRestartType xref_numbering_restart;
  ustring footnote_opener;
  ustring footnote_closer;
  ustring endnote_opener;
  ustring endnote_closer;
  ustring xref_opener;
  ustring xref_closer;
  vector<ustring> content_marker;
  set<ustring> footnote_markers;
  ustring standardparagraph_marker_open;
  ustring standardparagraph_marker_close;
  ustring extraparagraph_marker_open;
  ustring extraparagraph_marker_close;
  NoteCaller * footnotecaller;
  NoteCaller * endnotecaller;
  NoteCaller * xrefcaller;
  void extract_internal (ustring& line);
  size_t find_opener (ustring& line, size_t searchfrom, EditorObjectType& type, 
                      ustring& opener, ustring& closer, NoteCaller *& notecaller);
};


#endif
