/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "unixwrappers.h"
#include <libgen.h>
#include <glib.h>
#include "gwrappers.h"
#include "directories.h"
#include "utilities.h"
#include "shell.h"


bool unix_which (const ustring& path)
// Normally we would just use the exit code of the unix which command, but as
// this does not properly work on BSD systems, like Mac OS X, we use a wrapper
// around it. It results whether the "which <path>" command succeeded, that is, 
// whether <path> is a valid program.
// Expanded with "which" on Cygwin, which gives "Command not found" if the path
// does not exist.
{
  ustring outputfile = gw_build_filename (directories_get_temp(), "which.txt");
  ustring command;
  command = "which";
  command.append (shell_quote_space (path));
  command.append (">");
  command.append (shell_quote_space (outputfile));
  command.append ("2>&1");
  system (command.c_str());
  bool pass = false;
  ReadText rt (outputfile, true, true);
  if (rt.lines.size() > 0) {
    ustring not_there_string;
    not_there_string = "no " + path + " in";
    if (rt.lines[0].find (not_there_string) == string::npos) {
      pass = true;
    }
    // This test is for Cygwin.
    if (rt.lines[0].find ("Command not found") != string::npos) {
      pass = false;
    }
  }
  return pass;
}
