/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_NOTES_UTILS_H
#define INCLUDED_NOTES_UTILS_H


#include "libraries.h"
#include <gtk/gtk.h>
#include "configuration.h"


#define TABLE_NOTES "notes"


void notes_database_verify_create ();
ustring notes_database_filename ();
gint notes_database_get_unique_id ();
void notes_delete_one (int id);
void notes_sort (vector<gint32>& ids, const vector<ustring>& refs, const vector<int>& dates);
void notes_select (Configuration * configuration, vector<gint32>& ids, const ustring& currentreference);
void notes_display_one (GtkWidget *textview, GtkTextBuffer *textbuffer, gint32 id, Configuration * configuration);
void notes_get_references_from_editor (GtkTextBuffer *textbuffer, vector<ustring>& references, vector<ustring>& messages);
ustring notes_categories_filename ();
void notes_categories_check ();
void notes_categories_add_from_database (vector<ustring> & categories);
void notes_database_vacuum ();


#endif
