/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_INDEXSTORAGE_H
#define INCLUDED_INDEXSTORAGE_H


#include "libraries.h"
#include <glib.h>


enum IndexStorageType {isCheckBook, isIndexChapter, isStoreSignature};


class IndexStorage
{
public:
  // For isCheckBook
  IndexStorage (const ustring& project_in, const ustring& filename_in);
  // For isIndexChapter
  IndexStorage (const ustring& project_in, unsigned int book_in, unsigned int chapter_in, const vector <ustring>& lines_in);
  // For isStoreSignature
  IndexStorage (const ustring& project_in, const ustring& filename_in, const ustring& signature_in);
  virtual ~IndexStorage ();
  IndexStorageType type;
  ustring project;
  ustring filename;
  unsigned int book;
  unsigned int chapter;
  vector <ustring> lines;
  ustring signature;
private:
};


#endif
