/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_HIGHLIGHT_H
#define INCLUDED_HIGHLIGHT_H


#include "libraries.h"
#include <glib.h>
#include <gtk/gtk.h>
#include "scripture.h"
#include "configuration.h"
#include "session.h"


class Highlight
{
public:
  Highlight (GtkTextBuffer * buffer);
  ~Highlight ();
  void line_at_cursor (GtkTextTag * tag);
  void searchwords (GtkTextTag * tag, Session * session, const ustring& verse);
  GtkTextTag * get_tag (const ustring& tagname);
private:
  GtkTextBuffer * mybuffer;
  void searchwords_internal (unsigned int linenumber, unsigned int versenumber, 
                             const ustring & searchword, bool & cursor_set, bool & is_verse, 
                             bool casesensitive, bool globbing, bool matchbegin, bool matchend,
                             GtkTextTag * tag);
};



#endif
