/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_DIALOGCHECK_H
#define INCLUDED_DIALOGCHECK_H


#include <gtk/gtk.h>
#include "configuration.h"
#include "ustring.h"
#include "session.h"


enum CheckDialogType {cdtChaptersVerses, 
                      cdtMarkersCount, cdtMarkersValidate, cdtMarkersCompare,
                      cdtCharactersCount, cdtUnwantedPatterns,
                      cdtCapitalization, cdtRepetition, cdtUnwantedWords,
                      cdtMatchingPairs};


class CheckDialog
{
public:
  CheckDialog (CheckDialogType checkdialogtype, Configuration * configuration, Session * session);
  virtual ~CheckDialog ();
  virtual int run ();
protected:
  GtkWidget *checkdialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox1;
  GtkWidget *notebook1;
  GtkWidget *label8;
  GtkWidget *label6;
  GtkWidget *vbox2;
  GtkWidget *label9;
  GtkWidget *radiobutton_count_nosort;
  GtkWidget *radiobutton_count_sortusfm;
  GtkWidget *radiobutton_count_sortcount;
  GtkWidget *label7;
  GtkWidget *label11;
  GtkWidget *label10;
  GtkWidget *vbox3;
  GtkWidget *label13;
  GtkWidget *hseparator2;
  GtkWidget *hbox3;
  GtkWidget *label14;
  GtkWidget *label_compare_with;
  GtkWidget *button1;
  GtkWidget *alignment2;
  GtkWidget *hbox4;
  GtkWidget *image2;
  GtkWidget *label16;
  GtkWidget *hseparator1;
  GtkWidget *checkbutton_compare_all;
  GtkWidget *label17;
  GtkWidget *entry_compare_include_only;
  GtkWidget *hseparator3;
  GtkWidget *label18;
  GtkWidget *entry_compare_ignore;
  GtkWidget *hseparator4;
  GtkWidget *checkbutton_compare_ignore_verse_zero;
  GtkWidget *hseparator5;
  GtkWidget *label12;
  GtkWidget *vbox4;
  GtkWidget *label20;
  GtkWidget *radiobutton_count_chars_nosort;
  GtkWidget *radiobutton_count_chars_sortchar;
  GtkWidget *radiobutton_count_chars_sortcount;
  GtkWidget *label19;
  GtkWidget *vbox5;
  GtkWidget *label22;
  GtkWidget *hseparator6;
  GtkWidget *label23;
  GtkWidget *hbox5;
  GtkWidget *entry_capitalization_punctuation;
  GtkWidget *button_capitalization_punctuation;
  GtkWidget *alignment3;
  GtkWidget *hbox6;
  GtkWidget *image3;
  GtkWidget *label24;
  GtkWidget *hseparator7;
  GtkWidget *label25;
  GtkWidget *hbox7;
  GtkWidget *entry_capitalization_lowercase;
  GtkWidget *button_capitalization_lowercase;
  GtkWidget *alignment4;
  GtkWidget *hbox8;
  GtkWidget *image4;
  GtkWidget *label26;
  GtkWidget *hseparator8;
  GtkWidget *hbox9;
  GtkWidget *label27;
  GtkWidget *vbox6;
  GtkWidget *button_capitalization_abbreviations;
  GtkWidget *alignment5;
  GtkWidget *hbox10;
  GtkWidget *image5;
  GtkWidget *label28;
  GtkWidget *hseparator9;
  GtkWidget *hbox11;
  GtkWidget *vbox9;
  GtkWidget *label29;
  GtkWidget *checkbutton_capitalization_prefixes;
  GtkWidget *vbox7;
  GtkWidget *button_capitalization_prefixes;
  GtkWidget *alignment6;
  GtkWidget *hbox12;
  GtkWidget *image6;
  GtkWidget *label30;
  GtkWidget *hseparator10;
  GtkWidget *hbox13;
  GtkWidget *label31;
  GtkWidget *vbox8;
  GtkWidget *button_capitalization_suffixes;
  GtkWidget *alignment7;
  GtkWidget *hbox14;
  GtkWidget *image7;
  GtkWidget *label32;
  GtkWidget *hseparator11;
  GtkWidget *label21;
  GtkWidget *vbox10;
  GtkWidget *label38;
  GtkWidget *hseparator12;
  GtkWidget *checkbutton_repetition_case;
  GtkWidget *hseparator13;
  GtkWidget *table1;
  GtkWidget *button_repetition_show;
  GtkWidget *alignment9;
  GtkWidget *hbox17;
  GtkWidget *image9;
  GtkWidget *label39;
  GtkWidget *checkbutton_repetition_show;
  GtkWidget *checkbutton_repetition_ignore;
  GtkWidget *button_repetition_ignore;
  GtkWidget *alignment10;
  GtkWidget *hbox18;
  GtkWidget *image10;
  GtkWidget *label40;
  GtkWidget *label37;
  GtkWidget *vbox11;
  GtkWidget *label42;
  GtkWidget *label43;
  GtkWidget *hseparator14;
  GtkWidget *entry_matching_pairs_ignore;
  GtkWidget *label41;
  GtkWidget *vbox12;
  GtkWidget *label45;
  GtkWidget *hseparator15;
  GtkWidget *hbox19;
  GtkWidget *label46;
  GtkWidget *button_unwanted_patterns;
  GtkWidget *alignment11;
  GtkWidget *hbox20;
  GtkWidget *image11;
  GtkWidget *label47;
  GtkWidget *label44;
  GtkWidget *vbox13;
  GtkWidget *label49;
  GtkWidget *hseparator16;
  GtkWidget *hbox21;
  GtkWidget *label50;
  GtkWidget *button_unwanted_words;
  GtkWidget *alignment12;
  GtkWidget *hbox22;
  GtkWidget *image12;
  GtkWidget *label51;
  GtkWidget *label48;

  // Adding new tabs starts here.
  GtkWidget *hbox1;
  GtkWidget *button_books;
  GtkWidget *alignment1;
  GtkWidget *hbox2;
  GtkWidget *image1;
  GtkWidget *label5;
  GtkWidget *label_book;
  GtkWidget *notebook2;
  GtkWidget *hbox15;
  GtkWidget *button_area;
  GtkWidget *alignment8;
  GtkWidget *hbox16;
  GtkWidget *image8;
  GtkWidget *label36;
  GtkWidget *label_area;
  GtkWidget *label33;
  GtkWidget *empty_notebook_page;
  GtkWidget *label34;
  GtkWidget *dialog_action_area1;
  GtkWidget *cancelbutton;
  GtkWidget *okbutton;
private:
  Session * mysession;
  Configuration * myconfiguration;
  vector <ustring> selectable_books;
  static void on_okbutton_clicked (GtkButton *button, gpointer user_data);
  virtual void on_okbutton ();
  static void on_button_books_clicked (GtkButton *button, gpointer user_data);
  virtual void on_booksbutton ();
  static void on_button_area_clicked (GtkButton *button, gpointer user_data);
  virtual void on_area ();
  virtual void set_gui();
  static void on_checkbutton_compare_all_toggled (GtkToggleButton *togglebutton, gpointer user_data);
  virtual void on_checkbutton_compare_all ();
  static void on_button1_clicked (GtkButton *button, gpointer user_data);
  virtual void on_select_standard_project ();
  static void on_button_capitalization_punctuation_clicked (GtkButton *button, gpointer user_data);
  virtual void capitalization_punctuation_default ();
  static void on_button_capitalization_lowercase_clicked (GtkButton *button, gpointer user_data);
  virtual void capitalization_lowercase_default ();
  static void on_button_capitalization_abbreviations_clicked (GtkButton *button, gpointer user_data);
  virtual void capitalization_abbreviations_edit ();
  static void on_checkbutton_capitalization_prefixes_toggled (GtkToggleButton *togglebutton, gpointer user_data);
  virtual void on_checkbutton_prefixes ();
  static void on_button_capitalization_prefixes_clicked (GtkButton *button, gpointer user_data);
  virtual void button_capitalization_prefixes_edit ();
  static void on_button_capitalization_suffixes_clicked (GtkButton *button, gpointer user_data);
  virtual void capitalization_suffixes_edit ();
  static void on_checkbutton_repetition_show_toggled (GtkToggleButton *togglebutton, gpointer user_data);
  virtual void on_checkbutton_repetition_show ();
  static void on_button_repetition_show_clicked (GtkButton *button, gpointer user_data);
  virtual void on_button_repetition_show ();
  static void on_checkbutton_repetition_ignore_toggled (GtkToggleButton *togglebutton, gpointer user_data);
  virtual void on_checkbutton_repetition_ignore ();
  static void on_button_repetition_ignore_clicked (GtkButton *button, gpointer user_data);
  virtual void on_button_repetition_ignore ();
  static void on_button_unwanted_patterns_clicked (GtkButton *button, gpointer user_data);
  virtual void on_button_unwanted_patterns ();
  static void on_button_unwanted_words_clicked (GtkButton *button, gpointer user_data);
  virtual void on_button_unwanted_words ();
};


#endif
