/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "exception.h"
#include <gtk/gtk.h>
#include <config.h>


int main (int argc, char *argv[])
{
  // Unhandled exception handler.
  set_terminate (terminator);
  // Handler for unexpected exceptions.
  set_unexpected (my_unexpected);
  // We need thread support.
  g_thread_init (NULL);
  // Initialize GTK
  gtk_init (&argc, &argv);
  // Process command line arguments.
  for (int i = 1; i < argc; i++) {
    ustring argument (argv[i]);
    if (argument.length() > 2) {
      if (argument.substr (0, 2) == "--") {
        argument.erase (0, 2);
        if (argument == "version") {
          cout << PACKAGE_STRING << endl;
          return 0;
        }
        if (argument == "help") {
          cout << "To get help, run Bibledit without arguments, and open the online help." << endl;
          return 0;
        }
      }
    }
  }
  // Ready.
  return 0;
}
