/* Anti-Web HTTPD */
/* Hardcore Software */
/*
This software is Copyright (C) 2001-2004 By Hardcore Software and
others. The software is distributed under the terms of the GNU General
Public License. See the file 'COPYING' for more details.
*/


#include <stdio.h>
#include <netdb.h>
#include <sys/time.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <arpa/inet.h>
#include <time.h>
#include <unistd.h>
#include <string.h>



#include "aw3.h"



int checkmaxusers(int sd) {

  if (maxusers <= 0) return 1;

  if (numusers >= maxusers) {
    send505(sd, "Maximum user limit reached");
    // removeconnection() should be used normally
    close(sd);

    return 0;
  }

  return 1;
}


int pollsocket(int sd, long ustimeout) {

  fd_set rfds;
  struct timeval tv;

  tv.tv_sec = 0;
  tv.tv_usec = ustimeout;

  FD_ZERO(&rfds);
  FD_SET(sd, &rfds);

  select(FD_SETSIZE, &rfds, NULL, NULL, (ustimeout >= 0) ? &tv : NULL);

  return FD_ISSET(sd, &rfds);

}



#ifdef HAVE_IPV6

void handlenewconnection(int listenfd) {

  struct sockaddr_in6 their_addr;
  int tp = sizeof(their_addr);
  int connfd;
  char ipbuf[100];

  connfd = accept(listenfd, (struct sockaddr *)&their_addr, &tp);

  if (connfd == -1) return;

  if (tp == sizeof(struct sockaddr_in6)) {
    inet_ntop(AF_INET6, &their_addr.sin6_addr, ipbuf, sizeof(ipbuf));
  } else if (tp == sizeof(struct sockaddr_in)) {
    inet_ntop(AF_INET, &(((struct sockaddr_in *)&their_addr)->sin_addr),
              ipbuf, sizeof(ipbuf));
  } else {
    *ipbuf = '\0';
  }

  if (checkmaxusers(connfd)) addconnection(connfd, ipbuf);

  return;

}

#else

void handlenewconnection(int listenfd) {

  struct sockaddr_in their_addr;
  int tp = sizeof(struct sockaddr_in);
  int connfd;
  char ipbuf[100];

  connfd = accept(listenfd, (struct sockaddr *)&their_addr, &tp);

  if (connfd == -1) return;

  if (checkmaxusers(connfd))
    addconnection(connfd, inet_ntoa(their_addr.sin_addr));

  return;
}

#endif




int openlistener(int port) {

  int tp=0,sd;
  struct sockaddr_in my_addr;

  if ((sd = socket(AF_INET, SOCK_STREAM, 0)) == -1) return -1;

  /*
   * This excellent bugfix added by Fabrice Marie to Anti-Web 2.something
   */
  setsockopt(sd, SOL_SOCKET, SO_REUSEADDR, &tp, sizeof(tp));
 
  my_addr.sin_family = AF_INET;         // host byte order
  my_addr.sin_port = htons(port);       // short, network byte order
  my_addr.sin_addr.s_addr = INADDR_ANY; // automatically fill with my IP

  memset(&(my_addr.sin_zero), 0, 8);    // zero the rest of the struct

  if (bind(sd, (struct sockaddr *)&my_addr, sizeof(struct sockaddr)) == -1) {
    close(sd);
    return -1;
  }

  if (listen(sd, BACKLOG) == -1) {
    close(sd);
    return -1;
  }

  return sd;
}



#ifdef HAVE_IPV6

int openlistener6(int port) {

  int sd,tp;
  struct sockaddr_in6 my_addr;

  if ((sd = socket(AF_INET6, SOCK_STREAM, 0)) == -1) {
    return -1;
  }

  if (setsockopt(sd, SOL_SOCKET, SO_REUSEADDR, &tp, sizeof(tp)) == -1) {
  }

  memset(&my_addr, 0, sizeof(my_addr));
  my_addr.sin6_family = AF_INET6;
  my_addr.sin6_port = htons(port);

  if (bind(sd, (struct sockaddr *)&my_addr, sizeof(my_addr)) == -1) {
    return -1;
  }

  if (listen(sd, BACKLOG) == -1) {
    return -1;
  }

  return sd;

}

#endif
