/* Anti-Web HTTPD */
/* Hardcore Software */
/*
This software is Copyright (C) 2001-2004 By Hardcore Software and
others. The software is distributed under the terms of the GNU General
Public License. See the file 'COPYING' for more details.
*/


#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>

#include "aw3.h"


void addindex(char *tp) {

  struct indexstruct *ex;

  ex = (struct indexstruct *) malloc(sizeof(struct indexstruct));
  if (ex == NULL) {
    fprintf(stderr, "Serious memory error...\n");
    exit(0);
  }

  ex->name = strdup(tp);
  if (ex->name == NULL) {
    fprintf(stderr, "Serious memory error...\n");
    exit(0);
  }

  ex->next = indexlist;
  indexlist = ex;

  return;

}



// Returns 0 if no index was found and doesn't modify cn->actualfile
// Returns 1 if an index was found and puts the index in cn->actualfile
//              and puts its stat info into stp
int procindex(struct connstruct *cn, struct stat *stp) {
  char tbuf[MAXREQUESTLENGTH];
  struct indexstruct *tp;

  tp = indexlist;

  while(tp != NULL) {
    snprintf(tbuf, sizeof(tbuf), "%s%s", cn->actualfile, tp->name);

    if (stat(tbuf, stp) != -1) {
      strncpy(cn->actualfile, tbuf, MAXREQUESTLENGTH);
      return 1;
    }

    tp = tp->next;
  }

  return 0;

}
