/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef GTKGUI_FILEOPS_H_
#define GTKGUI_FILEOPS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

class FileVersion;

namespace GtkGUI
{

namespace FileOps
{

/**
 * \brief Reads a file into std::string.
 *
 * Optionally reads file modification time into \a version.\n
 * Optionally reports errors through OperationLog (on by default).
 * \return true on success, false on failure.
 */
bool readFile(std::string const& file_path, std::string& target,
	FileVersion* version = 0, bool log_errors = true);

/**
 * \brief Writes std::string to a file.
 *
 * Optionally reads file modification time (after writing) into \a version.\n
 * Optionally reports errors through OperationLog (on by default).
 * \return true on success, false on failure.
 */
bool writeFile(std::string const& file_path, std::string const& data,
	FileVersion* version = 0, bool log_errors = true);

/**
 * \brief Renames a file without creating directories.
 *
 * Optionally reports errors through OperationLog (on by default).
 * \return true on success, false on failure.
 */
bool renameFile(std::string const& from_path,
	std::string const& to_path, bool log_errors = true);

/**
 * \brief Deletes a file (not a directory).
 *
 * Optionally reports errors through OperationLog (on by default).
 * \return true if the file was deleted or didn't exist, false otherwise.
 */
bool deleteFile(std::string const& file_path, bool log_errors = true);

/**
 * \brief Reads file modification time.
 *
 * In case of a failure, FileVersion::undefined() is returned.
 */
FileVersion readFileVersion(std::string const& file_path);

/**
 * \brief Creates a directory.
 *
 * Optionally reports errors through OperationLog (on by default).
 * \return true if the directory was created or already existed, false otheriwise.
 */
bool createDir(std::string const& dir_path, bool log_errors = true);

} // namespace FileOps

} // namespace GtkGUI

#endif
