/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef REQUESTCACHECONTROL_H_
#define REQUESTCACHECONTROL_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class HttpRequestMetadata;
class HttpHeader;
class BString;

class RequestCacheControl
{
public:
	int max_age;
	int max_stale;
	int min_fresh;
	bool max_age_set : 1;
	bool max_stale_set : 1;
	bool max_stale_has_value : 1;
	bool min_fresh_set : 1;
	bool no_cache : 1;
	bool no_store : 1;
	bool no_transform : 1;
	bool only_if_cached : 1;
	
	RequestCacheControl();
	
	RequestCacheControl(HttpRequestMetadata const& request);
private:
	void processPragma(HttpHeader const* pragma_hdr);
	
	void processCacheControl(HttpHeader const* cc_hdr);
	
	static int parseInt(BString const& val);
};

#endif
