/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef GZIPDECOMPRESSOR_H_
#define GZIPDECOMPRESSOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "types.h"
#include "AbstractDecompressor.h"
#include "NonCopyable.h"
#include "SplittableBuffer.h"
#include <zlib.h>
#include <stddef.h>
#include <limits>

class GzipDecompressor : public AbstractDecompressor
{
	DECLARE_NON_COPYABLE(GzipDecompressor)
public:
	GzipDecompressor();
	
	/**
	 * \brief Allows uncompressed data as input.
	 *
	 * The uncompressed data will be passed through unmodified.
	 * This method must be called just after construction or
	 * reset().
	 */
	void allowUncompressed() { m_allowUncompressed = true; }
	
	virtual ~GzipDecompressor();
	
	virtual void reset();
	
	virtual bool isError() const;
	
	virtual void consume(SplittableBuffer& data, bool eof);
	
	virtual size_t retrieveOutput(SplittableBuffer& buf,
		size_t limit = std::numeric_limits<size_t>::max());
private:
	enum State {
		STATE_HEAD,
		STATE_FEXTRA,
		STATE_FEXTRA_1,
		STATE_FEXTRA_REST,
		STATE_FNAME,
		STATE_FCOMMENT,
		STATE_FHCRC,
		STATE_FHCRC_1,
		STATE_DATA,
		STATE_CRC32_ISIZE,
		STATE_UNCOMPRESSED
	};
	
	enum { MAX_OUTBUF_SIZE = 16384 };
	
	bool isErrorAtEOF(bool is_limit_reached) const;
	
	void initStream();
	
	bool loadBytes(uint8_t* where, size_t num, uint8_t const*& begin, uint8_t const* end);
	
	bool processHeader();
	
	size_t passthrough(SplittableBuffer& out, size_t const limit);
	
	SplittableBuffer m_bufferedInput;
	State m_state;
	bool m_isEOF;
	bool m_isError;
	bool m_isFirstDataSet;
	bool m_allowUncompressed;
	size_t m_stateOffset;
	uint8_t m_header[10];
	uint8_t m_footer[8];
	uint16_t m_hCRC;
	uint8_t m_flags;
	uint32_t m_headCRC32;
	uint32_t m_dataCRC32;
	uint32_t m_dataLength;
	z_stream m_strm;
};

#endif
