import os
import sys
import shutil

def copy_text_file(source, target):
	fin = open(source, "r")
	fout = open(target, "w")
	line = fin.readline()
	while line:
		fout.write(line)
		line = fin.readline()
	fin.close()
	fout.close()

os.system('scons findnsis.exe')

nsisdir = 'NSIS'
if not os.access(nsisdir, os.F_OK):
	nsisdir = os.popen('findnsis.exe').read().strip()
	if nsisdir == '':
		print """
Could not find the NSIS installation directory.
If you don't have NSIS, download it from http://nsis.sf.net
If you have it installed but it's still not detected,
copy the whole NSIS directory here (that will be win32inst\NSIS).
"""
		sys.exit(1)

os.system('scons NSISDIR="'+nsisdir+'"')

shutil.rmtree('temp', True)
os.mkdir('temp')
shutil.copyfile('../../main/gui/win32/bfilter.exe', 'temp/bfilter.exe')
shutil.copyfile('ProxySettings.dll', 'temp/ProxySettings.dll')
shutil.copyfile('UnWarn.dll', 'temp/UnWarn.dll')
shutil.copytree('../../doc', 'temp/doc')
shutil.rmtree('temp/doc/CVS', True)
shutil.rmtree('temp/doc/.svn', True)
shutil.copytree('../../main/gui/win32/resources/external', 'temp/resources')
shutil.copyfile('../../main/gui/gtk/pics/logo.png', 'temp/resources/logo.png')
shutil.rmtree('temp/resources/CVS', True)
shutil.rmtree('temp/resources/.svn', True)
shutil.copytree('../../conf/filters', 'temp/filters')
shutil.rmtree('temp/filters/CVS', True)
shutil.rmtree('temp/filters/.svn', True)
copy_text_file('bfilter.nsi', 'temp/bfilter.nsi')
copy_text_file('lastpage.ini', 'temp/lastpage.ini')
copy_text_file('../../COPYING', 'temp/License.txt')
copy_text_file('../../conf/config.default', 'temp/config.default')
copy_text_file('../../conf/urls', 'temp/urls')
copy_text_file('../../conf/urls.local', 'temp/urls.local')

version = open('../../VERSION', 'r').read().strip()

win9x_support = os.spawnl(
	os.P_WAIT, 'temp/bfilter.exe', '--have-win9x-support');

os.system('"'+nsisdir+'/makensis" /V3 /DVERSION='+version+
	' /DWIN9X_SUPPORT='+str(win9x_support)+' temp/bfilter.nsi')

installer = 'bfilter-'+version+'-install.exe'
if win9x_support:
	installer_newname = 'bfilter-'+version+'-win9x-install.exe'
else:
	installer_newname = installer

shutil.copy('temp/'+installer, './'+installer_newname)
shutil.rmtree('temp', True)