/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2007  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef APPLICATION_H_
#define APPLICATION_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "IntrusivePtr.h"
#include "InterthreadCommandQueue.h"
#include "NetworkActivityHandler.h"
#include "FilterJsLogHandler.h"
#include "RequestLogHandler.h"
#include "types.h"
#include <wx/string.h>
#include <wx/app.h>
#include <wx/filename.h>
#include <memory>

class Config;
class FileVersion;
class wxIdleEvent;
class ACE_FILE_IO;

namespace wxGUI
{

class ConfigFile;
class ForwardingConfigFile;
class UrlsFile;
class ContentFilters;
class TrayMenu;
class TrayIcon;

class Application :
	public wxApp,
	private InterthreadCommandQueue::Notifier
{
public:
	Application();
	
	~Application();
	
	static Application* instance();
	
	RequestLogHandler& getRequestLogHandler() { return m_requestLogHandler; }

	virtual bool OnInit();
	
	virtual int OnExit();

	void showTrayMenu();
	
	void showAboutDialog();

	void showLogDialog();
	
	void showRequestLogWindow();
	
	void showBasicConfigDialog();
	
	void showAdvancedConfigWindow();
	
	void showFilterConfigWindow();
	
	void showForwardingConfigWindow();
	
	void requestAppExit();
	
	wxFileName getConfigFileName() const;
	
	wxFileName getConfigDefaultFileName() const;
	
	wxFileName getStandardUrlPatternsFileName() const;
	
	wxFileName getLocalUrlPatternsFileName() const;
	
	wxFileName getFiltersDir() const;
	
	wxFileName getResourcesDir() const;

	wxGUI::ConfigFile& configFile() { return *m_ptrConfigFile; }
	
	wxGUI::ForwardingConfigFile& forwardingConfigFile() { return *m_ptrFwdConfigFile; }
	
	wxGUI::UrlsFile& urlsFile() { return *m_ptrUrlsFile; }
	
	wxGUI::UrlsFile& urlsLocalFile() { return *m_ptrUrlsLocalFile; }
	
	wxGUI::ContentFilters& contentFilters() { return *m_ptrContentFilters; }
	
	void handleNetworkActivity();
private:
	struct ContentFilterFnameComparator;
	
	enum { COMMAND_QUEUE_CAPACITY = 32 };
	
	virtual void notifyCommandsPending();
	
	virtual void notifyQueueEmpty();
	
	void onIdle(wxIdleEvent& evt);
	
	void processCommands();
	
	bool m_isExiting;
	int m_commandNestLevel;
	volatile int32_t m_havePendingCommands;
	InterthreadCommandQueue m_commandQueue;
	NetworkActivityHandler m_networkActivityHandler;
	FilterJsLogHandler m_filterJsLogHandler;
	RequestLogHandler m_requestLogHandler;
	wxFileName m_appDir;
	wxFileName m_confDir;
	std::auto_ptr<ConfigFile> m_ptrConfigFile;
	std::auto_ptr<ForwardingConfigFile> m_ptrFwdConfigFile;
	std::auto_ptr<UrlsFile> m_ptrUrlsFile;
	std::auto_ptr<UrlsFile> m_ptrUrlsLocalFile;
	std::auto_ptr<ContentFilters> m_ptrContentFilters;
	std::auto_ptr<TrayIcon> m_ptrTrayIcon;
	std::auto_ptr<TrayMenu> m_ptrTrayMenu;
	
	DECLARE_EVENT_TABLE()
};

DECLARE_APP(Application)

} // namespace wxGUI

#endif
