/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef FILTERGLOBALFLAGS_H_
#define FILTERGLOBALFLAGS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

class FilterGlobalFlags
{
public:
	enum Flag {
		HTML          = 1 << 0,
		XHTML         = 1 << 1,
		HTML_OR_XHTML = 1 << 2
	};
	
	FilterGlobalFlags() : m_flags(0) {}
	
	// Member-wise copying is OK.
	
	void set(Flag flag) { m_flags |= flag; }
	
	void clear(Flag flag) { m_flags &= ~flag; }
	
	bool isSet(Flag flag) const { return m_flags & flag; }
	
	bool isSet(std::string const& flag) const;
private:
	struct Item;
	
	static Item const* findItem(std::string const& name);
	
	static Item const m_sItems[];
	int m_flags;
};

#endif
