#!/bin/sh

# Note that the package must be named exactly BFilter.pkg, because before
# Tiger, packages were identified by their name. So, if you embed version
# info to a pkg file, it will think you are installing a new package, not
# upgrading an existing one.

if [ ! -d DmgDir/BFilter.pkg ]; then
  echo "DmgDir/BFilter.pkg doesn't exist."
  echo "Run prepare.sh and follow its instructions."
fi

read VERSION < ../../VERSION

rm -rf temp
rm -f "BFilter-${VERSION}.dmg"
mkdir temp
cp -R DmgDir "temp/BFilter ${VERSION}"
cp ../../build/Release/Uninstaller "temp/BFilter ${VERSION}/"
hdiutil create -srcfolder "temp/BFilter ${VERSION}" "BFilter-${VERSION}.dmg"
chmod -R 755 temp
rm -rf temp
