/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef TRAYICON_H_
#define TRAYICON_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AnimatedTrayIcon.h"
#include <sigc++/sigc++.h>
#include <glibmm/refptr.h>
#include <gdkmm/pixbuf.h>

struct CompiledImage;

class TrayIcon : public AnimatedTrayIcon, public sigc::trackable
{
public:
	TrayIcon();
	
	virtual ~TrayIcon();
	
	void displayNetworkActivity();
private:
	void loadIcons();
	
	void initFrame(Frame& frame, CompiledImage const& image, int delay);
	
	void setNormalIcon();
	
	void setInoperativeIcon();
	
	void setWarningIcon();
	
	void setNormalAnimation();
	
	void setWarningAnimation();
	
	void onClose();
	
	void onMouseClick(GdkEventButton* evt);
	
	bool onTimer();
	
	void onAcceptingConnections(bool accepting);
	
	void onUnseenWarnings(bool warnings);
	
	void onStateChange();
	
	sigc::connection m_timerConnection;
	Frame m_normalFrames[7];
	Frame m_warningFrames[7];
	Glib::RefPtr<Gdk::Pixbuf> m_ptrInoperativeIcon;
};

#endif
