/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ProxyDescriptor.h"
#include <algorithm>

using namespace std;

ProxyDescriptor::ProxyDescriptor()
:	m_type(INVALID),
	m_addr(string(), -1)
{
}

ProxyDescriptor::ProxyDescriptor(ProxyDescriptor const& other)
:	m_type(other.m_type),
	m_configProblem(other.m_configProblem),
	m_addr(other.m_addr),
	m_username(other.m_username),
	m_password(other.m_password)
{
}

ProxyDescriptor::~ProxyDescriptor()
{
}

ProxyDescriptor&
ProxyDescriptor::operator=(ProxyDescriptor const& other)
{
	ProxyDescriptor(other).swap(*this);
	return *this;
}

void
ProxyDescriptor::swap(ProxyDescriptor& other)
{
	std::swap(m_type, other.m_type);
	m_configProblem.swap(other.m_configProblem);
	m_addr.swap(other.m_addr);
	m_username.swap(other.m_username);
	m_password.swap(other.m_password);
}

void
ProxyDescriptor::setInvalid(std::string const& config_problem)
{
	ProxyDescriptor proxy;
	proxy.m_configProblem = config_problem;
	proxy.swap(*this);
}
