/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "HttpHeadersCollection.h"
#include "HttpHeader.h"
#include <map>

void
HttpHeadersCollection::addHeader(BString const& name, BString const& value)
{
	HeaderMap::iterator it = m_headers.find(name);
	if (it != m_headers.end()) {
		it->second.appendValue(value);
	} else {
		m_headers.insert(HeaderMap::value_type(name, HttpHeader(name, value)));
	}
}

void
HttpHeadersCollection::setHeader(HttpHeader const& header)
{
	HeaderMap::iterator it = m_headers.find(header.getName());
	if (it != m_headers.end()) {
		it->second = header;
	} else {
		m_headers.insert(HeaderMap::value_type(header.getName(), header));
	}
}

void
HttpHeadersCollection::setHeader(BString const& name, BString const& value)
{
	setHeader(HttpHeader(name, value));
}

HttpHeader
HttpHeadersCollection::getHeader(BString const& name) const
{
	HeaderMap::const_iterator it = m_headers.find(name);
	if (it == m_headers.end()) {
		return HttpHeader(BString(), BString());
	}
	return it->second;
}

HttpHeader*
HttpHeadersCollection::getHeaderPtr(BString const& name)
{
	HeaderMap::iterator it = m_headers.find(name);
	if (it == m_headers.end()) {
		return 0;
	}
	return &it->second;
}

HttpHeader const*
HttpHeadersCollection::getHeaderPtr(BString const& name) const
{
	HeaderMap::const_iterator it = m_headers.find(name);
	if (it == m_headers.end()) {
		return 0;
	}
	return &it->second;
}

void
HttpHeadersCollection::removeHeader(BString const& name)
{
	m_headers.erase(name);
}

bool
HttpHeadersCollection::hasHeader(BString const& name) const
{
	return (m_headers.find(name) != m_headers.end());
}

void
HttpHeadersCollection::toStream(std::ostream& strm) const
{
	HeaderMap::const_iterator it = m_headers.begin();
	HeaderMap::const_iterator const end = m_headers.end();
	for (; it != end; ++it) {
		strm << it->second;
	}
}
