/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CONTENTFILTERS_H_
#define CONTENTFILTERS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "IntrusivePtr.h"
#include <deque>
#include <string>

class RegexFilterDescriptor;

class ContentFilters
{
public:
	typedef IntrusivePtr<RegexFilterDescriptor> FilterPtr;
	typedef std::deque<FilterPtr> FilterList;
	
	ContentFilters();
	
	ContentFilters(ContentFilters const& other);
	
	~ContentFilters();
	
	ContentFilters& operator=(ContentFilters const& other);
	
	FilterList& filters() { return m_filters; }
	
	FilterList const& filters() const { return m_filters; }
	
	FilterList::iterator find(FilterPtr const& filter);
	
	bool hasValidFilters() const;
	
	void sortByOrder();
	
	void swap(ContentFilters& other);
private:
	class OrderComparator;
	
	FilterList m_filters;
};

inline void swap(ContentFilters& o1, ContentFilters& o2)
{
	o1.swap(o2);
}

#endif
