/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CONF_H_
#define CONF_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "SymbolicInetAddr.h"
#include "ProxyDescriptor.h"
#include <ace/config-lite.h>
#include <boost/regex_fwd.hpp>
#include <string>
#include <list>
#include <memory>
#include <stddef.h>

class Color;

class Config
{
public:
	enum ReportClientIP { REPORT_IP_ON, REPORT_IP_OFF, REPORT_IP_FIXED };
	
	Config();
	
	Config(Config const& other);
	
	~Config();
	
	Config& operator=(Config const& other);
	
	std::list<SymbolicInetAddr> getListenAddresses() const { return m_listenAddrs; }
	
	void setListenAddresses(std::list<SymbolicInetAddr> const& addrs) { m_listenAddrs = addrs; }
	
	ProxyDescriptor getNextHopProxy() const { return m_nextHopProxy; }
	
	void setNextHopProxy(ProxyDescriptor const& proxy);
	
	bool isNextHopProxyEnabled() const { return m_isNextHopProxyEnabled; }
	
	void setNextHopProxyEnabled(bool val) { m_isNextHopProxyEnabled = val; }
	
	std::list<std::string> getProxySkipList() const { return m_proxySkipList; }
	
	void setProxySkipList(std::list<std::string> const& list);
	
	std::auto_ptr<ProxyDescriptor> getProxyFor(std::string const& host) const;
	
	bool isClientCompressionEnabled() const { return m_isClientCompressionEnabled; }
	
	void setClientCompressionEnabled(bool val) { m_isClientCompressionEnabled = val; }
	
	std::auto_ptr<Color> getBorderColor() const;
	
	void setBorderColor(std::auto_ptr<Color> color);
	
	bool isTrayAnimationEnabled() const { return m_isTrayAnimationEnabled; }

	void setTrayAnimationEnabled(bool val) { m_isTrayAnimationEnabled = val; }
	
	size_t getMaxScriptNestLevel() const { return m_maxScriptNestLevel; }
	
	void setMaxScriptNestLevel(size_t val) { m_maxScriptNestLevel = val; }
	
	size_t getMaxScriptFetchSize() const { return m_maxScriptFetchSize; }
	
	void setMaxScriptFetchSize(size_t val) { m_maxScriptFetchSize = val; }
	
	size_t getMaxScriptEvalSize() const { return m_maxScriptEvalSize; }
	
	void setMaxScriptEvalSize(size_t val) { m_maxScriptEvalSize = val; }
	
	size_t getSaveTrafficThreshold() const { return m_saveTrafficThreshold; }
	
	void setSaveTrafficThreshold(size_t val) { m_saveTrafficThreshold = val; }
	
	ReportClientIP getReportClientIP() const { return m_reportClientIP; }
	
	std::string const& getFixedClientIP() const { return m_fixedClientIP; }
	
	void setReportClientIP(ReportClientIP report, std::string const& fixed = std::string()) {
		m_reportClientIP = report;
		m_fixedClientIP = fixed;
	}
private:
	std::auto_ptr<boost::regex> getProxySkipRegex() const;
	
	void updateProxySkipRegex();
	
	static std::string regQuote(std::string const& str);
		
	std::list<SymbolicInetAddr> m_listenAddrs;
	ProxyDescriptor m_nextHopProxy;
	bool m_isNextHopProxyEnabled;
	bool m_isClientCompressionEnabled;
	bool m_isTrayAnimationEnabled;
	std::list<std::string> m_proxySkipList;
	std::auto_ptr<boost::regex> m_ptrProxySkipRegex;
	std::auto_ptr<Color> m_ptrBorderColor;
	size_t m_maxScriptNestLevel;
	size_t m_maxScriptFetchSize;
	size_t m_maxScriptEvalSize;
	size_t m_saveTrafficThreshold;
	ReportClientIP m_reportClientIP;
	std::string m_fixedClientIP;
};

#endif
