/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SERVERTIMEOUTS_H_
#define SERVERTIMEOUTS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class ServerTimeouts
{
public:
	ServerTimeouts(long read_to, long write_to, long connect_to);
	
	long getReadTimeout() const { return m_readTimeout; }
	
	void setReadTimeout(long timeout) { m_readTimeout = timeout; }
	
	long getWriteTimeout() const { return m_writeTimeout; }
	
	void setWriteTimeout(long timeout) { m_writeTimeout = timeout; }
	
	long getConnectTimeout() const { return m_connectTimeout; }
	
	void setConnectTimeout(long timeout) { m_connectTimeout = timeout; }
private:
	long m_readTimeout;
	long m_writeTimeout;
	long m_connectTimeout;
};


inline
ServerTimeouts::ServerTimeouts(long read_to, long write_to, long connect_to)
:	m_readTimeout(read_to),
	m_writeTimeout(write_to),
	m_connectTimeout(connect_to)
{
}

#endif
