/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ImageHeuristicScore.h"
#include "BString.h"
#include "URI.h"

using namespace std;

#if 0
#include "Debug.h"
#define PRINT_SCORE(what) DEBUGLOG(what)
#else
#define PRINT_SCORE(what)
#endif

ImageHeuristicScore::ImageHeuristicScore(int score)
:	m_score(score),
	m_sizeScore(0)
{
	PRINT_SCORE("-----------------------------");
}

int
ImageHeuristicScore::getNumericScore() const
{
	return m_score;
}

int
ImageHeuristicScore::getNumericSizeScore() const
{
	return m_sizeScore;
}

void
ImageHeuristicScore::processSize(int width, int height)
{
	if (m_sizeScore) {
		m_score -= m_sizeScore;
		m_sizeScore = 0;
	}
	m_sizeScore = getSizeScore(width, height);
	m_score += m_sizeScore;
	PRINT_SCORE("SIZE SCORE " << m_sizeScore);
}

void
ImageHeuristicScore::processUrls(URI const& base,
	URI const& img_abs, URI const& img_rel,
	URI const& link_abs, URI const& link_rel)
{
	int score = 0;
	UrlRelationship link_img_rship = getUrlRelationship(link_abs, img_abs);
	
	PRINT_SCORE("LINK URL: " << link_abs);
	PRINT_SCORE("LINK MODIFIER: " << getHintModifier(link_abs));
	score += getHintModifier(link_abs);
	UrlRelationship const link_rship = getUrlRelationship(link_rel, base);
	if (link_rship == URLS_UNRELATED) {
		PRINT_SCORE("+35 link UNRELATED to page");
		score += 35;
		if (link_img_rship == URLS_UNRELATED) {
			PRINT_SCORE("+15 link UNRELATED to img");
			score += 15;
		}
	} else if (link_rship == URLS_SAME_HOST) {
		PRINT_SCORE("-15 link SAME HOST as page");
		score -= 15;
	}
	UrlStatus const link_status = getUrlStatus(link_rel);
	if (link_status == URL_INNOCENT) {
		PRINT_SCORE("-15 link INNOCENT");
		score -= 15;
	} else if (link_status == URL_SUSPICIOUS) {
		PRINT_SCORE("+35 link SUSPICIOUS");
		score += 35;
	}
	
	PRINT_SCORE("IMAGE URL: " << img_abs);
	PRINT_SCORE("IMAGE MODIFIER: " << getHintModifier(img_abs));
	score += getHintModifier(img_abs);
	UrlRelationship const img_rship = getUrlRelationship(img_rel, base);
	UrlStatus const img_status = getUrlStatus(img_rel);
	if (img_rship == URLS_UNRELATED) {
		PRINT_SCORE("+35 img UNRELATED to page");
		score += 35;
		if (link_img_rship == URLS_UNRELATED && link_rship != URLS_SAME_HOST) {
			PRINT_SCORE("+15 (link UNRELATED to img) && (link NOT SAME HOST as page)")
			score += 15;
		}
	} else if (img_rship == URLS_SAME_HOST && img_status != URL_SUSPICIOUS) {
		PRINT_SCORE("-15 (link SAME HOST as page) && (img NOT SUSPICIOUS)");
		score -= 15;
	}
	if (img_status == URL_INNOCENT) {
		PRINT_SCORE("-10 img INNOCENT");
		score -= 10;
	} else if (img_status == URL_SUSPICIOUS) {
		PRINT_SCORE("+35 img SUSPICIOUS");
		score += 35;
	}
	
	PRINT_SCORE("URLS SCORE: " << score);
	m_score += score;
}

void
ImageHeuristicScore::processLinkTarget(BString const& target)
{
	if (target.empty()) {
		PRINT_SCORE("-5 no target");
		m_score -= 5;
	} else if (target == BString("_blank") || target == BString("_new")) {
		PRINT_SCORE("+20 target=_blank");
		m_score += 20;
	} else if (target == BString("_top")) {
		PRINT_SCORE("+10 target=_top");
		m_score += 10;
	}
}

void
ImageHeuristicScore::processNoscript(bool val)
{
	if (val) {
		PRINT_SCORE("+35 inside <noscript>");
		m_score += 35;
	}
}

void
ImageHeuristicScore::processAssociatedMap(bool val)
{
	if (val) {
		m_score -= 25;
	}
}

void
ImageHeuristicScore::processAnimation(bool val)
{
	if (val) {
		m_score += 70;
	} else {
		m_score -= 30;
	}
}

void
ImageHeuristicScore::processScriptLevel(int level, bool external)
{
	PRINT_SCORE("SCRIPT LEVEL: " << level << ", external: " << external);
	if (level > 1) {
		m_score += 5;
		if (external) {
			m_score += 20;
		}
	} else if (level > 0) {
		m_score += 5;
		if (external) {
			m_score += 10;
		}
	}
	
}

void
ImageHeuristicScore::processScriptRedirect(bool val)
{
	if (val) {
		m_score += 30;
	}
}

void
ImageHeuristicScore::processScriptPersistentCookies(bool val)
{
	if (val) {
		m_score += 30;
	}
}
