// Config.h: interface for the CConfig class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CONFIG_H__F1D55E02_1F15_4A9F_A402_2BB87DD17C26__INCLUDED_)
#define AFX_CONFIG_H__F1D55E02_1F15_4A9F_A402_2BB87DD17C26__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef _WIN32
    #pragma warning(disable:4786 4503)
#endif
#include <string>
#include <vector>
#include <map>

#include <wx/string.h>

class CConfig  
{
public:
	CConfig();
	virtual ~CConfig();
    
    void Load();
    void Unload();
    const char *GetServerAddress();
    const unsigned long GetServerPort();
    int GetServiceEnabled();

protected:
    const char *CConfig::FindValue(char *pszSection, char *pszKey);

private:
    char **SplitString(const char *psStr, int iLength, char cSep);
    wxString CConfig::GetGlobalDir();

// Members
private:
    std::map<std::string, std::vector<std::pair<std::string, std::string> > > m_oMapConfig;
    typedef std::map<std::string, std::vector<std::pair<std::string, std::string> > >::iterator ConfigMapIT;
    typedef std::vector<std::pair<std::string, std::string> >::iterator ConfigVecIT;
};

#endif // !defined(AFX_CONFIG_H__F1D55E02_1F15_4A9F_A402_2BB87DD17C26__INCLUDED_)
