/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

int c_CloseAllSessions()
{
	int errors = 0;
	CK_SLOT_ID slotID1;
	CK_SESSION_HANDLE session1, session2;
	CK_SESSION_INFO info;

	printf("C_CloseAllSessions\n");

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}

	if (p11->C_CloseAllSessions(12345) != CKR_SLOT_ID_INVALID) {
		printf("    ERR: C_CloseAllSessions(1) didn't return CKR_SLOT_ID_INVALID\n");
		errors++;
	}

	slotID1 = getFirstSlot(1);

	if (p11->C_OpenSession(slotID1, CKF_SERIAL_SESSION, NULL_PTR, NULL_PTR, &session1) != CKR_OK) {
		printf("    ERR: C_OpenSession(2) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_OpenSession(slotID1, CKF_SERIAL_SESSION, NULL_PTR, NULL_PTR, &session2) != CKR_OK) {
		printf("    ERR: C_OpenSession(2) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_CloseAllSessions(slotID1) != CKR_OK) {
		printf("    ERR: C_CloseAllSessions(2) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_GetSessionInfo(session1, &info) != CKR_SESSION_HANDLE_INVALID) {
		printf("    ERR: C_GetSessionInfo(2) didn't return CKR_SESSION_HANDLE_INVALID\n");
		errors++;
	}
	if (p11->C_GetSessionInfo(session2, &info) != CKR_SESSION_HANDLE_INVALID) {
		printf("    ERR: C_GetSessionInfo(2) didn't return CKR_SESSION_HANDLE_INVALID\n");
		errors++;
	}

	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_CloseAllSessions(session1) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    ERR: C_CloseSession(3) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	return errors;
}

