// TLV.h: interface for the CTLV class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TLV_H__32C8BE0E_67DE_46C9_92F5_DDBE4B2B7372__INCLUDED_)
#define AFX_TLV_H__32C8BE0E_67DE_46C9_92F5_DDBE4B2B7372__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "MyBytearray.h"

namespace eidviewer
{

class CTLV  
{
public:
	CTLV();
	CTLV(unsigned char ucTag, unsigned char *pucData, unsigned long ulLen);
	CTLV(const CTLV & oTlv);

	virtual ~CTLV();

    void SetTag(unsigned char ucTag);
    void SetData(unsigned char *pucData, unsigned long ulLen);
    unsigned char GetTag();
    unsigned char *GetData();
    unsigned long GetLength();

private:
    unsigned char m_ucTag;
    CMyByteArray m_Data;
};

} // namespace

#endif // !defined(AFX_TLV_H__32C8BE0E_67DE_46C9_92F5_DDBE4B2B7372__INCLUDED_)
