    // ConnectionMessage_OpenBack.cpp: implementation of the CConnectionMessage_OpenBack class. 
    // 
    ////////////////////////////////////////////////////////////////////// 
     
 #include <stddef.h> 
 #include <string.h> 
    #include "../../Include/Comm/ConnectionMessage_OpenBack.h" 
           
#ifdef PASS_CHECKMEMORY 
#define new PASS_new 
#define delete PASS_delete 
#endif // PASS_CHECKMEMORY 
 
    ////////////////////////////////////////////////////////////////////// 
    // Construction/Destruction 
    ////////////////////////////////////////////////////////////////////// 
     
    CConnectionMessage_OpenBack::CConnectionMessage_OpenBack() : CMessage ("ConnectionMessage_OpenBack") 
    { 
    	m_BackPort = 0; 
    	m_BackIP = NULL; 
    	m_BackName = NULL; 
    } 
     
    CConnectionMessage_OpenBack::~CConnectionMessage_OpenBack() 
    { 
    	if (m_BackIP != NULL) 
    	{ 
    		delete m_BackIP; 
    	} 
    	if (m_BackName != NULL) 
    	{ 
    		delete m_BackName; 
    	} 
    } 
     
    void CConnectionMessage_OpenBack::SetBackIP (char *backIP) 
    { 
    	if (backIP != NULL) 
    	{ 
    		if (m_BackIP != NULL) 
    		{ 
    			delete [] m_BackIP; 
    		} 
    		m_BackIP = new char [(strlen (backIP)) + 1]; 
    		strcpy (m_BackIP,backIP); 
    	} 
    } 
     
    void CConnectionMessage_OpenBack::SetBackName (char *name) 
    { 
    	if (name != NULL) 
    	{ 
    		if (m_BackName != NULL) 
    		{ 
    			delete [] m_BackName; 
    		} 
    		m_BackName = new char [(strlen (name)) + 1]; 
    		strcpy (m_BackName,name); 
    	} 
    } 
     
    void CConnectionMessage_OpenBack::SetBackPort (unsigned short port) 
    { 
    	m_BackPort = port; 
    } 
     
    char *CConnectionMessage_OpenBack::GetBackIP (void) 
    { 
    	return m_BackIP; 
    } 
     
    char *CConnectionMessage_OpenBack::GetBackName (void) 
    { 
    	return m_BackName; 
    } 
     
    unsigned short CConnectionMessage_OpenBack::GetBackPort (void) 
    { 
    	return m_BackPort; 
    } 
     
    BOOL CConnectionMessage_OpenBack::Serialize (void) 
    { 
    	CMessage::Serialize (); 
     
    	AddCharToSerialObject (m_BackIP, serializedObject); 
    	AddCharToSerialObject (m_BackName, serializedObject); 
    	AddULongToSerialObject ((long)m_BackPort, serializedObject); 
     
    	return TRUE; 
    } 
     
    BOOL CConnectionMessage_OpenBack::UnSerialize (struct SerializedObject* anObject) 
    { 
    	CMessage::UnSerialize (anObject); 
     
    	m_BackIP = GetCharFromSerialObject (serializedObject); 
    	m_BackName = GetCharFromSerialObject (serializedObject); 
    	m_BackPort = (unsigned short)GetULongFromSerialObject (serializedObject); 
     
    	return TRUE; 
    } 
 
CObject* CConnectionMessage_OpenBack::Clone (void) 
{ 
        CConnectionMessage_OpenBack *tempObject = new CConnectionMessage_OpenBack; 
 
        tempObject->SetName ("ConnectionMessage_OpenBack"); 
 
        return (CObject *) tempObject; 
} 
 
