/* supporting functions by platforms */

#ifdef __HPUX__

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>

int internal_usleep (unsigned int useconds)
{
	struct timeval tempVal;
	
	if (useconds <= 0)
	{
		return -1;
	}

	tempVal.tv_sec = useconds / 1000000;
	tempVal.tv_usec = useconds % 1000000;

	if (select(0,NULL,NULL,NULL,&tempVal) == -1)
	{
		perror ("sleep with select");
	}
	
	return 0;	
}

#endif // __HPUX__
