// Connection_Mono.h: interface for the CConnection_Mono class.
//
//////////////////////////////////////////////////////////////////////

#ifndef __CONNECTION_MONO__
#define __CONNECTION_MONO__

// Platform specific definitions
#include "../Base/platform.h"

#include "../Comm/Connection.h"

#ifdef PASS_SSL
#include <openssl/ssl.h>
#endif //PASS_SSL
        
class CMessageStack;
class CConnectionSocket;
class CServerSession;
class CStringToObjectCollection;

class CConnection_Mono : public CConnection  
{
public:
	CConnection_Mono();
	virtual ~CConnection_Mono();

	void SetSocket (CConnectionSocket *aSocket);
	CConnectionSocket *GetSocket (void);

	BOOL Open (void);
	BOOL Close (void);

	CMessage *GetMessageForID (unsigned long messageID);
    CMessage *WaitMessageForID (unsigned long messageID);

	unsigned long SendMessage (CMessage *);

    CMessageStack *GetReceiveStack (void);
    CMessageStack *GetSendStack (void);

	void SetServerSession (CServerSession *aSession);

	BOOL SetConnectionParam (CStringToObjectCollection *param);

	void Tick (void);

#ifdef PASS_SSL
    void SetSecuredConnection (BOOL flag);
    void SetSSLCTX (SSL_CTX *ctx);
    void SetCertificateFile (char *file);
    char *GetCertificateFile (void);
    void SetPrivateKeyFile (char *file);
	void SetPrivateKeyPassword (char *pass);
	char *GetPrivateKeyPassword (void);
#endif //PASS_SSL

private:

	CMessage *_GetMessageForID (unsigned long messageID);

public:

	BOOL m_bOpenBackSent;
	BOOL m_bCloseSent;
	BOOL m_bServerConnection;

protected:
	CConnectionSocket *m_ConnectionSocket;
	CMessageStack *m_ReceiveStack;
	CMessageStack *m_SendStack;


	CServerSession *m_ServerSession;

	BOOL m_bConnectionOpened;

	PASS_SYNCH lock;

#ifdef PASS_SSL
    BOOL m_bSecuredConnection;
    SSL_CTX* m_SSLctx;
    SSL*     m_SSLssl;
    SSL_METHOD *m_SSLmeth;
	char *m_szCertificateFile;
    char *m_szPrivateKeyFile;
	char m_szPrivateKeyPassword[256];
#endif //PASS_SSL
        
private:

	unsigned long m_ulMessageIDCounter;
	unsigned long m_WaitMessageTimeOut;

	// Server parameters
	char m_szServerAddress[20];
	char m_szServerName[256];
	unsigned short m_usServerPort;
};

#endif // __CONNECTION_MONO__
