  // ConnectionSender.h: interface for the CConnectionSender class.
    //
    //////////////////////////////////////////////////////////////////////
    
#ifndef __CONNECTIONSENDER__
#define __CONNECTIONSENDER__

// Platform specific definitions
#include "../Base/platform.h"

#ifdef linux 
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#endif //linux

#ifdef __SCO__
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#endif // __SCO__

#ifdef __HPUX__
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#endif // __HPUX__

#ifdef _WIN32
#include <windows.h>
#endif //_WIN32

#include "../../Include/Base/Thread.h"

#ifdef PASS_SSL
    #include <openssl/ssl.h>
    #include <openssl/x509.h>
#endif //PASS_SSL
    
    class CMessageStack;
    
    class CConnectionSender : public CThread
    {
    public:
    	CConnectionSender();
    	virtual ~CConnectionSender();
    
    	BOOL Init (void);
    
    	void PreRun (void);
    	void PostRun (void);
    
    	void SetRemoteServerIP (char *);

#ifdef linux
  	void SetClientSocket (int clientSocket);
#endif //linux

    	void SetRemoteServerName (char *);
    
    	void SetRemoteServerPort (unsigned short);
    
    	void SetStack (CMessageStack *aStack);
    
    	BOOL SendObject (struct SerializedObject *);
    
    	void Tick (void);
    
#ifdef PASS_SSL
    	// SSL
    	void SetSecuredConnection (BOOL flag);
    	void SetCertificateFile (char *file);
#endif //PASS_SSL
    
    protected:
    
    	unsigned short m_RemoteServerPort;
    	char *m_RemoteServerName;
    	char *m_RemoteServerIP;

#ifdef linux
  	int m_ClientSocket;
#endif //linux
    
    	BOOL m_bInitOK;

	PASS_SYNCH lock;    
    
    	int sockfd;
    	struct sockaddr_in servaddr;
    
    	CMessageStack *m_SendStack;
    
#ifdef PASS_SSL
    	// SSL
    	BOOL m_bSecuredConnection;
    	SSL_CTX* m_SSLctx;
    	SSL*     m_SSLssl;
    	SSL_METHOD *m_SSLmeth;
    	char *m_szCertificateFile;
#endif //PASS_SSL
    };
    
#endif // __CONNECTIONSENDER__
